/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.ehcache.Cache;
import org.ehcache.config.EvictionVeto;
import org.ehcache.events.CacheEvents;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.function.Predicate;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.spi.cache.CacheStoreHelper;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.cache.tiering.LowerCachingTier;
import org.ehcache.statistics.StoreOperationOutcomes;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.observer.OperationObserver;

public abstract class AbstractOffHeapStore<K, V>
implements AuthoritativeTier<K, V>,
LowerCachingTier<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TimeSource timeSource;
    private final Expiry<? super K, ? super V> expiry;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getOperationObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putOperationObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeOperationObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private volatile Callable<Void> valve;
    private volatile StoreEventListener<K, V> eventListener = CacheEvents.nullStoreEventListener();
    protected BackingMapEvictionListener<K, V> mapEvictionListener;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public AbstractOffHeapStore(String statisticsTag, Store.Configuration<K, V> config, TimeSource timeSource) {
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        this.timeSource = timeSource;
        this.getOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of((Object)this)).named("get")).tag(new String[]{statisticsTag})).build();
        this.putOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of((Object)this)).named("put")).tag(new String[]{statisticsTag})).build();
        this.removeOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of((Object)this)).named("remove")).tag(new String[]{statisticsTag})).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).of((Object)this)).named("eviction")).tag(new String[]{statisticsTag})).build();
        this.mapEvictionListener = new BackingMapEvictionListener(this.evictionObserver);
    }

    public Store.ValueHolder<V> get(K key) {
        this.checkKey(key);
        this.getOperationObserver.begin();
        Store.ValueHolder<V> result = this.internalGet(key, true);
        if (result == null) {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        }
        return result;
    }

    private Store.ValueHolder<V> internalGet(K key, final boolean updateAccess) {
        return (Store.ValueHolder)this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                if (updateAccess) {
                    AbstractOffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                }
                return mappedValue;
            }
        }, false);
    }

    public boolean containsKey(K key) {
        this.checkKey(key);
        return this.internalGet(key, false) != null;
    }

    public void put(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.putOperationObserver.begin();
        while (true) {
            final long now = this.timeSource.getTimeMillis();
            try {
                this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                    public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                        if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                            mappedValue = null;
                        }
                        if (mappedValue == null) {
                            return AbstractOffHeapStore.this.newCreateValueHolder(key, value, now);
                        }
                        return AbstractOffHeapStore.this.newUpdatedValueHolder(key, value, mappedValue, now);
                    }
                }, false);
                return;
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, final V value) throws NullPointerException, CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference returnValue = new AtomicReference();
        while (true) {
            try {
                this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                    public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                        long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                        if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                            if (mappedValue != null) {
                                AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                            }
                            return AbstractOffHeapStore.this.newCreateValueHolder(mappedKey, value, now);
                        }
                        returnValue.set(mappedValue);
                        AbstractOffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                        return mappedValue;
                    }
                }, false);
                return (Store.ValueHolder)returnValue.get();
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        this.checkKey(key);
        this.removeOperationObserver.begin();
        try {
            this.backingMap().remove(key);
        }
        finally {
            this.removeOperationObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.SUCCESS);
        }
    }

    public boolean remove(K key, final V value) throws NullPointerException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    return null;
                }
                if (mappedValue.value().equals(value)) {
                    removed.set(true);
                    return null;
                }
                AbstractOffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                return mappedValue;
            }
        });
        return removed.get();
    }

    public Store.ValueHolder<V> replace(K key, final V value) throws NullPointerException, CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                returnValue.set(mappedValue);
                return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, value, mappedValue, now);
            }
        };
        while (true) {
            try {
                this.backingMap().compute(key, mappingFunction, false);
                return returnValue.get();
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    public boolean replace(K key, final V oldValue, final V newValue) throws NullPointerException, IllegalArgumentException, CacheAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicBoolean replaced = new AtomicBoolean(false);
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                if (oldValue.equals(mappedValue.value())) {
                    replaced.set(true);
                    return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, newValue, mappedValue, now);
                }
                AbstractOffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                return mappedValue;
            }
        };
        while (true) {
            try {
                this.backingMap().compute(key, mappingFunction, false);
                return replaced.get();
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            break;
        }
    }

    public void clear() throws CacheAccessException {
        this.backingMap().clear();
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
        this.eventListener = listener;
        ((BackingMapEvictionListener)this.mapEvictionListener).setStoreEventListener(this.eventListener);
    }

    public void disableStoreEventNotifications() {
        this.eventListener = CacheEvents.nullStoreEventListener();
        ((BackingMapEvictionListener)this.mapEvictionListener).setStoreEventListener(this.eventListener);
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() throws CacheAccessException {
        return new OffHeapStoreIterator();
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                Object existingValue = null;
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    mappedValue = null;
                } else {
                    existingValue = mappedValue.value();
                }
                Object computedValue = mappingFunction.apply(mappedKey, existingValue);
                if (computedValue == null) {
                    return null;
                }
                if (AbstractOffHeapStore.this.safeEquals(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                    }
                    return mappedValue;
                }
                AbstractOffHeapStore.this.checkValue(computedValue);
                if (mappedValue != null) {
                    return AbstractOffHeapStore.this.newUpdatedValueHolder(key, computedValue, mappedValue, now);
                }
                return AbstractOffHeapStore.this.newCreateValueHolder(key, computedValue, now);
            }
        };
        while (true) {
            try {
                return (Store.ValueHolder)this.backingMap().compute(key, computeFunction, false);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            break;
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, false);
    }

    private Store.ValueHolder<V> internalComputeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction, boolean fault) throws CacheAccessException {
        this.checkKey(key);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    Object computedValue;
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    if ((computedValue = mappingFunction.apply(mappedKey)) == null) {
                        return null;
                    }
                    AbstractOffHeapStore.this.checkValue(computedValue);
                    return AbstractOffHeapStore.this.newCreateValueHolder(mappedKey, computedValue, now);
                }
                AbstractOffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                return mappedValue;
            }
        };
        while (true) {
            try {
                return (Store.ValueHolder)this.backingMap().compute(key, computeFunction, fault);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            break;
        }
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                Object computedValue = remappingFunction.apply(mappedKey, mappedValue.value());
                if (computedValue == null) {
                    return null;
                }
                if (AbstractOffHeapStore.this.safeEquals(mappedValue.value(), computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    AbstractOffHeapStore.this.setAccessTimeAndExpiry(mappedKey, mappedValue, now);
                    return mappedValue;
                }
                AbstractOffHeapStore.this.checkValue(computedValue);
                return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, computedValue, mappedValue, now);
            }
        };
        while (true) {
            try {
                return (Store.ValueHolder)this.backingMap().compute(key, computeFunction, false);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            break;
        }
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            BiFunction biFunction = new BiFunction<K, V, V>(){

                public V apply(final K k, final V v) {
                    Map.Entry entry = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return k;
                        }

                        @Override
                        public V getValue() {
                            return v;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    Iterator iterator = ((Iterable)remappingFunction.apply(Collections.singleton(entry))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        AbstractOffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.compute(key, biFunction, replaceEqual);
            result.put(key, computed);
        }
        return result;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Function function = new Function<K, V>(){

                public V apply(K k) {
                    Iterator iterator = ((Iterable)mappingFunction.apply(Collections.singleton(k))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        AbstractOffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.computeIfAbsent(key, function);
            result.put(key, computed);
        }
        return result;
    }

    public Store.ValueHolder<V> getAndFault(K key) throws CacheAccessException {
        this.getOperationObserver.begin();
        this.checkKey(key);
        Store.ValueHolder mappedValue = (Store.ValueHolder)this.backingMap().getAndPin(key);
        if (mappedValue != null && mappedValue.isExpired(this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
            if (this.backingMap().remove(key, mappedValue)) {
                this.eventListener.onExpiration(key, mappedValue);
            }
            mappedValue = null;
        }
        if (mappedValue == null) {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getOperationObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        }
        return mappedValue;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, true);
    }

    public boolean flush(K key, final Store.ValueHolder<V> valueFlushed) {
        this.checkKey(key);
        return this.backingMap().computeIfPinned(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> valuePresent) {
                if (valuePresent.getId() == valueFlushed.getId()) {
                    if (valueFlushed.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), OffHeapValueHolder.TIME_UNIT)) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(k, valuePresent);
                        return null;
                    }
                    valuePresent.updateMetadata(valueFlushed);
                    valuePresent.writeBack();
                }
                return valuePresent;
            }
        }, new Function<OffHeapValueHolder<V>, Boolean>(){

            public Boolean apply(OffHeapValueHolder<V> valuePresent) {
                return valuePresent.getId() == valueFlushed.getId();
            }
        });
    }

    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.eventListener = new StoreEventListener<K, V>(){

            public void onEviction(K key, Store.ValueHolder<V> valueHolder) {
                AbstractOffHeapStore.this.invalidationListener.onInvalidation(key, valueHolder);
            }

            public void onExpiration(K key, Store.ValueHolder<V> valueHolder) {
                AbstractOffHeapStore.this.invalidationListener.onInvalidation(key, valueHolder);
            }
        };
    }

    public void invalidate(final K key) throws CacheAccessException {
        this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> present) {
                AbstractOffHeapStore.this.notifyInvalidation(key, present);
                return null;
            }
        });
    }

    public void invalidate(K key, final NullaryFunction<K> function) throws CacheAccessException {
        this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> offHeapValueHolder) {
                if (offHeapValueHolder != null) {
                    AbstractOffHeapStore.this.notifyInvalidation(k, offHeapValueHolder);
                }
                function.apply();
                return null;
            }
        }, false);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public Store.ValueHolder<V> getAndRemove(K key) throws CacheAccessException {
        this.checkKey(key);
        final AtomicReference valueHolderAtomicReference = new AtomicReference();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    mappedValue = null;
                }
                valueHolderAtomicReference.set(mappedValue);
                return null;
            }
        };
        this.backingMap().compute(key, computeFunction, false);
        return (Store.ValueHolder)valueHolderAtomicReference.get();
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(final K key, final Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
        return (Store.ValueHolder)this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> offHeapValueHolder) {
                if (offHeapValueHolder != null) {
                    throw new AssertionError();
                }
                Store.ValueHolder valueHolder = (Store.ValueHolder)source.apply(k);
                if (valueHolder != null) {
                    if (valueHolder.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.eventListener.onExpiration(key, valueHolder);
                        return null;
                    }
                    return AbstractOffHeapStore.this.newTransferValueHolder(valueHolder);
                }
                return null;
            }
        }, false);
    }

    public void registerEmergencyValve(Callable<Void> valve) {
        this.valve = valve;
    }

    private boolean safeEquals(V existingValue, V computedValue) {
        return existingValue == computedValue || existingValue != null && existingValue.equals(computedValue);
    }

    private void setAccessTimeAndExpiry(K key, OffHeapValueHolder<V> valueHolder, long now) {
        valueHolder.accessed(now, this.expiry.getExpiryForAccess(key, valueHolder.value()));
        valueHolder.writeBack();
    }

    private OffHeapValueHolder<V> newUpdatedValueHolder(K key, V value, OffHeapValueHolder<V> existing, long now) {
        Duration duration = this.expiry.getExpiryForUpdate(key, existing.value(), value);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration == null) {
            return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, existing.expirationTime(OffHeapValueHolder.TIME_UNIT));
        }
        if (duration.isForever()) {
            return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, AbstractOffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newCreateValueHolder(K key, V value, long now) {
        Duration duration = this.expiry.getExpiryForCreation(key, value);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration.isForever()) {
            return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, AbstractOffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newTransferValueHolder(Store.ValueHolder<V> valueHolder) {
        return new OffHeapValueHolder<Object>(valueHolder.getId(), valueHolder.value(), valueHolder.creationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.expirationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.lastAccessTime(OffHeapValueHolder.TIME_UNIT), valueHolder.hits(), null);
    }

    public void handleOversizeMappingException(K key, OversizeMappingException cause) throws CacheAccessException {
        this.handleOversizeMappingException(key, cause, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOversizeMappingException(K key, OversizeMappingException cause, AtomicBoolean invokeValve) throws CacheAccessException {
        if (!this.backingMap().shrinkOthers(key.hashCode()) && !this.invokeValve(invokeValve)) {
            for (Segment<K, OffHeapValueHolder<V>> segment : this.backingMap().getSegments()) {
                Lock lock = segment.writeLock();
                lock.lock();
                try {
                    for (Object keyToEvict : segment.keySet()) {
                        if (this.backingMap().getAndSetMetadata(keyToEvict, 0x20000000, 0) != 0x20000000) continue;
                        return;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            throw new CacheAccessException("The element with key '" + key + "' is too large to be stored" + " in this offheap store.", (Throwable)cause);
        }
    }

    private boolean invokeValve(AtomicBoolean invokeValve) throws CacheAccessException {
        if (invokeValve == null || !invokeValve.get()) {
            return false;
        }
        invokeValve.set(false);
        Callable<Void> valve = this.valve;
        if (valve != null) {
            try {
                valve.call();
            }
            catch (Exception exception) {
                throw new CacheAccessException("Failed invoking valve", (Throwable)exception);
            }
        }
        return true;
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OffHeapValueHolder.TIME_UNIT.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    protected abstract EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap();

    protected static <K, V> Predicate<Map.Entry<K, OffHeapValueHolder<V>>> wrap(EvictionVeto<? super K, ? super V> delegate, TimeSource timeSource) {
        return new OffHeapEvictionVetoWrapper(delegate, timeSource);
    }

    static class BackingMapEvictionListener<K, V>
    implements EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, OffHeapValueHolder<V>> {
        private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
        private StoreEventListener<K, V> storeEventListener;

        private BackingMapEvictionListener(OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver) {
            this.evictionObserver = evictionObserver;
            this.storeEventListener = CacheEvents.nullStoreEventListener();
        }

        private void setStoreEventListener(StoreEventListener<K, V> storeEventListener) {
            if (storeEventListener == null) {
                throw new NullPointerException("store event listener cannot be null");
            }
            this.storeEventListener = storeEventListener;
        }

        @Override
        public void onEviction(K key, OffHeapValueHolder<V> value) {
            this.evictionObserver.begin();
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            this.storeEventListener.onEviction(key, value);
        }
    }

    class OffHeapStoreIterator
    implements Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> {
        private final Iterator<Map.Entry<K, OffHeapValueHolder<V>>> mapIterator;

        OffHeapStoreIterator() {
            this.mapIterator = AbstractOffHeapStore.this.backingMap().entrySet().iterator();
        }

        public boolean hasNext() throws CacheAccessException {
            return this.mapIterator.hasNext();
        }

        public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
            final Map.Entry next = this.mapIterator.next();
            return new Cache.Entry<K, Store.ValueHolder<V>>(){

                public K getKey() {
                    return next.getKey();
                }

                public Store.ValueHolder<V> getValue() {
                    return (Store.ValueHolder)next.getValue();
                }

                public long getCreationTime(TimeUnit unit) {
                    return ((OffHeapValueHolder)((Object)next.getValue())).creationTime(unit);
                }

                public long getLastAccessTime(TimeUnit unit) {
                    return ((OffHeapValueHolder)((Object)next.getValue())).lastAccessTime(unit);
                }

                public float getHitRate(TimeUnit unit) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    return ((OffHeapValueHolder)((Object)next.getValue())).hitRate(now, unit);
                }
            };
        }
    }

    private static class OffHeapEvictionVetoWrapper<K, V>
    implements Predicate<Map.Entry<K, OffHeapValueHolder<V>>> {
        private final EvictionVeto<K, V> delegate;
        private final TimeSource timeSource;

        private OffHeapEvictionVetoWrapper(EvictionVeto<? super K, ? super V> delegate, TimeSource timeSource) {
            this.delegate = delegate;
            this.timeSource = timeSource;
        }

        public boolean test(Map.Entry<K, OffHeapValueHolder<V>> argument) {
            return this.delegate.test((Object)CacheStoreHelper.cacheEntry(argument.getKey(), (Store.ValueHolder)((Store.ValueHolder)argument.getValue()), (TimeSource)this.timeSource));
        }
    }
}

