/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.internal.store.heap.OnHeapValueHolder;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.serialization.Serializer;

class ByValueOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final ByteBuffer buffer;
    private final int hash;
    private final Serializer<V> serializer;

    protected ByValueOnHeapValueHolder(V value, long creationTime, Serializer<V> serializer) {
        this(value, creationTime, -1L, serializer);
    }

    protected ByValueOnHeapValueHolder(V value, long creationTime, long expirationTime, Serializer<V> serializer) {
        super(-1L, creationTime, expirationTime);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (serializer == null) {
            throw new NullPointerException("null serializer");
        }
        this.serializer = serializer;
        this.hash = value.hashCode();
        try {
            this.buffer = serializer.serialize(value).asReadOnlyBuffer();
        }
        catch (IOException ioe) {
            throw new SerializerException((Throwable)ioe);
        }
    }

    protected ByValueOnHeapValueHolder(Store.ValueHolder<V> valueHolder, Serializer<V> serializer) {
        this(valueHolder.value(), valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT), serializer);
        this.setLastAccessTime(valueHolder.lastAccessTime(TIME_UNIT), TIME_UNIT);
        this.setHits(valueHolder.hits());
    }

    public final V value() {
        try {
            return (V)this.serializer.read(this.buffer.duplicate());
        }
        catch (IOException ioe) {
            throw new SerializerException((Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        ByValueOnHeapValueHolder that = (ByValueOnHeapValueHolder)((Object)other);
        if (!super.equals((Object)that)) {
            return false;
        }
        try {
            if (!this.serializer.equals(that.value(), this.buffer)) {
                return false;
            }
        }
        catch (IOException ioe) {
            throw new SerializerException((Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.hash;
        result = 31 * result + super.hashCode();
        return result;
    }
}

