/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap;

import org.ehcache.internal.store.heap.OnHeapValueHolder;
import org.ehcache.spi.cache.Store;

class ByRefOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final V value;

    protected ByRefOnHeapValueHolder(V value, long createTime) {
        super(-1L, createTime);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.value = value;
    }

    protected ByRefOnHeapValueHolder(V value, long creationTime, long expirationTime) {
        this(-1L, value, creationTime, expirationTime);
    }

    protected ByRefOnHeapValueHolder(long id, V value, long creationTime, long expirationTime) {
        super(id, creationTime, expirationTime);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.value = value;
    }

    protected ByRefOnHeapValueHolder(Store.ValueHolder<V> valueHolder) {
        this(valueHolder.getId(), valueHolder.value(), valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT));
        this.setLastAccessTime(valueHolder.lastAccessTime(TIME_UNIT), TIME_UNIT);
        this.setHits(valueHolder.hits());
    }

    public final V value() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        ByRefOnHeapValueHolder that = (ByRefOnHeapValueHolder)((Object)other);
        if (!super.equals((Object)that)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }
}

