/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.config.persistence.PersistenceConfiguration;
import org.ehcache.exceptions.CachePersistenceException;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.service.FileBasedPersistenceContext;
import org.ehcache.spi.service.LocalPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalPersistenceService
implements LocalPersistenceService {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final int DEL = 127;
    private static final char ESCAPE = '%';
    private static final Set<Character> ILLEGALS = new HashSet<Character>();
    private final ConcurrentMap<String, FileBasedPersistenceContext> knownPersistenceContexts = new ConcurrentHashMap<String, FileBasedPersistenceContext>();
    private final File rootDirectory;
    private final File lockFile;
    private FileLock lock;
    private RandomAccessFile rw;
    private static final Logger LOGGER;
    private boolean started;

    public DefaultLocalPersistenceService(PersistenceConfiguration persistenceConfiguration) {
        if (persistenceConfiguration == null) {
            throw new NullPointerException("PersistenceConfiguration cannot be null");
        }
        this.rootDirectory = persistenceConfiguration.getRootDirectory();
        this.lockFile = new File(this.rootDirectory, ".lock");
    }

    public synchronized void start(ServiceProvider serviceProvider) {
        if (!this.started) {
            DefaultLocalPersistenceService.createLocationIfRequiredAndVerify(this.rootDirectory);
            try {
                this.rw = new RandomAccessFile(this.lockFile, "rw");
                this.lock = this.rw.getChannel().lock();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't lock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = true;
            LOGGER.debug("RootDirectory Locked");
        }
    }

    public synchronized void stop() {
        if (this.started) {
            try {
                this.lock.release();
                this.rw.close();
                if (!this.lockFile.delete()) {
                    LOGGER.debug("Lock file was not deleted {}.", (Object)this.lockFile.getPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't unlock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = false;
            LOGGER.debug("RootDirectory Unlocked");
        }
    }

    static void createLocationIfRequiredAndVerify(File rootDirectory) {
        if (!rootDirectory.exists()) {
            if (!rootDirectory.mkdirs()) {
                throw new IllegalArgumentException("Directory couldn't be created: " + rootDirectory.getAbsolutePath());
            }
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Location is not a directory: " + rootDirectory.getAbsolutePath());
        }
        if (!rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Location isn't writable: " + rootDirectory.getAbsolutePath());
        }
    }

    public FileBasedPersistenceContext createPersistenceContext(Object identifier, Store.PersistentStoreConfiguration<?, ?, ?> storeConfiguration) throws CachePersistenceException {
        DefaultFileBasedPersistenceContext context;
        String stringIdentifier = DefaultLocalPersistenceService.validateIdentifier(identifier);
        if (this.knownPersistenceContexts.putIfAbsent(stringIdentifier, context = new DefaultFileBasedPersistenceContext(this.getDirectoryFor(stringIdentifier))) == null) {
            if (!storeConfiguration.isPersistent()) {
                DefaultLocalPersistenceService.destroy(stringIdentifier, context, false);
            }
            try {
                DefaultLocalPersistenceService.create(context);
            }
            catch (IOException e) {
                this.knownPersistenceContexts.remove(stringIdentifier, context);
                throw new CachePersistenceException("Unable to create persistence context for " + identifier, (Throwable)e);
            }
            return context;
        }
        throw new CachePersistenceException("Identifier '" + identifier + "' already created by this persistence service");
    }

    public void destroyPersistenceContext(Object identifier) throws CachePersistenceException {
        String stringIdentifier = DefaultLocalPersistenceService.validateIdentifier(identifier);
        FileBasedPersistenceContext persistenceContext = (FileBasedPersistenceContext)this.knownPersistenceContexts.remove(stringIdentifier);
        if (persistenceContext == null) {
            DefaultLocalPersistenceService.destroy(stringIdentifier, new DefaultFileBasedPersistenceContext(this.getDirectoryFor(stringIdentifier)), true);
        } else {
            DefaultLocalPersistenceService.destroy(stringIdentifier, persistenceContext, true);
        }
    }

    public void destroyAllPersistenceContext() {
        if (DefaultLocalPersistenceService.recursiveDeleteDirectoryContent(this.rootDirectory)) {
            LOGGER.info("Destroyed all file based persistence context");
        } else {
            LOGGER.warn("Could not delete all file based persistence context");
        }
    }

    File getLockFile() {
        return this.lockFile;
    }

    public File getDirectoryFor(String identifier) {
        File directory = new File(this.rootDirectory, DefaultLocalPersistenceService.safeIdentifier(identifier));
        for (File parent = directory.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!this.rootDirectory.equals(parent)) continue;
            return directory;
        }
        throw new IllegalArgumentException("Attempted to access file outside the persistence path");
    }

    private static String validateIdentifier(Object identifier) {
        if (identifier instanceof String) {
            return (String)identifier;
        }
        throw new IllegalArgumentException("Currently only String identifiers are supported");
    }

    static void create(FileBasedPersistenceContext fileBasedPersistenceContext) throws IOException, CachePersistenceException {
        File persistenceDirectory = fileBasedPersistenceContext.getDirectory();
        if (persistenceDirectory.isDirectory()) {
            LOGGER.info("Reusing " + persistenceDirectory.getAbsolutePath());
        } else if (persistenceDirectory.mkdir()) {
            LOGGER.info("Created " + persistenceDirectory.getAbsolutePath());
        } else {
            throw new CachePersistenceException("Unable to create or reuse persistence context state: " + persistenceDirectory.getAbsolutePath());
        }
    }

    static void destroy(String identifier, FileBasedPersistenceContext fileBasedPersistenceContext, boolean verbose) {
        if (verbose) {
            LOGGER.info("Destroying file based persistence context for {}", (Object)identifier);
        }
        if (fileBasedPersistenceContext.getDirectory().exists() && !DefaultLocalPersistenceService.tryRecursiveDelete(fileBasedPersistenceContext.getDirectory()) && verbose) {
            LOGGER.warn("Could not delete directory for context {}", (Object)identifier);
        }
    }

    private static boolean recursiveDeleteDirectoryContent(File file) {
        File[] contents;
        Boolean deleteSuccessful = true;
        if (file.isDirectory() && (contents = file.listFiles()).length > 0) {
            for (File f : contents) {
                if (DefaultLocalPersistenceService.tryRecursiveDelete(f)) continue;
                deleteSuccessful = false;
            }
        }
        return deleteSuccessful;
    }

    private static boolean recursiveDelete(File file) {
        ArrayDeque<File> toDelete = new ArrayDeque<File>();
        toDelete.push(file);
        while (!toDelete.isEmpty()) {
            File target = (File)toDelete.pop();
            if (target.isFile()) {
                if (target.delete()) continue;
                return false;
            }
            if (!target.isDirectory()) continue;
            File[] contents = target.listFiles();
            if (contents.length == 0) {
                if (target.delete()) continue;
                return false;
            }
            toDelete.push(target);
            for (File f : contents) {
                toDelete.push(f);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryRecursiveDelete(File file) {
        boolean interrupted = false;
        try {
            for (int i = 0; i < 5; ++i) {
                if (DefaultLocalPersistenceService.recursiveDelete(file) || !DefaultLocalPersistenceService.isWindows()) {
                    boolean bl = true;
                    return bl;
                }
                System.gc();
                System.runFinalization();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private static String safeIdentifier(String name) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || ILLEGALS.contains(Character.valueOf(c)) || c == '%') {
                sb.append('%');
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(c);
        }
        sb.append("_").append(DefaultLocalPersistenceService.sha1(name));
        return sb.toString();
    }

    private static String sha1(String input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : DefaultLocalPersistenceService.getSha1Digest().digest(input.getBytes(UTF8))) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    private static MessageDigest getSha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"All JDKs must have SHA-1");
        }
    }

    static {
        ILLEGALS.add(Character.valueOf('/'));
        ILLEGALS.add(Character.valueOf('\\'));
        ILLEGALS.add(Character.valueOf('<'));
        ILLEGALS.add(Character.valueOf('>'));
        ILLEGALS.add(Character.valueOf(':'));
        ILLEGALS.add(Character.valueOf('\"'));
        ILLEGALS.add(Character.valueOf('|'));
        ILLEGALS.add(Character.valueOf('?'));
        ILLEGALS.add(Character.valueOf('*'));
        ILLEGALS.add(Character.valueOf('.'));
        LOGGER = LoggerFactory.getLogger(DefaultLocalPersistenceService.class);
    }

    private static class DefaultFileBasedPersistenceContext
    implements FileBasedPersistenceContext {
        final File directory;

        DefaultFileBasedPersistenceContext(File directory) {
            this.directory = directory;
        }

        public File getDirectory() {
            return this.directory;
        }
    }
}

