/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.events;

import org.ehcache.events.CacheEventNotificationListenerServiceProvider;
import org.ehcache.events.CacheEventNotificationService;
import org.ehcache.events.CacheEventNotificationServiceImpl;
import org.ehcache.events.DisabledCacheEventNotificationService;
import org.ehcache.internal.SystemTimeSource;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceConfiguration;
import org.ehcache.internal.TimeSourceService;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ThreadPoolsService;

@ServiceDependencies(value={TimeSourceService.class, ThreadPoolsService.class})
public class CacheEventNotificationListenerServiceProviderImpl
implements CacheEventNotificationListenerServiceProvider {
    private volatile ServiceProvider serviceProvider;

    public void start(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void stop() {
        this.serviceProvider = null;
    }

    public <K, V> CacheEventNotificationService<K, V> createCacheEventNotificationService(Store<K, V> store, ServiceConfiguration<?> ... serviceConfigs) {
        TimeSource timeSource;
        ThreadPoolsService threadPoolsService = (ThreadPoolsService)this.serviceProvider.getService(ThreadPoolsService.class);
        TimeSourceConfiguration timeSourceConfig = (TimeSourceConfiguration)ServiceLocator.findSingletonAmongst(TimeSourceConfiguration.class, (Object[])serviceConfigs);
        TimeSource timeSource2 = timeSource = timeSourceConfig != null ? timeSourceConfig.getTimeSource() : SystemTimeSource.INSTANCE;
        if (threadPoolsService != null) {
            return new CacheEventNotificationServiceImpl(threadPoolsService.getEventsOrderedDeliveryExecutor(), threadPoolsService.getEventsUnorderedDeliveryExecutor(), store, timeSource);
        }
        return new DisabledCacheEventNotificationService();
    }

    public <K, V> void releaseCacheEventNotificationService(CacheEventNotificationService<K, V> cenlService) {
        if (cenlService != null) {
            cenlService.releaseAllListeners();
        }
    }
}

