/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.classes;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.internal.classes.ClassInstanceConfiguration;
import org.ehcache.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.ServiceConfiguration;

public class ClassInstanceProvider<T> {
    protected final Map<String, Class<? extends T>> preconfiguredLoaders = Collections.synchronizedMap(new LinkedHashMap());
    private final Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig;

    protected ClassInstanceProvider(ClassInstanceProviderConfiguration<T> factoryConfig, Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig) {
        if (factoryConfig != null) {
            this.preconfiguredLoaders.putAll(factoryConfig.getDefaults());
        }
        this.cacheLevelConfig = cacheLevelConfig;
    }

    protected Class<? extends T> getPreconfigured(String alias, ConstructorArgument<?> ... ctorArgs) {
        return this.preconfiguredLoaders.get(alias);
    }

    protected T newInstance(String alias, CacheConfiguration<?, ?> cacheConfiguration) {
        Class<T> clazz = null;
        for (ServiceConfiguration serviceConfiguration : cacheConfiguration.getServiceConfigurations()) {
            if (!this.cacheLevelConfig.isAssignableFrom(serviceConfiguration.getClass())) continue;
            clazz = this.cacheLevelConfig.cast(serviceConfiguration).getClazz();
        }
        return this.newInstance(alias, clazz, new ConstructorArgument[0]);
    }

    protected T newInstance(String alias, ServiceConfiguration<?> serviceConfiguration, ConstructorArgument<?> ... ctorArgs) {
        Class<T> clazz = null;
        if (serviceConfiguration != null && this.cacheLevelConfig.isAssignableFrom(serviceConfiguration.getClass())) {
            clazz = this.cacheLevelConfig.cast(serviceConfiguration).getClazz();
        }
        return this.newInstance(alias, clazz, ctorArgs);
    }

    private T newInstance(String alias, Class<? extends T> clazz, ConstructorArgument<?> ... ctorArgs) {
        if (clazz == null && (clazz = this.getPreconfigured(alias, ctorArgs)) == null) {
            return null;
        }
        try {
            ArrayList<Class> ctorClasses = new ArrayList<Class>();
            ArrayList<Object> ctorVals = new ArrayList<Object>();
            for (ConstructorArgument<?> ctorArg : ctorArgs) {
                ctorClasses.add(((ConstructorArgument)ctorArg).clazz);
                ctorVals.add(((ConstructorArgument)ctorArg).val);
            }
            Constructor<Object> constructor = clazz.getConstructor(ctorClasses.toArray(new Class[ctorClasses.size()]));
            return (T)constructor.newInstance(ctorVals.toArray());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(ServiceProvider serviceProvider) {
    }

    public void stop() {
        this.preconfiguredLoaders.clear();
    }

    public static class ConstructorArgument<T> {
        private final Class<T> clazz;
        private final T val;

        public ConstructorArgument(Class<T> clazz, T val) {
            this.clazz = clazz;
            this.val = val;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public T getVal() {
            return this.val;
        }
    }
}

