/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.tiering;

import java.util.Map;
import java.util.Set;
import org.ehcache.Cache;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.internal.store.tiering.CacheStoreServiceConfig;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.service.ServiceConfiguration;

public class CacheStore<K, V>
implements Store<K, V> {
    private final CachingTier<K, V> cachingTier;
    private final AuthoritativeTier<K, V> authoritativeTier;

    public CacheStore(CachingTier<K, V> cachingTier, AuthoritativeTier<K, V> authoritativeTier) {
        this.cachingTier = cachingTier;
        this.authoritativeTier = authoritativeTier;
        this.cachingTier.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                CacheStore.this.authoritativeTier.flush(key, valueHolder, CacheStore.this.cachingTier);
            }
        });
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        try {
            return this.cachingTier.getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K key) {
                    try {
                        return CacheStore.this.authoritativeTier.getAndFault(key);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    public boolean containsKey(K key) throws CacheAccessException {
        return this.authoritativeTier.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) throws CacheAccessException {
        try {
            this.authoritativeTier.put(key, value);
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws CacheAccessException {
        Store.ValueHolder previous = null;
        try {
            previous = this.authoritativeTier.putIfAbsent(key, value);
        }
        finally {
            if (previous == null) {
                this.cachingTier.remove(key);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) throws CacheAccessException {
        try {
            this.authoritativeTier.remove(key);
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) throws CacheAccessException {
        boolean removed = true;
        try {
            boolean bl = removed = this.authoritativeTier.remove(key, value);
            return bl;
        }
        finally {
            if (removed) {
                this.cachingTier.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> replace(K key, V value) throws CacheAccessException {
        Store.ValueHolder previous = null;
        boolean exceptionThrown = true;
        try {
            previous = this.authoritativeTier.replace(key, value);
            exceptionThrown = false;
        }
        finally {
            if (exceptionThrown || previous != null) {
                this.cachingTier.remove(key);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) throws CacheAccessException {
        boolean replaced = true;
        try {
            replaced = this.authoritativeTier.replace(key, oldValue, newValue);
        }
        finally {
            if (replaced) {
                this.cachingTier.remove(key);
            }
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws CacheAccessException {
        try {
            this.authoritativeTier.clear();
        }
        finally {
            this.cachingTier.clear();
        }
    }

    public void destroy() throws CacheAccessException {
        this.authoritativeTier.destroy();
        this.cachingTier.destroy();
    }

    public void create() throws CacheAccessException {
        this.cachingTier.create();
        this.authoritativeTier.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.authoritativeTier.close();
        }
        finally {
            this.cachingTier.close();
        }
    }

    public void init() {
        this.cachingTier.init();
        this.authoritativeTier.init();
    }

    public void maintenance() {
        this.cachingTier.maintenance();
        this.authoritativeTier.maintenance();
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
        this.authoritativeTier.enableStoreEventNotifications(listener);
    }

    public void disableStoreEventNotifications() {
        this.authoritativeTier.disableStoreEventNotifications();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() throws CacheAccessException {
        return this.authoritativeTier.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction, replaceEqual);
            return valueHolder;
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        try {
            return this.cachingTier.getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K k) {
                    try {
                        return CacheStore.this.authoritativeTier.computeIfAbsentAndFault(k, mappingFunction);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.computeIfPresent(key, remappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.computeIfPresent(key, remappingFunction, replaceEqual);
            return valueHolder;
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction, replaceEqual);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        try {
            Map map = this.authoritativeTier.bulkComputeIfAbsent(keys, mappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier.remove(key);
            }
        }
    }

    public static class Provider
    implements Store.Provider {
        private ServiceProvider serviceProvider;

        public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            CacheStoreServiceConfig cacheStoreServiceConfig = (CacheStoreServiceConfig)ServiceLocator.findSingletonAmongst(CacheStoreServiceConfig.class, (Object[])serviceConfigs);
            if (cacheStoreServiceConfig == null) {
                throw new IllegalArgumentException("Cache store cannot be configured without explicit config");
            }
            Class<? extends CachingTier.Provider> cachingTierProviderClass = cacheStoreServiceConfig.cachingTierProvider();
            if (cachingTierProviderClass == null) {
                throw new IllegalArgumentException("Caching tier provider must be specified");
            }
            CachingTier.Provider cachingTierProvider = (CachingTier.Provider)this.serviceProvider.findService(cachingTierProviderClass);
            if (cachingTierProvider == null) {
                throw new IllegalArgumentException("No registered service for caching tier provider " + cachingTierProviderClass.getName());
            }
            Class<? extends AuthoritativeTier.Provider> authoritativeTierProviderClass = cacheStoreServiceConfig.authoritativeTierProvider();
            if (authoritativeTierProviderClass == null) {
                throw new IllegalArgumentException("Authoritative tier provider must be specified");
            }
            AuthoritativeTier.Provider authoritativeTierProvider = (AuthoritativeTier.Provider)this.serviceProvider.findService(authoritativeTierProviderClass);
            if (authoritativeTierProvider == null) {
                throw new IllegalArgumentException("No registered service for authoritative tier provider " + authoritativeTierProviderClass.getName());
            }
            CachingTier cachingTier = cachingTierProvider.createCachingTier(storeConfig, serviceConfigs);
            AuthoritativeTier authoritativeTier = authoritativeTierProvider.createAuthoritativeTier(storeConfig, serviceConfigs);
            return new CacheStore(cachingTier, authoritativeTier);
        }

        public void releaseStore(Store<?, ?> resource) {
            resource.close();
        }

        public void start(ServiceConfiguration<?> config, ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(CacheAccessException cause) {
            super(cause);
        }

        public CacheAccessException getCacheAccessException() {
            return (CacheAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

