/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap;

import java.util.concurrent.TimeUnit;
import org.ehcache.spi.cache.Store;
import org.terracotta.offheapstore.storage.portability.WriteContext;

public final class OffHeapValueHolder<V>
implements Store.ValueHolder<V> {
    public static final long NO_EXPIRE = -1L;
    private final V value;
    private final WriteContext writeContext;
    private final long creationTime;
    private long lastAccessTime;
    private long expireTime;

    public OffHeapValueHolder(V value, long creationTime, long expireTime) {
        this(value, creationTime, expireTime, 0L, null);
    }

    public OffHeapValueHolder(V value, long creationTime, long expireTime, long lastAccessTime, WriteContext writeContext) {
        this.value = value;
        this.creationTime = creationTime;
        this.expireTime = expireTime;
        this.lastAccessTime = lastAccessTime;
        this.writeContext = writeContext;
    }

    public V value() {
        return this.value;
    }

    public long creationTime(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.creationTime, unit);
    }

    public long expireTime(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.expireTime, unit);
    }

    void setExpireTimeMillis(long expireTime) {
        this.expireTime = expireTime;
    }

    public long lastAccessTime(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.lastAccessTime, unit);
    }

    void setLastAccessTimeMillis(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    public float hitRate(TimeUnit unit) {
        throw new UnsupportedOperationException("TODO Implement me!");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OffHeapValueHolder that = (OffHeapValueHolder)other;
        if (this.creationTime != that.creationTime) {
            return false;
        }
        if (this.expireTime != that.expireTime) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        result = 31 * result + (int)(this.expireTime ^ this.expireTime >>> 32);
        return result;
    }

    public boolean isExpired(long now) {
        long expire = this.expireTime;
        if (expire == -1L) {
            return false;
        }
        return expire <= now;
    }

    void writeBack() {
        this.writeContext.setLong(8, this.lastAccessTime);
        this.writeContext.setLong(16, this.expireTime);
    }
}

