/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.internal.store.heap.BaseOnHeapValueHolder;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.serialization.Serializer;

class ByValueOnHeapValueHolder<V>
extends BaseOnHeapValueHolder<V> {
    private final ByteBuffer buffer;
    private final int hash;
    private final Serializer<V> serializer;

    protected ByValueOnHeapValueHolder(V value, long createTime, Serializer<V> serializer) {
        super(createTime);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (serializer == null) {
            throw new NullPointerException("null serializer");
        }
        this.serializer = serializer;
        this.hash = value.hashCode();
        try {
            this.buffer = serializer.serialize(value);
        }
        catch (IOException ioe) {
            throw new SerializerException((Throwable)ioe);
        }
    }

    public final V value() {
        try {
            return (V)this.serializer.read(this.buffer);
        }
        catch (IOException ioe) {
            throw new SerializerException((Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Store.ValueHolder)) {
            return false;
        }
        try {
            return this.serializerEquals(o, this.buffer);
        }
        catch (IOException ioe) {
            throw new SerializerException((Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
    }

    boolean serializerEquals(Object o, ByteBuffer buffer2) throws ClassNotFoundException, IOException {
        return this.serializer.equals(((Store.ValueHolder)o).value(), this.buffer);
    }

    public int hashCode() {
        return this.hash;
    }
}

