/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.ehcache.CacheManager;
import org.ehcache.EhcacheManager;
import org.ehcache.config.Configuration;
import org.ehcache.config.xml.XmlConfiguration;
import org.ehcache.jsr107.DefaultJsr107Service;
import org.ehcache.jsr107.Eh107CacheLoaderFactory;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.Eh107CacheWriterFactory;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.service.Service;
import org.ehcache.util.ClassLoading;

public class EhcacheCachingProvider
implements CachingProvider {
    private static final URI URI_DEFAULT;
    private final Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.cache.CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        Eh107CacheManager cacheManager;
        uri = uri == null ? this.getDefaultURI() : uri;
        classLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        properties = properties == null ? new Properties() : new Properties(properties);
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, Eh107CacheManager> byURI = this.cacheManagers.get(classLoader);
            if (byURI == null) {
                byURI = new ConcurrentHashMap<URI, Eh107CacheManager>();
                this.cacheManagers.put(classLoader, byURI);
            }
            if ((cacheManager = (Eh107CacheManager)byURI.get(uri)) == null) {
                XmlConfiguration config;
                try {
                    config = new XmlConfiguration(uri.toURL(), classLoader);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
                Eh107CacheLoaderFactory cacheLoaderFactory = new Eh107CacheLoaderFactory();
                Eh107CacheWriterFactory cacheWriterFactory = new Eh107CacheWriterFactory();
                DefaultJsr107Service jsr107Service = new DefaultJsr107Service();
                ServiceLocator serviceLocator = new ServiceLocator(new Service[0]);
                serviceLocator.addService((Service)cacheLoaderFactory);
                serviceLocator.addService((Service)cacheWriterFactory);
                serviceLocator.addService((Service)jsr107Service);
                EhcacheManager ehcacheManager = new EhcacheManager((Configuration)config, serviceLocator);
                ehcacheManager.init();
                cacheManager = new Eh107CacheManager(this, (CacheManager)ehcacheManager, properties, classLoader, uri, cacheLoaderFactory, cacheWriterFactory, config, jsr107Service);
                byURI.put(uri, cacheManager);
            }
        }
        return cacheManager;
    }

    public ClassLoader getDefaultClassLoader() {
        return ClassLoading.getDefaultClassLoader();
    }

    public URI getDefaultURI() {
        return URI_DEFAULT;
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public javax.cache.CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    public javax.cache.CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> entry : this.cacheManagers.entrySet()) {
                for (Eh107CacheManager cacheManager : entry.getValue().values()) {
                    cacheManager.close();
                }
            }
            this.cacheManagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        MultiCacheException closeException = new MultiCacheException();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.remove(classLoader);
            if (map2 != null) {
                for (Eh107CacheManager cacheManager : map2.values()) {
                    cacheManager.closeInternal(closeException);
                }
            }
        }
        closeException.throwIfNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        if (uri == null || classLoader == null) {
            throw new NullPointerException();
        }
        MultiCacheException closeException = new MultiCacheException();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Eh107CacheManager cacheManager;
            ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 != null && (cacheManager = (Eh107CacheManager)map2.remove(uri)) != null) {
                cacheManager.closeInternal(closeException);
            }
        }
        closeException.throwIfNotEmpty();
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        if (optionalFeature == null) {
            throw new NullPointerException();
        }
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown OptionalFeature: " + optionalFeature.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Eh107CacheManager cacheManager, MultiCacheException closeException) {
        try {
            Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.get(cacheManager.getClassLoader());
                if (map2 != null && map2.remove(cacheManager.getURI()) != null) {
                    cacheManager.closeInternal(closeException);
                }
            }
        }
        catch (Throwable t) {
            closeException.addThrowable(t);
        }
    }

    static {
        URI uri;
        try {
            URL resource = EhcacheCachingProvider.class.getResource("/ehcache.xml");
            if (resource == null) {
                resource = EhcacheCachingProvider.class.getResource("/ehcache-failsafe.xml");
            }
            if (resource == null) {
                throw new CacheException("No default URI could be found for ehcache");
            }
            uri = new URI(resource.toString());
        }
        catch (URISyntaxException e) {
            throw new CacheException((Throwable)e);
        }
        URI_DEFAULT = uri;
    }
}

