/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.Ehcache;
import org.ehcache.EhcacheHackAccessor;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheConfigurationBuilder;
import org.ehcache.config.xml.XmlConfiguration;
import org.ehcache.internal.store.service.OnHeapStoreServiceConfig;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.Eh107Cache;
import org.ehcache.jsr107.Eh107CacheLoaderFactory;
import org.ehcache.jsr107.Eh107CacheWriterFactory;
import org.ehcache.jsr107.Eh107CompleteConfiguration;
import org.ehcache.jsr107.Eh107Expiry;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.jsr107.Eh107ReverseConfiguration;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.ehcache.jsr107.EhcacheExpiryWrapper;
import org.ehcache.jsr107.Jsr107Service;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.Unwrap;
import org.ehcache.spi.loader.CacheLoader;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.writer.CacheWriter;

class Eh107CacheManager
implements javax.cache.CacheManager {
    private static MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final Object cachesLock = new Object();
    private final ConcurrentMap<String, Eh107Cache<?, ?>> caches = new ConcurrentHashMap();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CacheManager ehCacheManager;
    private final EhcacheCachingProvider cachingProvider;
    private final ClassLoader classLoader;
    private final URI uri;
    private final Properties props;
    private final Eh107CacheLoaderFactory cacheLoaderFactory;
    private final Eh107CacheWriterFactory cacheWriterFactory;
    private final XmlConfiguration ehXmlConfig;
    private final Jsr107Service jsr107Service;

    Eh107CacheManager(EhcacheCachingProvider cachingProvider, CacheManager ehCacheManager, Properties props, ClassLoader classLoader, URI uri, Eh107CacheLoaderFactory cacheLoaderFactory, Eh107CacheWriterFactory cacheWriterFactory, XmlConfiguration ehXmlConfig, Jsr107Service jsr107Service) {
        this.cachingProvider = cachingProvider;
        this.ehCacheManager = ehCacheManager;
        this.props = props;
        this.classLoader = classLoader;
        this.uri = uri;
        this.cacheLoaderFactory = cacheLoaderFactory;
        this.cacheWriterFactory = cacheWriterFactory;
        this.ehXmlConfig = ehXmlConfig;
        this.jsr107Service = jsr107Service;
        this.loadExistingEhcaches();
    }

    private void loadExistingEhcaches() {
        for (Map.Entry entry : this.ehXmlConfig.getCacheConfigurations().entrySet()) {
            String name = (String)entry.getKey();
            CacheConfiguration config = (CacheConfiguration)entry.getValue();
            this.caches.put(name, this.wrapEhcacheCache(name, config));
        }
    }

    private <K, V> Eh107Cache<K, V> wrapEhcacheCache(String alias, CacheConfiguration<K, V> ehConfig) {
        Cache cache = this.ehCacheManager.getCache(alias, ehConfig.getKeyType(), ehConfig.getValueType());
        CacheLoader cacheLoader = EhcacheHackAccessor.getCacheLoader((Ehcache)cache);
        CacheWriter cacheWriter = EhcacheHackAccessor.getCacheWriter((Ehcache)cache);
        boolean storeByValueOnHeap = false;
        for (ServiceConfiguration serviceConfiguration : ehConfig.getServiceConfigurations()) {
            if (!(serviceConfiguration instanceof OnHeapStoreServiceConfig)) continue;
            OnHeapStoreServiceConfig onHeapStoreServiceConfig = (OnHeapStoreServiceConfig)serviceConfiguration;
            storeByValueOnHeap = onHeapStoreServiceConfig.storeByValue();
        }
        Eh107ReverseConfiguration config = new Eh107ReverseConfiguration(cache, cacheLoader != null, cacheWriter != null, storeByValueOnHeap);
        EhcacheExpiryWrapper expiry = new EhcacheExpiryWrapper(cache.getRuntimeConfiguration().getExpiry());
        CacheResources resources = new CacheResources(alias, cacheLoader, cacheWriter, expiry);
        return new Eh107Cache(alias, config, resources, cache, this, expiry);
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return new Properties(this.props);
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C config) throws IllegalArgumentException {
        Object object = this.cachesLock;
        synchronized (object) {
            Cache ehCache;
            this.checkClosed();
            if (cacheName == null || config == null) {
                throw new NullPointerException();
            }
            Eh107CompleteConfiguration completeConfig = new Eh107CompleteConfiguration(config);
            if (this.caches.containsKey(cacheName)) {
                throw new CacheException("A Cache named [" + cacheName + "] already exists");
            }
            CacheResources cacheResources = new CacheResources(cacheName, completeConfig);
            Eh107Expiry expiry = cacheResources.getExpiryPolicy();
            try {
                ehCache = this.ehCacheManager.createCache(cacheName, this.toEhcacheConfig(cacheName, completeConfig, cacheResources, expiry));
            }
            catch (Throwable t) {
                MultiCacheException mce = new MultiCacheException(t);
                cacheResources.closeResources(mce);
                throw mce;
            }
            Eh107Cache cache = null;
            try {
                cache = new Eh107Cache(cacheName, completeConfig, cacheResources, ehCache, this, expiry);
                this.caches.put(cacheName, cache);
                if (completeConfig.isManagementEnabled()) {
                    this.enableManagement(cacheName, true);
                }
                if (completeConfig.isStatisticsEnabled()) {
                    this.enableStatistics(cacheName, true);
                }
                return cache;
            }
            catch (Throwable t) {
                MultiCacheException mce = new MultiCacheException(t);
                if (cache != null) {
                    cache.closeInternal(mce);
                }
                throw mce;
            }
        }
    }

    private <K, V> CacheConfiguration<K, V> toEhcacheConfig(String cacheName, CompleteConfiguration<K, V> jsr107Config, CacheResources<K, V> cacheResources, Eh107Expiry<K, V> expiry) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        CacheWriter<K, V> cacheWriter;
        OnHeapStoreServiceConfig onHeapStoreServiceConfig;
        CacheConfigurationBuilder builder = null;
        String cacheTemplate = this.getCacheTemplateName(cacheName);
        if (cacheTemplate != null) {
            builder = this.ehXmlConfig.newCacheConfigurationBuilderFromTemplate(cacheTemplate, jsr107Config.getKeyType(), jsr107Config.getValueType());
        }
        if (builder == null) {
            builder = CacheConfigurationBuilder.newCacheConfigurationBuilder();
        }
        if ((onHeapStoreServiceConfig = (OnHeapStoreServiceConfig)(builder = builder.withExpiry(expiry)).getExistingServiceConfiguration(OnHeapStoreServiceConfig.class)) == null) {
            builder.addServiceConfig((ServiceConfiguration)new OnHeapStoreServiceConfig().storeByValue(jsr107Config.isStoreByValue()));
        } else {
            onHeapStoreServiceConfig.storeByValue(jsr107Config.isStoreByValue());
        }
        CacheLoader<K, V> cacheLoader = cacheResources.getCacheLoader();
        if (cacheLoader != null && jsr107Config.isReadThrough()) {
            this.cacheLoaderFactory.registerJsr107Loader(cacheName, cacheLoader);
        }
        if ((cacheWriter = cacheResources.getCacheWriter()) != null && jsr107Config.isWriteThrough()) {
            this.cacheWriterFactory.registerJsr107Loader(cacheName, cacheWriter);
        }
        return builder.buildConfig(jsr107Config.getKeyType(), jsr107Config.getValueType());
    }

    private String getCacheTemplateName(String cacheName) {
        String template = this.jsr107Service.getTemplateNameForCache(cacheName);
        if (template != null) {
            return template;
        }
        return this.jsr107Service.getDefaultTemplate();
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(this.toString() + " is closed");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uri + "]";
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkClosed();
        if (cacheName == null || keyType == null || valueType == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        Class actualKeyType = cache.getConfiguration(Configuration.class).getKeyType();
        Class actualValueType = cache.getConfiguration(Configuration.class).getValueType();
        if (keyType != actualKeyType) {
            throw new ClassCastException("Cache has key type " + actualKeyType.getName() + ", but getCache() called with key type " + keyType.getName());
        }
        if (valueType != actualValueType) {
            throw new ClassCastException("Cache has value type " + actualValueType.getName() + ", but getCache() called with value type " + valueType.getName());
        }
        return cache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        if (cache.getConfiguration(Configuration.class).getKeyType() != Object.class || cache.getConfiguration(Configuration.class).getValueType() != Object.class) {
            throw new IllegalArgumentException("Cache [" + cacheName + "] specifies key/value types. Use getCache(String, Class, Class)");
        }
        return cache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableList(new ArrayList(this.caches.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        MultiCacheException destroyException = new MultiCacheException();
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            Eh107Cache cache = (Eh107Cache)this.caches.remove(cacheName);
            if (cache == null) {
                return;
            }
            try {
                this.enableManagement(cache, false);
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
            try {
                this.enableStatistics(cache, false);
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
            cache.destroy(destroyException);
            try {
                this.ehCacheManager.removeCache(cache.getName());
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
        }
        destroyException.throwIfNotEmpty();
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableManagement(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableManagement(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getManagementMBean());
            } else {
                this.unregisterObject(cache.getManagementMBean());
            }
            cache.setManagementEnabled(enabled);
        }
    }

    private void unregisterObject(Eh107MXBean bean) {
        try {
            MBEAN_SERVER.unregisterMBean(bean.getObjectName());
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void registerObject(Eh107MXBean bean) {
        try {
            MBEAN_SERVER.registerMBean(bean, bean.getObjectName());
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = (Eh107Cache)this.caches.get(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableStatistics(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableStatistics(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getStatisticsMBean());
            } else {
                this.unregisterObject(cache.getStatisticsMBean());
            }
            cache.setStatisticsEnaled(enabled);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public <T> T unwrap(Class<T> clazz) {
        return Unwrap.unwrap(clazz, this.ehCacheManager);
    }

    public void close() {
        MultiCacheException closeException = new MultiCacheException();
        this.cachingProvider.close(this, closeException);
        closeException.throwIfNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal(MultiCacheException closeException) {
        try {
            Object object = this.cachesLock;
            synchronized (object) {
                if (this.closed.compareAndSet(false, true)) {
                    for (Eh107Cache cache : this.caches.values()) {
                        try {
                            this.close(cache, closeException);
                        }
                        catch (Throwable t) {
                            closeException.addThrowable(t);
                        }
                    }
                    try {
                        this.caches.clear();
                    }
                    catch (Throwable t) {
                        closeException.addThrowable(t);
                    }
                    try {
                        this.ehCacheManager.close();
                    }
                    catch (Throwable t) {
                        closeException.addThrowable(t);
                    }
                }
            }
        }
        catch (Throwable t) {
            closeException.addThrowable(t);
        }
    }

    void close(Eh107Cache<?, ?> cache, MultiCacheException closeException) {
        block10: {
            try {
                if (!this.caches.remove(cache.getName(), cache)) break block10;
                try {
                    this.unregisterObject(cache.getManagementMBean());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.unregisterObject(cache.getStatisticsMBean());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    cache.closeInternal(closeException);
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.ehCacheManager.removeCache(cache.getName());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
            }
            catch (Throwable t) {
                closeException.addThrowable(t);
            }
        }
    }
}

