/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.ServerStore;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerStoreEventListener;
import org.ehcache.clustered.server.offheap.LongPortability;
import org.ehcache.clustered.server.offheap.OffHeapChainMap;
import org.ehcache.clustered.server.offheap.PinningOffHeapChainMap;
import org.ehcache.clustered.server.state.ResourcePageSource;
import org.terracotta.offheapstore.MapInternals;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.util.MemoryUnit;

public class OffHeapServerStore
implements ServerStore,
MapInternals {
    private static final long MAX_PAGE_SIZE_IN_KB = MemoryUnit.KILOBYTES.convert(8L, MemoryUnit.MEGABYTES);
    private final List<OffHeapChainMap<Long>> segments;
    private final KeySegmentMapper mapper;
    private volatile ServerStoreEventListener listener;
    private volatile boolean fireEvents;

    public OffHeapServerStore(List<OffHeapChainMap<Long>> segments, KeySegmentMapper mapper) {
        this.mapper = mapper;
        this.segments = segments;
    }

    OffHeapServerStore(PageSource source, KeySegmentMapper mapper, boolean writeBehindConfigured) {
        this.mapper = mapper;
        this.segments = new ArrayList<OffHeapChainMap<Long>>(mapper.getSegments());
        for (int i = 0; i < mapper.getSegments(); ++i) {
            if (writeBehindConfigured) {
                this.segments.add(new PinningOffHeapChainMap<Long>(source, LongPortability.INSTANCE, MemoryUnit.KILOBYTES.toBytes(4), MemoryUnit.MEGABYTES.toBytes(8), false));
                continue;
            }
            this.segments.add(new OffHeapChainMap<Long>(source, LongPortability.INSTANCE, MemoryUnit.KILOBYTES.toBytes(4), MemoryUnit.MEGABYTES.toBytes(8), false));
        }
    }

    public OffHeapServerStore(ResourcePageSource source, KeySegmentMapper mapper, boolean writeBehindConfigured) {
        this.mapper = mapper;
        this.segments = new ArrayList<OffHeapChainMap<Long>>(mapper.getSegments());
        long maxSize = OffHeapServerStore.getMaxSize(source.getPool().getSize());
        for (int i = 0; i < mapper.getSegments(); ++i) {
            if (writeBehindConfigured) {
                this.segments.add(new PinningOffHeapChainMap<Long>(source, LongPortability.INSTANCE, MemoryUnit.KILOBYTES.toBytes(4), (int)MemoryUnit.KILOBYTES.toBytes(maxSize), false));
                continue;
            }
            this.segments.add(new OffHeapChainMap<Long>(source, LongPortability.INSTANCE, MemoryUnit.KILOBYTES.toBytes(4), (int)MemoryUnit.KILOBYTES.toBytes(maxSize), false));
        }
    }

    public List<OffHeapChainMap<Long>> getSegments() {
        return this.segments;
    }

    static long getMaxSize(long poolSize) {
        long l = Long.highestOneBit(poolSize);
        long sizeInKb = MemoryUnit.KILOBYTES.convert(l, MemoryUnit.BYTES);
        long maxSize = sizeInKb >> 5;
        if (maxSize >= MAX_PAGE_SIZE_IN_KB) {
            maxSize = MAX_PAGE_SIZE_IN_KB;
        }
        return maxSize;
    }

    public void setEventListener(ServerStoreEventListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("ServerStoreEventListener instance already set");
        }
        this.listener = listener;
        OffHeapChainMap.ChainMapEvictionListener<Long> chainMapEvictionListener = (arg_0, arg_1) -> ((ServerStoreEventListener)listener).onEviction(arg_0, arg_1);
        for (OffHeapChainMap<Long> segment : this.segments) {
            segment.setEvictionListener(chainMapEvictionListener);
        }
    }

    public Chain get(long key) {
        return this.segmentFor(key).get(key);
    }

    public void append(long key, ByteBuffer payLoad) {
        LongConsumer lambda = this.listener != null && this.fireEvents ? k -> {
            Chain beforeAppend = this.segmentFor(k).getAndAppend(k, payLoad);
            this.listener.onAppend(beforeAppend, payLoad.duplicate());
        } : k -> this.segmentFor(k).append(k, payLoad);
        try {
            lambda.accept(key);
        }
        catch (OversizeMappingException e) {
            this.consumeOversizeMappingException(key, lambda);
        }
    }

    public Chain getAndAppend(long key, ByteBuffer payLoad) {
        LongFunction<Chain> lambda = this.listener != null && this.fireEvents ? k -> {
            Chain beforeAppend = this.segmentFor(k).getAndAppend(k, payLoad);
            this.listener.onAppend(beforeAppend, payLoad.duplicate());
            return beforeAppend;
        } : k -> this.segmentFor(k).getAndAppend(k, payLoad);
        try {
            return lambda.apply(key);
        }
        catch (OversizeMappingException e) {
            return this.handleOversizeMappingException(key, lambda);
        }
    }

    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.segmentFor(key).replaceAtHead(key, expect, update);
        }
        catch (OversizeMappingException e) {
            this.consumeOversizeMappingException(key, k -> this.segmentFor(k).replaceAtHead(k, expect, update));
        }
    }

    public void put(long key, Chain chain) {
        try {
            try {
                this.segmentFor(key).put(key, chain);
            }
            catch (OversizeMappingException e) {
                this.consumeOversizeMappingException(key, k -> this.segmentFor(k).put(k, chain));
            }
        }
        catch (Throwable t) {
            this.segmentFor(key).remove(key);
            throw t;
        }
    }

    public void remove(long key) {
        this.segmentFor(key).remove(key);
    }

    public void clear() {
        for (OffHeapChainMap<Long> segment : this.segments) {
            segment.clear();
        }
    }

    OffHeapChainMap<Long> segmentFor(long key) {
        return this.segments.get(this.mapper.getSegmentForKey(key));
    }

    private void writeLockAll() {
        for (OffHeapChainMap<Long> s : this.segments) {
            s.writeLock().lock();
        }
    }

    private void writeUnlockAll() {
        for (OffHeapChainMap<Long> s : this.segments) {
            s.writeLock().unlock();
        }
    }

    private void consumeOversizeMappingException(long key, LongConsumer operation) {
        this.handleOversizeMappingException(key, k -> {
            operation.accept(k);
            return null;
        });
    }

    private <R> R handleOversizeMappingException(long key, LongFunction<R> operation) throws OversizeMappingException {
        if (this.tryShrinkOthers(key)) {
            try {
                return operation.apply(key);
            }
            catch (OversizeMappingException oversizeMappingException) {
                // empty catch block
            }
        }
        this.writeLockAll();
        while (true) {
            try {
                R r = operation.apply(key);
                return r;
            }
            catch (OversizeMappingException ex) {
                OversizeMappingException e = ex;
                if (this.tryShrinkOthers(key)) continue;
                throw e;
            }
            break;
        }
        finally {
            this.writeUnlockAll();
        }
    }

    boolean tryShrinkOthers(long key) {
        boolean evicted = false;
        OffHeapChainMap<Long> target = this.segmentFor(key);
        for (OffHeapChainMap<Long> s : this.segments) {
            if (s == target) continue;
            evicted |= s.shrink();
        }
        return evicted;
    }

    public void close() {
        this.writeLockAll();
        try {
            this.clear();
        }
        finally {
            this.writeUnlockAll();
        }
        this.segments.clear();
    }

    public long getAllocatedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getAllocatedMemory();
        }
        return total;
    }

    public long getOccupiedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getOccupiedMemory();
        }
        return total;
    }

    public long getDataAllocatedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataAllocatedMemory();
        }
        return total;
    }

    public long getDataOccupiedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataOccupiedMemory();
        }
        return total;
    }

    public long getDataSize() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataSize();
        }
        return total;
    }

    public long getSize() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getSize();
        }
        return total;
    }

    public long getTableCapacity() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getTableCapacity();
        }
        return total;
    }

    public long getUsedSlotCount() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getUsedSlotCount();
        }
        return total;
    }

    public long getRemovedSlotCount() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getRemovedSlotCount();
        }
        return total;
    }

    public int getReprobeLength() {
        int total = 0;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getReprobeLength();
        }
        return total;
    }

    public long getVitalMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getVitalMemory();
        }
        return total;
    }

    public long getDataVitalMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataVitalMemory();
        }
        return total;
    }

    public Iterator<Map.Entry<Long, Chain>> iterator() {
        return new AggregateIterator<Map.Entry<Long, Chain>>(){

            @Override
            protected Iterator<Map.Entry<Long, Chain>> getNextIterator() {
                return ((OffHeapChainMap)this.listIterator.next()).iterator();
            }
        };
    }

    public void enableEvents(boolean enable) {
        this.fireEvents = enable;
    }

    protected abstract class AggregateIterator<T>
    implements Iterator<T> {
        protected final Iterator<OffHeapChainMap<Long>> listIterator;
        protected Iterator<T> currentIterator;

        protected abstract Iterator<T> getNextIterator();

        public AggregateIterator() {
            this.listIterator = OffHeapServerStore.this.segments.iterator();
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.currentIterator == null) {
                throw new NoSuchElementException();
            }
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.currentIterator.remove();
        }
    }
}

