/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.state;

import com.tc.classloader.BuiltinService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.clustered.server.EhcacheStateServiceImpl;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.ehcache.clustered.server.state.EhcacheStateServiceDump;
import org.ehcache.clustered.server.state.config.EhcacheStateServiceConfig;
import org.ehcache.clustered.server.state.config.EhcacheStoreStateServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.offheapresource.OffHeapResources;

@BuiltinService
public class EhcacheStateServiceProvider
implements ServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheStateServiceProvider.class);
    private final ConcurrentMap<String, EhcacheStateService> serviceMap = new ConcurrentHashMap<String, EhcacheStateService>();
    private OffHeapResources offHeapResourcesProvider;

    public void addStateTo(StateDumpCollector dump) {
        for (Map.Entry<String, EhcacheStateService> entry : new HashMap<String, EhcacheStateService>(this.serviceMap).entrySet()) {
            StateDumpCollector clusterTierManagerStateDump = dump.subStateDumpCollector(entry.getKey());
            EhcacheStateService clusterTierManagerState = entry.getValue();
            EhcacheStateServiceDump.dump(clusterTierManagerState, clusterTierManagerStateDump);
        }
    }

    public boolean initialize(ServiceProviderConfiguration configuration, PlatformConfiguration platformConfiguration) {
        Collection extendedConfiguration = platformConfiguration.getExtendedConfiguration(OffHeapResources.class);
        if (extendedConfiguration.size() > 1) {
            throw new UnsupportedOperationException("There are " + extendedConfiguration.size() + " OffHeapResourcesProvider, this is not supported. There must be only one!");
        }
        Iterator iterator = extendedConfiguration.iterator();
        if (iterator.hasNext()) {
            this.offHeapResourcesProvider = (OffHeapResources)iterator.next();
            if (this.offHeapResourcesProvider.getAllIdentifiers().isEmpty()) {
                LOGGER.warn("No offheap-resource defined - this will prevent provider from offering any EhcacheStateService.");
            }
        } else {
            throw new UnsupportedOperationException("There are no offheap-resource defined, this is not supported");
        }
        return true;
    }

    public <T> T getService(long consumerID, ServiceConfiguration<T> configuration) {
        if (configuration != null && configuration.getServiceType().equals(EhcacheStateService.class)) {
            EhcacheStateService result;
            if (configuration instanceof EhcacheStateServiceConfig) {
                EhcacheStateServiceConfig stateServiceConfig = (EhcacheStateServiceConfig)configuration;
                EhcacheStateServiceImpl storeManagerService = new EhcacheStateServiceImpl(this.offHeapResourcesProvider, stateServiceConfig.getConfig().getConfiguration(), stateServiceConfig.getMapper(), service -> this.serviceMap.remove(stateServiceConfig.getConfig().getIdentifier(), service));
                result = this.serviceMap.putIfAbsent(stateServiceConfig.getConfig().getIdentifier(), storeManagerService);
                if (result == null) {
                    result = storeManagerService;
                }
            } else if (configuration instanceof EhcacheStoreStateServiceConfig) {
                EhcacheStoreStateServiceConfig storeStateServiceConfig = (EhcacheStoreStateServiceConfig)configuration;
                result = (EhcacheStateService)this.serviceMap.get(storeStateServiceConfig.getManagerIdentifier());
            } else {
                throw new IllegalArgumentException("Unexpected configuration type: " + configuration);
            }
            return configuration.getServiceType().cast(result);
        }
        throw new IllegalArgumentException("Unexpected configuration type.");
    }

    public Collection<Class<?>> getProvidedServiceTypes() {
        ArrayList classes = new ArrayList();
        classes.add(EhcacheStateService.class);
        return classes;
    }

    public void prepareForSynchronization() {
        this.serviceMap.clear();
    }

    public static interface DestroyCallback {
        public void destroy(EhcacheStateService var1);
    }
}

