/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.management.Notification;
import org.ehcache.clustered.server.management.PoolBinding;
import org.ehcache.clustered.server.management.PoolSettingsManagementProvider;
import org.ehcache.clustered.server.management.PoolStatisticsManagementProvider;
import org.ehcache.clustered.server.management.ServerStoreBinding;
import org.ehcache.clustered.server.management.ServerStoreSettingsManagementProvider;
import org.ehcache.clustered.server.management.ServerStoreStatisticsManagementProvider;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.service.monitoring.EntityManagementRegistry;
import org.terracotta.management.service.monitoring.EntityManagementRegistryConfiguration;

public class ClusterTierManagement
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagement.class);
    private final EntityManagementRegistry managementRegistry;
    private final EhcacheStateService ehcacheStateService;
    private final String storeIdentifier;

    public ClusterTierManagement(ServiceRegistry services, EhcacheStateService ehcacheStateService, boolean active, String storeIdentifier, String clusterTierManagerIdentifier) throws ConfigurationException {
        this.ehcacheStateService = ehcacheStateService;
        this.storeIdentifier = storeIdentifier;
        try {
            this.managementRegistry = (EntityManagementRegistry)services.getService((ServiceConfiguration)new EntityManagementRegistryConfiguration(services, active));
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to retrieve service: " + e.getMessage());
        }
        if (this.managementRegistry != null) {
            this.managementRegistry.addManagementProvider((ManagementProvider)new ServerStoreSettingsManagementProvider(clusterTierManagerIdentifier));
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolSettingsManagementProvider());
            this.managementRegistry.addManagementProvider((ManagementProvider)new ServerStoreStatisticsManagementProvider());
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolStatisticsManagementProvider(ehcacheStateService));
        }
    }

    @Override
    public void close() {
        if (this.managementRegistry != null) {
            this.managementRegistry.close();
        }
    }

    public void entityCreated() {
        if (this.managementRegistry != null) {
            LOGGER.trace("entityCreated({})", (Object)this.storeIdentifier);
            this.managementRegistry.entityCreated();
            this.init();
        }
    }

    public void entityPromotionCompleted() {
        if (this.managementRegistry != null) {
            LOGGER.trace("entityPromotionCompleted({})", (Object)this.storeIdentifier);
            this.managementRegistry.entityPromotionCompleted();
            this.init();
        }
    }

    private void init() {
        ServerSideServerStore serverStore = this.ehcacheStateService.getStore(this.storeIdentifier);
        ServerStoreBinding serverStoreBinding = new ServerStoreBinding(this.storeIdentifier, serverStore);
        CompletableFuture<Void> r1 = this.managementRegistry.register((Object)serverStoreBinding);
        ServerSideConfiguration.Pool pool = this.ehcacheStateService.getDedicatedResourcePool(this.storeIdentifier);
        CompletableFuture<Void> allOf = pool != null ? CompletableFuture.allOf(r1, this.managementRegistry.register((Object)new PoolBinding(this.storeIdentifier, pool, PoolBinding.AllocationType.DEDICATED))) : r1;
        allOf.thenRun(() -> {
            this.managementRegistry.refresh();
            this.managementRegistry.pushServerEntityNotification((Object)serverStoreBinding, Notification.EHCACHE_SERVER_STORE_CREATED.name());
        });
    }
}

