/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.ehcache.clustered.common.internal.messages.BaseCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.server.internal.messages.EhcacheMessageTrackerCatchup;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.client.message.tracker.RecordedMessage;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.entity.MessageCodec;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;

public class EhcacheServerCodec
implements MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheServerCodec.class);
    private final EhcacheCodec clientCodec;
    private final PassiveReplicationMessageCodec replicationCodec;
    private static final String CLIENT_ID = "client";
    private static final String TRANSACTION_ID = "transaction";
    private static final String MESSAGE = "message";
    private static final String MESSAGE_SEQUENCE = "sequence";
    private static final Struct RECORDED_MESSAGE = StructBuilder.newStructBuilder().int64("client", 10).int64("transaction", 20).byteBuffer("message", 30).build();
    private static final Struct MESSAGE_HISTORY = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).structs("sequence", 20, RECORDED_MESSAGE).build();

    public EhcacheServerCodec(EhcacheCodec clientCodec, PassiveReplicationMessageCodec replicationCodec) {
        this.clientCodec = clientCodec;
        this.replicationCodec = replicationCodec;
    }

    public byte[] encodeMessage(EhcacheEntityMessage message) {
        if (message instanceof PassiveReplicationMessage) {
            return this.replicationCodec.encode((PassiveReplicationMessage)message);
        }
        if (message instanceof EhcacheMessageTrackerCatchup) {
            return this.encodeCatchup((EhcacheMessageTrackerCatchup)message);
        }
        return this.clientCodec.encodeMessage(message);
    }

    private byte[] encodeCatchup(EhcacheMessageTrackerCatchup catchup) {
        return MESSAGE_HISTORY.encoder().enm("opCode", (Object)EhcacheMessageType.MESSAGE_CATCHUP).structs(MESSAGE_SEQUENCE, catchup.getTrackedMessages(), (encoder, value) -> {
            encoder.int64(CLIENT_ID, value.getClientSourceId().toLong());
            encoder.int64(TRANSACTION_ID, value.getTransactionId());
            encoder.byteBuffer(MESSAGE, ByteBuffer.wrap(this.encodeMessage((EhcacheEntityMessage)value.getRequest())));
        }).encode().array();
    }

    public EhcacheEntityMessage decodeMessage(byte[] payload) {
        return this.decodeMessage(ByteBuffer.wrap(payload));
    }

    private EhcacheEntityMessage decodeMessage(ByteBuffer byteBuffer) {
        Enm opCodeEnm = EhcacheCodec.OP_CODE_DECODER.decoder(byteBuffer).enm("opCode");
        if (!opCodeEnm.isFound()) {
            throw new AssertionError((Object)"Got a message without an opCode");
        }
        if (!opCodeEnm.isValid()) {
            LOGGER.warn("Received message with unknown operation code - more recent version at the other end?");
            return null;
        }
        byteBuffer.rewind();
        EhcacheMessageType messageType = (EhcacheMessageType)opCodeEnm.get();
        if (messageType == EhcacheMessageType.MESSAGE_CATCHUP) {
            return this.decodeCatchup(byteBuffer);
        }
        if (EhcacheMessageType.isPassiveReplicationMessage((EhcacheMessageType)messageType)) {
            return this.replicationCodec.decode(messageType, byteBuffer);
        }
        return this.clientCodec.decodeMessage(byteBuffer, messageType);
    }

    public byte[] encodeResponse(EhcacheEntityResponse response) {
        return this.clientCodec.encodeResponse(response);
    }

    public EhcacheEntityResponse decodeResponse(byte[] payload) {
        return this.clientCodec.decodeResponse(payload);
    }

    private EhcacheMessageTrackerCatchup decodeCatchup(ByteBuffer payload) {
        StructArrayDecoder array = MESSAGE_HISTORY.decoder(payload).structs(MESSAGE_SEQUENCE);
        if (array == null) {
            return new EhcacheMessageTrackerCatchup(Collections.emptyList());
        }
        ArrayList<RecordedMessage<EhcacheEntityMessage, EhcacheEntityResponse>> list = new ArrayList<RecordedMessage<EhcacheEntityMessage, EhcacheEntityResponse>>(array.length());
        while (array.hasNext()) {
            StructDecoder decoder = array.next();
            final long cid = decoder.int64(CLIENT_ID);
            final long transaction = decoder.int64(TRANSACTION_ID);
            ByteBuffer buff = decoder.byteBuffer(MESSAGE);
            final EhcacheEntityMessage msg = this.decodeMessage(buff);
            list.add(new RecordedMessage<EhcacheEntityMessage, EhcacheEntityResponse>(){

                public ClientSourceId getClientSourceId() {
                    return new ClientSourceId(){

                        public long toLong() {
                            return cid;
                        }

                        public boolean matches(ClientDescriptor cd) {
                            return cd.getSourceId().toLong() == cid;
                        }
                    };
                }

                public long getTransactionId() {
                    return transaction;
                }

                public EhcacheEntityMessage getRequest() {
                    return msg;
                }

                public EhcacheEntityResponse getResponse() {
                    return null;
                }
            });
        }
        return new EhcacheMessageTrackerCatchup(list);
    }
}

