/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.ResponseCodec;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpCodec;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Util;
import org.ehcache.clustered.server.internal.messages.EhcacheDataSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheMessageTrackerMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheStateRepoSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessage;
import org.ehcache.clustered.server.internal.messages.SyncMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.SyncMessageCodec;
import org.terracotta.runnel.EnumMapping;
import org.terracotta.runnel.EnumMappingBuilder;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class EhcacheSyncMessageCodec
implements SyncMessageCodec<EhcacheEntityMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheSyncMessageCodec.class);
    private static final String SYNC_MESSAGE_TYPE_FIELD = "msgType";
    private static final String CHAIN_FIELD = "chain";
    private static final String CHAIN_MAP_ENTRIES_SUB_STRUCT = "entries";
    private static final String STATE_REPO_ENTRIES_SUB_STRUCT = "mappings";
    private static final String STATE_REPO_VALUE_FIELD = "value";
    private static final String STATE_REPO_MAP_NAME_FIELD = "mapName";
    private static final String MESSAGE_TRACKER_CLIENTS_STRUCT = "clients";
    private static final String MESSAGE_TRACKER_RESPONSES_STRUCT = "responses";
    private static final String MESSAGE_TRACKER_RESPONSE_FIELD = "response";
    private static final String MESSAGE_TRACKER_TRANSACTION_ID_FIELD = "tId";
    private static final String MESSAGE_TRACKER_SEGMENT_FIELD = "segment";
    private static final int SYNC_MESSAGE_TYPE_FIELD_INDEX = 10;
    private static final EnumMapping<SyncMessageType> SYNC_MESSAGE_TYPE_MAPPING = EnumMappingBuilder.newEnumMappingBuilder(SyncMessageType.class).mapping((Object)SyncMessageType.STATE_REPO, 1).mapping((Object)SyncMessageType.DATA, 10).mapping((Object)SyncMessageType.MESSAGE_TRACKER, 20).build();
    private static final Struct CHAIN_MAP_ENTRY_STRUCT = StructBuilder.newStructBuilder().int64("key", 10).struct("chain", 20, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct DATA_SYNC_STRUCT = StructBuilder.newStructBuilder().enm("msgType", 10, SYNC_MESSAGE_TYPE_MAPPING).structs("entries", 20, CHAIN_MAP_ENTRY_STRUCT).build();
    private static final Struct STATE_REPO_ENTRY_STRUCT = StructBuilder.newStructBuilder().byteBuffer("key", 10).byteBuffer("value", 20).build();
    private static final Struct STATE_REPO_SYNC_STRUCT = StructBuilder.newStructBuilder().enm("msgType", 10, SYNC_MESSAGE_TYPE_MAPPING).string("serverStoreName", 20).string("mapName", 30).structs("mappings", 40, STATE_REPO_ENTRY_STRUCT).build();
    private static final Struct MESSAGE_TRACKER_RESPONSE_STRUCT = StructBuilder.newStructBuilder().int64("tId", 10).byteBuffer("response", 20).build();
    private static final Struct MESSAGE_TRACKER_CLIENT_STRUCT = StructBuilder.newStructBuilder().int64("key", 10).structs("responses", 20, MESSAGE_TRACKER_RESPONSE_STRUCT).build();
    private static final Struct MESSAGE_TRACKER_SYNC_STRUCT = StructBuilder.newStructBuilder().enm("msgType", 10, SYNC_MESSAGE_TYPE_MAPPING).structs("clients", 20, MESSAGE_TRACKER_CLIENT_STRUCT).int32("segment", 30).build();
    private final ResponseCodec responseCodec;

    public EhcacheSyncMessageCodec(ResponseCodec responseCodec) {
        this.responseCodec = responseCodec;
    }

    public byte[] encode(int concurrencyKey, EhcacheEntityMessage message) {
        if (message instanceof EhcacheSyncMessage) {
            EhcacheSyncMessage syncMessage = (EhcacheSyncMessage)message;
            switch (syncMessage.getMessageType()) {
                case DATA: {
                    return this.encodeDataSync((EhcacheDataSyncMessage)syncMessage);
                }
                case STATE_REPO: {
                    return this.encodeStateRepoSync((EhcacheStateRepoSyncMessage)syncMessage);
                }
                case MESSAGE_TRACKER: {
                    return this.encodeMessageTrackerSync((EhcacheMessageTrackerMessage)syncMessage);
                }
            }
            throw new IllegalArgumentException("Sync message codec can not encode " + syncMessage.getMessageType());
        }
        throw new IllegalArgumentException(this.getClass().getName() + " can not encode " + message + " which is not a " + EhcacheSyncMessage.class.getName());
    }

    private byte[] encodeMessageTrackerSync(EhcacheMessageTrackerMessage syncMessage) {
        StructEncoder encoder = MESSAGE_TRACKER_SYNC_STRUCT.encoder();
        encoder.enm(SYNC_MESSAGE_TYPE_FIELD, (Object)SyncMessageType.MESSAGE_TRACKER).structs(MESSAGE_TRACKER_CLIENTS_STRUCT, syncMessage.getTrackedMessages().entrySet(), (clientEncoder, entry) -> {
            Map responses = (Map)entry.getValue();
            if (!responses.isEmpty()) {
                clientEncoder.int64("key", ((Long)entry.getKey()).longValue());
                clientEncoder.structs(MESSAGE_TRACKER_RESPONSES_STRUCT, responses.entrySet(), (responseEncoder, response) -> {
                    responseEncoder.int64(MESSAGE_TRACKER_TRANSACTION_ID_FIELD, ((Long)response.getKey()).longValue());
                    responseEncoder.byteBuffer(MESSAGE_TRACKER_RESPONSE_FIELD, this.encodeResponse((EhcacheEntityResponse)response.getValue()));
                });
            }
        });
        return encoder.encode().array();
    }

    private ByteBuffer encodeResponse(EhcacheEntityResponse response) {
        return ByteBuffer.wrap(this.responseCodec.encode(response));
    }

    private byte[] encodeStateRepoSync(EhcacheStateRepoSyncMessage syncMessage) {
        StructEncoder encoder = STATE_REPO_SYNC_STRUCT.encoder();
        encoder.enm(SYNC_MESSAGE_TYPE_FIELD, (Object)SyncMessageType.STATE_REPO).string("serverStoreName", syncMessage.getCacheId()).string(STATE_REPO_MAP_NAME_FIELD, syncMessage.getMapId());
        encoder.structs(STATE_REPO_ENTRIES_SUB_STRUCT, syncMessage.getMappings().entrySet(), (entryEncoder, entry) -> entryEncoder.byteBuffer("key", ByteBuffer.wrap(Util.marshall(entry.getKey()))).byteBuffer(STATE_REPO_VALUE_FIELD, ByteBuffer.wrap(Util.marshall(entry.getValue()))));
        return encoder.encode().array();
    }

    private byte[] encodeDataSync(EhcacheDataSyncMessage syncMessage) {
        StructEncoder encoder = DATA_SYNC_STRUCT.encoder();
        encoder.enm(SYNC_MESSAGE_TYPE_FIELD, (Object)SyncMessageType.DATA);
        encoder.structs(CHAIN_MAP_ENTRIES_SUB_STRUCT, syncMessage.getChainMap().entrySet(), (entryEncoder, entry) -> {
            entryEncoder.int64("key", ((Long)entry.getKey()).longValue());
            entryEncoder.struct(CHAIN_FIELD, entry.getValue(), ChainCodec::encodeChain);
        });
        return encoder.encode().array();
    }

    public EhcacheSyncMessage decode(int concurrencyKey, byte[] payload) {
        ByteBuffer message = ByteBuffer.wrap(payload);
        StructDecoder decoder = DATA_SYNC_STRUCT.decoder(message);
        Enm enm = decoder.enm(SYNC_MESSAGE_TYPE_FIELD);
        if (!enm.isFound()) {
            throw new AssertionError((Object)"Invalid message format - misses the message type field");
        }
        if (!enm.isValid()) {
            LOGGER.warn("Unknown sync message received - ignoring {}", (Object)enm.raw());
            return null;
        }
        message.rewind();
        switch ((SyncMessageType)enm.get()) {
            case DATA: {
                return this.decodeDataSync(message);
            }
            case STATE_REPO: {
                return this.decodeStateRepoSync(message);
            }
            case MESSAGE_TRACKER: {
                return this.decodeMessageTracker(message);
            }
        }
        throw new AssertionError((Object)"Cannot happen given earlier checks");
    }

    private EhcacheSyncMessage decodeMessageTracker(ByteBuffer message) {
        StructDecoder decoder = MESSAGE_TRACKER_SYNC_STRUCT.decoder(message);
        HashMap<Long, Map<Long, EhcacheEntityResponse>> trackedMessages = new HashMap<Long, Map<Long, EhcacheEntityResponse>>();
        StructArrayDecoder clientsDecoder = decoder.structs(MESSAGE_TRACKER_CLIENTS_STRUCT);
        if (clientsDecoder != null) {
            while (clientsDecoder.hasNext()) {
                StructDecoder clientDecoder = clientsDecoder.next();
                Long clientId = clientDecoder.int64("key");
                HashMap<Long, EhcacheEntityResponse> responses = new HashMap<Long, EhcacheEntityResponse>();
                trackedMessages.put(clientId, responses);
                StructArrayDecoder responsesDecoder = clientDecoder.structs(MESSAGE_TRACKER_RESPONSES_STRUCT);
                if (responsesDecoder == null) continue;
                while (responsesDecoder.hasNext()) {
                    StructDecoder responseDecoder = responsesDecoder.next();
                    Long transactionId = responseDecoder.int64(MESSAGE_TRACKER_TRANSACTION_ID_FIELD);
                    ByteBuffer bb = responseDecoder.byteBuffer(MESSAGE_TRACKER_RESPONSE_FIELD);
                    byte[] encodedResponse = new byte[bb.remaining()];
                    bb.get(encodedResponse);
                    EhcacheEntityResponse res = this.responseCodec.decode(encodedResponse);
                    responses.put(transactionId, res);
                }
            }
        }
        return new EhcacheMessageTrackerMessage(trackedMessages);
    }

    private EhcacheSyncMessage decodeStateRepoSync(ByteBuffer message) {
        StructDecoder decoder = STATE_REPO_SYNC_STRUCT.decoder(message);
        String storeId = decoder.string("serverStoreName");
        String mapId = decoder.string(STATE_REPO_MAP_NAME_FIELD);
        ConcurrentHashMap<Object, Object> mappings = new ConcurrentHashMap<Object, Object>();
        StructArrayDecoder structsDecoder = decoder.structs(STATE_REPO_ENTRIES_SUB_STRUCT);
        if (structsDecoder != null) {
            while (structsDecoder.hasNext()) {
                StructDecoder structDecoder = structsDecoder.next();
                Object key = Util.unmarshall((ByteBuffer)structDecoder.byteBuffer("key"), (Predicate)StateRepositoryOpCodec.WHITELIST_PREDICATE);
                Object value = Util.unmarshall((ByteBuffer)structDecoder.byteBuffer(STATE_REPO_VALUE_FIELD), (Predicate)StateRepositoryOpCodec.WHITELIST_PREDICATE);
                mappings.put(key, value);
            }
        }
        return new EhcacheStateRepoSyncMessage(storeId, mapId, mappings);
    }

    private EhcacheSyncMessage decodeDataSync(ByteBuffer message) {
        StructDecoder decoder = DATA_SYNC_STRUCT.decoder(message);
        Map<Long, Chain> chainMap = this.decodeChainMapEntries((StructDecoder<Void>)decoder);
        return new EhcacheDataSyncMessage(chainMap);
    }

    private Map<Long, Chain> decodeChainMapEntries(StructDecoder<Void> decoder) {
        StructArrayDecoder entriesDecoder = decoder.structs(CHAIN_MAP_ENTRIES_SUB_STRUCT);
        if (entriesDecoder != null) {
            int len = entriesDecoder.length();
            HashMap<Long, Chain> chainMap = new HashMap<Long, Chain>((int)((float)len / 0.75f + 1.0f));
            for (int i = 0; i < len; ++i) {
                StructDecoder entryDecoder = entriesDecoder.next();
                Long key = entryDecoder.int64("key");
                StructDecoder chainDecoder = entryDecoder.struct(CHAIN_FIELD);
                Chain chain = ChainCodec.decodeChain((StructDecoder)chainDecoder);
                chainMap.put(key, chain);
                entryDecoder.end();
            }
            return chainMap;
        }
        return Collections.emptyMap();
    }
}

