/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectStreamClass;
import java.util.function.Predicate;
import org.ehcache.clustered.common.internal.store.CustomLoaderBasedObjectInputStream;

public class FilteredObjectInputStream
extends CustomLoaderBasedObjectInputStream {
    private Predicate<Class<?>> isClassPermitted;

    public FilteredObjectInputStream(InputStream in, Predicate<Class<?>> isClassPermitted, ClassLoader loader) throws IOException {
        super(in, loader);
        this.isClassPermitted = isClassPermitted;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass serialInput) throws IOException, ClassNotFoundException {
        Class<?> c = super.resolveClass(serialInput);
        if (!this.isClassPermitted.test(c)) {
            throw new InvalidClassException("Class deserialization of " + c.getName() + " blocked.");
        }
        return c;
    }
}

