/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import org.ehcache.clustered.common.internal.messages.BaseCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.common.internal.store.Util;
import org.ehcache.clustered.common.internal.store.ValueWrapper;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;

public class StateRepositoryOpCodec {
    private static final String MAP_ID_FIELD = "mapId";
    private static final String VALUE_FIELD = "value";
    private static final Struct GET_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 30).string("mapId", 35).byteBuffer("key", 40).build();
    private static final Struct PUT_IF_ABSENT_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 30).string("mapId", 35).byteBuffer("key", 40).byteBuffer("value", 45).build();
    private static final Struct ENTRY_SET_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 30).string("mapId", 35).build();
    public static final Predicate<Class<?>> WHITELIST_PREDICATE = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Float.class, Double.class, Byte.class, Character.class, String.class, Boolean.class, Short.class, Number.class, ValueWrapper.class, byte[].class, HashSet.class, AbstractMap.SimpleEntry.class))::contains;

    public byte[] encode(StateRepositoryOpMessage message) {
        switch (message.getMessageType()) {
            case GET_STATE_REPO: {
                return this.encodeGetMessage((StateRepositoryOpMessage.GetMessage)message);
            }
            case PUT_IF_ABSENT: {
                return this.encodePutIfAbsentMessage((StateRepositoryOpMessage.PutIfAbsentMessage)message);
            }
            case ENTRY_SET: {
                return this.encodeEntrySetMessage((StateRepositoryOpMessage.EntrySetMessage)message);
            }
        }
        throw new IllegalArgumentException("Unsupported StateRepositoryOpMessage " + message.getClass());
    }

    private byte[] encodeEntrySetMessage(StateRepositoryOpMessage.EntrySetMessage message) {
        return MessageCodecUtils.encodeMandatoryFields(ENTRY_SET_MESSAGE_STRUCT, (EhcacheOperationMessage)message).string("serverStoreName", message.getCacheId()).string(MAP_ID_FIELD, message.getCacheId()).encode().array();
    }

    private byte[] encodePutIfAbsentMessage(StateRepositoryOpMessage.PutIfAbsentMessage message) {
        return MessageCodecUtils.encodeMandatoryFields(PUT_IF_ABSENT_MESSAGE_STRUCT, (EhcacheOperationMessage)message).string("serverStoreName", message.getCacheId()).string(MAP_ID_FIELD, message.getCacheId()).byteBuffer("key", ByteBuffer.wrap(Util.marshall(message.getKey()))).byteBuffer(VALUE_FIELD, ByteBuffer.wrap(Util.marshall(message.getValue()))).encode().array();
    }

    private byte[] encodeGetMessage(StateRepositoryOpMessage.GetMessage message) {
        return MessageCodecUtils.encodeMandatoryFields(GET_MESSAGE_STRUCT, (EhcacheOperationMessage)message).string("serverStoreName", message.getCacheId()).string(MAP_ID_FIELD, message.getCacheId()).byteBuffer("key", ByteBuffer.wrap(Util.marshall(message.getKey()))).encode().array();
    }

    public StateRepositoryOpMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case GET_STATE_REPO: {
                return this.decodeGetMessage(messageBuffer);
            }
            case PUT_IF_ABSENT: {
                return this.decodePutIfAbsentMessage(messageBuffer);
            }
            case ENTRY_SET: {
                return this.decodeEntrySetMessage(messageBuffer);
            }
        }
        throw new IllegalArgumentException("Unsupported StateRepositoryOpMessage " + messageType);
    }

    private StateRepositoryOpMessage.EntrySetMessage decodeEntrySetMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = ENTRY_SET_MESSAGE_STRUCT.decoder(messageBuffer);
        String storeName = decoder.string("serverStoreName");
        String mapId = decoder.string(MAP_ID_FIELD);
        return new StateRepositoryOpMessage.EntrySetMessage(storeName, mapId);
    }

    private StateRepositoryOpMessage.PutIfAbsentMessage decodePutIfAbsentMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = PUT_IF_ABSENT_MESSAGE_STRUCT.decoder(messageBuffer);
        String storeName = decoder.string("serverStoreName");
        String mapId = decoder.string(MAP_ID_FIELD);
        ByteBuffer keyBuffer = decoder.byteBuffer("key");
        Object key = Util.unmarshall(keyBuffer, WHITELIST_PREDICATE);
        ByteBuffer valueBuffer = decoder.byteBuffer(VALUE_FIELD);
        Object value = Util.unmarshall(valueBuffer, WHITELIST_PREDICATE);
        return new StateRepositoryOpMessage.PutIfAbsentMessage(storeName, mapId, key, value);
    }

    private StateRepositoryOpMessage.GetMessage decodeGetMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = GET_MESSAGE_STRUCT.decoder(messageBuffer);
        String storeName = decoder.string("serverStoreName");
        String mapId = decoder.string(MAP_ID_FIELD);
        ByteBuffer keyBuffer = decoder.byteBuffer("key");
        Object key = Util.unmarshall(keyBuffer, WHITELIST_PREDICATE);
        return new StateRepositoryOpMessage.GetMessage(storeName, mapId, key);
    }
}

