/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.entity.topology.client.DynamicTopologyEntity;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionFactory;

public abstract class ConnectionSource {
    public abstract String getClusterTierManager();

    public abstract LeasedConnection connect(Properties var1) throws ConnectionException;

    public abstract URI getClusterUri();

    public static class ServerList
    extends ConnectionSource {
        private final CopyOnWriteArraySet<InetSocketAddress> servers;
        private final String clusterTierManager;

        public ServerList(Iterable<InetSocketAddress> servers, String clusterTierManager) {
            this.servers = this.createServerList(servers);
            this.clusterTierManager = Objects.requireNonNull(clusterTierManager, "Cluster tier manager identifier cannot be null");
        }

        private CopyOnWriteArraySet<InetSocketAddress> createServerList(Iterable<InetSocketAddress> servers) {
            Objects.requireNonNull(servers, "Servers cannot be null");
            CopyOnWriteArraySet<InetSocketAddress> serverList = new CopyOnWriteArraySet<InetSocketAddress>();
            servers.forEach(server -> serverList.add((InetSocketAddress)server));
            return serverList;
        }

        @Override
        public String getClusterTierManager() {
            return this.clusterTierManager;
        }

        @Override
        public LeasedConnection connect(Properties connectionProperties) throws ConnectionException {
            final LeasedConnection connection = LeasedConnectionFactory.connect(this.servers, (Properties)connectionProperties);
            try {
                EntityRef ref = connection.getEntityRef(DynamicTopologyEntity.class, 1L, "dynamic-config-topology-entity");
                final DynamicTopologyEntity dynamicTopologyEntity = (DynamicTopologyEntity)ref.fetchEntity(null);
                dynamicTopologyEntity.setListener(new DynamicTopologyEntity.Listener(){

                    public void onNodeRemoval(int stripeId, Node removedNode) {
                        servers.remove(removedNode.getAddress());
                    }

                    public void onNodeAddition(int stripeId, Node addedNode) {
                        servers.add(addedNode.getAddress());
                    }
                });
                return new LeasedConnection(){

                    public <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
                        return connection.getEntityRef(cls, version, name);
                    }

                    public void close() throws IOException {
                        Future close = dynamicTopologyEntity.releaseEntity();
                        try {
                            close.get(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (TimeoutException timeoutException) {
                        }
                        finally {
                            connection.close();
                        }
                    }
                };
            }
            catch (EntityNotFoundException | EntityNotProvidedException | EntityVersionMismatchException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public URI getClusterUri() {
            throw new IllegalStateException("Cannot use getClusterUri() on ConnectionSource.ServerList. Use getServers() instead.");
        }

        public Iterable<InetSocketAddress> getServers() {
            return this.cloneServers(this.servers);
        }

        public String toString() {
            return "servers: " + this.getServers() + " [cache-manager: " + this.getClusterTierManager() + "]";
        }

        private List<InetSocketAddress> cloneServers(Iterable<InetSocketAddress> servers) {
            ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
            servers.forEach(socketAddresses::add);
            return socketAddresses;
        }
    }

    public static class ClusterUri
    extends ConnectionSource {
        private final URI clusterUri;
        private final String clusterTierManager;

        public ClusterUri(URI clusterUri) {
            this.clusterUri = Objects.requireNonNull(clusterUri, "Cluster URI cannot be null");
            this.clusterTierManager = ClusterUri.extractCacheManager(clusterUri);
        }

        @Override
        public String getClusterTierManager() {
            return this.clusterTierManager;
        }

        @Override
        public LeasedConnection connect(Properties connectionProperties) throws ConnectionException {
            return LeasedConnectionFactory.connect((URI)ClusterUri.extractClusterUri(this.clusterUri), (Properties)connectionProperties);
        }

        @Override
        public URI getClusterUri() {
            return this.clusterUri;
        }

        public String toString() {
            return "clusterUri: " + this.clusterUri;
        }

        private static String extractCacheManager(URI uri) {
            URI baseUri = ClusterUri.extractClusterUri(uri);
            return baseUri.relativize(uri).getPath();
        }

        private static URI extractClusterUri(URI uri) {
            try {
                return new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

