/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.lock;

import java.io.Closeable;
import org.ehcache.clustered.client.internal.lock.VoltronReadWriteLockClient;
import org.ehcache.clustered.common.internal.lock.LockMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class VoltronReadWriteLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltronReadWriteLock.class);
    private final EntityRef<VoltronReadWriteLockClient, Void, Void> reference;

    public VoltronReadWriteLock(Connection connection, String id) {
        try {
            this.reference = VoltronReadWriteLock.createEntityRef(connection, id);
        }
        catch (EntityNotProvidedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Hold readLock() {
        return this.lock(LockMessaging.HoldType.READ);
    }

    public Hold writeLock() {
        return this.lock(LockMessaging.HoldType.WRITE);
    }

    public Hold tryReadLock() {
        return this.tryLock(LockMessaging.HoldType.READ);
    }

    public Hold tryWriteLock() {
        return this.tryLock(LockMessaging.HoldType.WRITE);
    }

    private Hold lock(LockMessaging.HoldType type) {
        VoltronReadWriteLockClient client = this.createClientEntity();
        client.lock(type);
        return new HoldImpl(client, type);
    }

    private Hold tryLock(LockMessaging.HoldType type) {
        VoltronReadWriteLockClient client = this.createClientEntity();
        if (client.tryLock(type)) {
            return new HoldImpl(client, type);
        }
        client.close();
        this.tryDestroy();
        return null;
    }

    private void tryDestroy() {
        try {
            boolean destroyed = this.reference.destroy();
            if (destroyed) {
                LOGGER.debug("Destroyed lock entity " + this.reference.getName());
            }
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        catch (EntityNotFoundException e) {
        }
        catch (PermanentEntityException e) {
            LOGGER.error("Failed to destroy lock entity - server says it is permanent", (Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    private VoltronReadWriteLockClient createClientEntity() {
        try {
            while (true) {
                try {
                    this.reference.create(null);
                    LOGGER.debug("Created lock entity " + this.reference.getName());
                }
                catch (EntityAlreadyExistsException entityAlreadyExistsException) {
                }
                catch (EntityConfigurationException e) {
                    LOGGER.error("Error creating lock entity - configuration exception", (Throwable)e);
                    throw new AssertionError((Object)e);
                }
                try {
                    return (VoltronReadWriteLockClient)this.reference.fetchEntity(null);
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                break;
            }
        }
        catch (EntityNotProvidedException | EntityVersionMismatchException e) {
            throw new IllegalStateException(e);
        }
    }

    private static EntityRef<VoltronReadWriteLockClient, Void, Void> createEntityRef(Connection connection, String identifier) throws EntityNotProvidedException {
        return connection.getEntityRef(VoltronReadWriteLockClient.class, 1L, "VoltronReadWriteLock-" + identifier);
    }

    public static interface Hold
    extends Closeable {
        @Override
        public void close();

        public void unlock();
    }

    private class HoldImpl
    implements Hold {
        private final VoltronReadWriteLockClient client;
        private final LockMessaging.HoldType type;

        public HoldImpl(VoltronReadWriteLockClient client, LockMessaging.HoldType type) {
            this.client = client;
            this.type = type;
        }

        @Override
        public void close() {
            this.unlock();
        }

        @Override
        public void unlock() {
            this.client.unlock(this.type);
            this.client.close();
            VoltronReadWriteLock.this.tryDestroy();
        }
    }
}

