/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.txmgr.btm;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAResource;
import org.ehcache.transactions.xa.txmgr.XAResourceRegistry;
import org.ehcache.transactions.xa.txmgr.btm.Ehcache3XAResourceProducer;

public class BitronixXAResourceRegistry
implements XAResourceRegistry {
    private final ConcurrentMap<String, Ehcache3XAResourceProducer> producers = new ConcurrentHashMap<String, Ehcache3XAResourceProducer>();

    @Override
    public void registerXAResource(String uniqueName, XAResource xaResource) {
        Ehcache3XAResourceProducer xaResourceProducer = (Ehcache3XAResourceProducer)((Object)this.producers.get(uniqueName));
        if (xaResourceProducer == null) {
            xaResourceProducer = new Ehcache3XAResourceProducer();
            xaResourceProducer.setUniqueName(uniqueName);
            xaResourceProducer.addXAResource(xaResource);
            Ehcache3XAResourceProducer previous = this.producers.putIfAbsent(uniqueName, xaResourceProducer);
            if (previous == null) {
                xaResourceProducer.init();
            } else {
                previous.addXAResource(xaResource);
            }
        } else {
            xaResourceProducer.addXAResource(xaResource);
        }
    }

    @Override
    public void unregisterXAResource(String uniqueName, XAResource xaResource) {
        Ehcache3XAResourceProducer xaResourceProducer = (Ehcache3XAResourceProducer)((Object)this.producers.get(uniqueName));
        if (xaResourceProducer != null) {
            boolean found = xaResourceProducer.removeXAResource(xaResource);
            if (!found) {
                throw new IllegalStateException("no XAResource " + xaResource + " found in XAResourceProducer with name " + uniqueName);
            }
            if (xaResourceProducer.isEmpty()) {
                xaResourceProducer.close();
                this.producers.remove(uniqueName);
            }
        } else {
            throw new IllegalStateException("no XAResourceProducer registered with name " + uniqueName);
        }
    }
}

