/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.core.spi.store.events.StoreEvent;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.event.EventType;
import org.ehcache.transactions.xa.internal.SoftLock;

class StoreEventSourceWrapper<K, V>
implements StoreEventSource<K, V> {
    private final StoreEventSource<K, SoftLock<V>> underlying;
    private final Map<StoreEventListener<K, V>, StoreEventListener<K, SoftLock<V>>> listenersMap = new ConcurrentHashMap<StoreEventListener<K, V>, StoreEventListener<K, SoftLock<V>>>(10);

    StoreEventSourceWrapper(StoreEventSource<K, SoftLock<V>> underlying) {
        this.underlying = underlying;
        underlying.addEventFilter((type, key, oldValue, newValue) -> {
            if (newValue != null) {
                return newValue.getOldValue() != null;
            }
            if (oldValue != null) {
                return oldValue.getOldValue() != null;
            }
            return false;
        });
    }

    public void addEventListener(StoreEventListener<K, V> eventListener) {
        StoreEventListenerWrapper listenerWrapper = new StoreEventListenerWrapper(eventListener);
        this.listenersMap.put(eventListener, listenerWrapper);
        this.underlying.addEventListener(listenerWrapper);
    }

    public void removeEventListener(StoreEventListener<K, V> eventListener) {
        StoreEventListener<K, SoftLock<V>> listenerWrapper = this.listenersMap.get(eventListener);
        if (listenerWrapper != null) {
            this.underlying.removeEventListener(listenerWrapper);
        }
    }

    public void addEventFilter(StoreEventFilter<K, V> eventFilter) {
        this.underlying.addEventFilter((type, key, oldValue, newValue) -> {
            Object unwrappedOldValue = null;
            Object unwrappedNewValue = null;
            if (oldValue != null) {
                unwrappedOldValue = oldValue.getOldValue();
            }
            if (newValue != null) {
                unwrappedNewValue = newValue.getOldValue();
            }
            if (unwrappedNewValue == null && unwrappedOldValue == null) {
                return false;
            }
            return eventFilter.acceptEvent(type, key, unwrappedOldValue, unwrappedNewValue);
        });
    }

    public void setEventOrdering(boolean ordering) {
        this.underlying.setEventOrdering(ordering);
    }

    public void setSynchronous(boolean synchronous) throws IllegalArgumentException {
        this.underlying.setSynchronous(synchronous);
    }

    public boolean isEventOrdering() {
        return this.underlying.isEventOrdering();
    }

    static class XaEvent<K, V>
    implements StoreEvent<K, V> {
        private final StoreEvent<K, SoftLock<V>> delegate;

        XaEvent(StoreEvent<K, SoftLock<V>> delegate) {
            this.delegate = delegate;
        }

        public EventType getType() {
            return this.delegate.getType();
        }

        public K getKey() {
            return (K)this.delegate.getKey();
        }

        public V getNewValue() {
            SoftLock newValue = (SoftLock)this.delegate.getNewValue();
            if (newValue == null) {
                return null;
            }
            return newValue.getOldValue();
        }

        public V getOldValue() {
            SoftLock oldValue = (SoftLock)this.delegate.getOldValue();
            if (oldValue == null) {
                return null;
            }
            return oldValue.getOldValue();
        }
    }

    private static class StoreEventListenerWrapper<K, V>
    implements StoreEventListener<K, SoftLock<V>> {
        private final StoreEventListener<K, V> wrappedOne;

        private StoreEventListenerWrapper(StoreEventListener<K, V> wrappedOne) {
            if (wrappedOne == null) {
                throw new NullPointerException("Wrapped StoreEventListener cannot be null");
            }
            this.wrappedOne = wrappedOne;
        }

        public void onEvent(StoreEvent<K, SoftLock<V>> event) {
            this.wrappedOne.onEvent(new XaEvent<K, V>(event));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoreEventListenerWrapper that = (StoreEventListenerWrapper)o;
            return this.wrappedOne.equals(that.wrappedOne);
        }

        public int hashCode() {
            return this.wrappedOne.hashCode();
        }
    }
}

