/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.ehcache.core.internal.util.TypeUtil;
import org.ehcache.core.spi.store.AbstractValueHolder;
import org.ehcache.core.spi.store.Store;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.transactions.xa.internal.SoftLock;

@SuppressFBWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"})
public class XAValueHolder<V>
extends AbstractValueHolder<V>
implements Serializable {
    private final V value;
    private final byte[] valueSerialized;

    public XAValueHolder(Store.ValueHolder<SoftLock<V>> valueHolder, V value) {
        super(-1L, valueHolder.creationTime(), valueHolder.expirationTime());
        this.value = value;
        this.valueSerialized = null;
    }

    public XAValueHolder(V value, long creationTime) {
        super(-1L, creationTime, -1L);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.value = value;
        this.valueSerialized = null;
    }

    private XAValueHolder(XAValueHolder<V> valueHolder, ByteBuffer serializedValue) {
        super(-1L, valueHolder.creationTime(), valueHolder.expirationTime());
        this.value = null;
        this.valueSerialized = new byte[serializedValue.remaining()];
        serializedValue.get(this.valueSerialized);
    }

    public XAValueHolder(XAValueHolder<V> valueHolder, V value) {
        super(-1L, valueHolder.creationTime(), valueHolder.expirationTime());
        this.value = value;
        this.valueSerialized = null;
    }

    private XAValueHolder(long id, long creationTime, long lastAccessTime, long expirationTime, V value, byte[] valueSerialized) {
        super(id, creationTime, expirationTime);
        this.setLastAccessTime(lastAccessTime);
        this.value = value;
        this.valueSerialized = valueSerialized;
    }

    protected XAValueHolder<V> copyForSerialization(Serializer<V> valueSerializer) {
        ByteBuffer serializedValue = valueSerializer.serialize(this.value);
        return new XAValueHolder<ByteBuffer>((XAValueHolder<ByteBuffer>)this, serializedValue);
    }

    protected XAValueHolder<V> copyAfterDeserialization(Serializer<V> valueSerializer) throws ClassNotFoundException {
        return new XAValueHolder<Object>(this, valueSerializer.read(ByteBuffer.wrap(this.valueSerialized)));
    }

    public V get() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        XAValueHolder that = (XAValueHolder)TypeUtil.uncheckedCast((Object)other);
        if (!super.equals((Object)that)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    private Object writeReplace() {
        return new SerializedXAValueHolder<V>(this.getId(), this.creationTime(), this.lastAccessTime(), this.expirationTime(), this.get(), this.valueSerialized);
    }

    private static class SerializedXAValueHolder<V>
    implements Serializable {
        private static final long serialVersionUID = -9126450990666297321L;
        private final long id;
        private final long creationTime;
        private final long lastAccessTime;
        private final long expirationTime;
        private final V value;
        private final byte[] valueSerialized;

        SerializedXAValueHolder(long id, long creationTime, long lastAccessTime, long expirationTime, V value, byte[] valueSerialized) {
            this.id = id;
            this.creationTime = creationTime;
            this.lastAccessTime = lastAccessTime;
            this.expirationTime = expirationTime;
            this.value = value;
            this.valueSerialized = valueSerialized;
        }

        private Object readResolve() {
            return new XAValueHolder(this.id, this.creationTime, this.lastAccessTime, this.expirationTime, this.value, this.valueSerialized);
        }
    }
}

