/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.ehcache.transactions.xa.internal.SoftLock;

class SoftLockSerializer<T>
implements Serializer<SoftLock<T>> {
    private final ClassLoader classLoader;

    SoftLockSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ByteBuffer serialize(SoftLock<T> object) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(object);
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    /*
     * Exception decompiling
     */
    public SoftLock<T> read(ByteBuffer entry) throws SerializerException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean equals(SoftLock<T> object, ByteBuffer binary) throws SerializerException, ClassNotFoundException {
        return object.equals(this.read(binary));
    }

    private static class OIS
    extends ObjectInputStream {
        private final ClassLoader classLoader;
        private static final Map<String, Class<?>> primitiveClasses = new HashMap();

        public OIS(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                Class<?> primitive = primitiveClasses.get(desc.getName());
                if (primitive != null) {
                    return primitive;
                }
                throw cnfe;
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            Class[] interfaceClasses = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceClasses[i] = Class.forName(interfaces[i], false, this.classLoader);
            }
            return Proxy.getProxyClass(this.classLoader, interfaceClasses);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

