/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.transactions.xa.EhcacheXAException;
import org.ehcache.transactions.xa.internal.SerializableXid;
import org.ehcache.transactions.xa.internal.SoftLock;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.XATransactionContext;
import org.ehcache.transactions.xa.internal.XATransactionContextFactory;
import org.ehcache.transactions.xa.internal.journal.Journal;

public class EhcacheXAResource<K, V>
implements XAResource {
    private static final int DEFAULT_TRANSACTION_TIMEOUT_SECONDS = 30;
    private final Store<K, SoftLock<V>> underlyingStore;
    private final Journal<K> journal;
    private final XATransactionContextFactory<K, V> transactionContextFactory;
    private volatile Xid currentXid;
    private volatile int transactionTimeoutInSeconds = 30;
    private static final Map<Integer, String> XARESOURCE_FLAGS_TO_NAMES = new HashMap<Integer, String>();

    public EhcacheXAResource(Store<K, SoftLock<V>> underlyingStore, Journal<K> journal, XATransactionContextFactory<K, V> transactionContextFactory) {
        this.underlyingStore = underlyingStore;
        this.journal = journal;
        this.transactionContextFactory = transactionContextFactory;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block14: {
            if (this.currentXid != null) {
                throw new EhcacheXAException("Cannot commit a non-ended start on : " + xid, -6);
            }
            TransactionId transactionId = new TransactionId(xid);
            XATransactionContext<K, V> transactionContext = this.transactionContextFactory.get(transactionId);
            try {
                if (onePhase) {
                    if (transactionContext == null) {
                        throw new EhcacheXAException("Cannot commit in one phase unknown XID : " + xid, -4);
                    }
                    try {
                        transactionContext.commitInOnePhase();
                        break block14;
                    }
                    catch (XATransactionContext.TransactionTimeoutException tte) {
                        throw new EhcacheXAException("Transaction timed out", 106);
                    }
                }
                XATransactionContext<K, V> commitContext = transactionContext;
                if (commitContext == null) {
                    commitContext = new XATransactionContext<K, V>(new TransactionId(new SerializableXid(xid)), this.underlyingStore, this.journal, null, 0L);
                }
                commitContext.commit(transactionContext == null);
            }
            catch (IllegalArgumentException iae) {
                throw new EhcacheXAException("Cannot commit unknown XID : " + xid, -4);
            }
            catch (IllegalStateException ise) {
                throw new EhcacheXAException("Cannot commit XID : " + xid, -6, ise);
            }
            catch (StoreAccessException cae) {
                throw new EhcacheXAException("Cannot commit XID : " + xid, -3, cae);
            }
            finally {
                if (transactionContext != null) {
                    this.transactionContextFactory.destroy(transactionId);
                }
            }
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        TransactionId transactionId = new TransactionId(xid);
        if (this.journal.isInDoubt(transactionId)) {
            throw new EhcacheXAException("Cannot forget in-doubt XID : " + xid, -6);
        }
        if (!this.journal.isHeuristicallyTerminated(transactionId)) {
            throw new EhcacheXAException("Cannot forget unknown XID : " + xid, -4);
        }
        this.journal.forget(transactionId);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeoutInSeconds;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.currentXid != null) {
            throw new EhcacheXAException("Cannot prepare a non-ended start on : " + xid, -6);
        }
        TransactionId transactionId = new TransactionId(xid);
        XATransactionContext<K, V> transactionContext = this.transactionContextFactory.get(transactionId);
        if (transactionContext == null) {
            throw new EhcacheXAException("Cannot prepare unknown XID : " + xid, -4);
        }
        boolean destroyContext = false;
        try {
            destroyContext = transactionContext.prepare() == 0;
            int n = destroyContext ? 3 : 0;
            return n;
        }
        catch (XATransactionContext.TransactionTimeoutException tte) {
            destroyContext = true;
            throw new EhcacheXAException("Transaction timed out", 106);
        }
        catch (IllegalStateException ise) {
            throw new EhcacheXAException("Cannot prepare XID : " + xid, -6, ise);
        }
        catch (StoreAccessException cae) {
            throw new EhcacheXAException("Cannot prepare XID : " + xid, -3, cae);
        }
        finally {
            if (destroyContext) {
                this.transactionContextFactory.destroy(transactionId);
            }
        }
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        if (flags != 0 && flags != 0x1000000 && flags != 0x800000 && flags != 0x1800000) {
            throw new EhcacheXAException("Recover flags not supported : " + EhcacheXAResource.xaResourceFlagsToString(flags), -5);
        }
        if ((flags & 0x1000000) == 0x1000000) {
            ArrayList<SerializableXid> xids = new ArrayList<SerializableXid>();
            Set<TransactionId> transactionIds = this.journal.recover().keySet();
            for (TransactionId transactionId : transactionIds) {
                if (this.transactionContextFactory.contains(transactionId)) continue;
                xids.add(transactionId.getSerializableXid());
            }
            return xids.toArray(new Xid[xids.size()]);
        }
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.currentXid != null) {
            throw new EhcacheXAException("Cannot rollback a non-ended start on : " + xid, -6);
        }
        TransactionId transactionId = new TransactionId(xid);
        XATransactionContext<K, V> transactionContext = this.transactionContextFactory.get(transactionId);
        try {
            XATransactionContext<K, V> rollbackContext = transactionContext;
            if (rollbackContext == null) {
                rollbackContext = new XATransactionContext<K, V>(new TransactionId(new SerializableXid(xid)), this.underlyingStore, this.journal, null, 0L);
            }
            rollbackContext.rollback(transactionContext == null);
        }
        catch (IllegalStateException ise) {
            throw new EhcacheXAException("Cannot rollback unknown XID : " + xid, -4);
        }
        catch (StoreAccessException cae) {
            throw new EhcacheXAException("Cannot rollback XID : " + xid, -3, cae);
        }
        finally {
            if (transactionContext != null) {
                this.transactionContextFactory.destroy(transactionId);
            }
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw new EhcacheXAException("Transaction timeout must be >= 0", -5);
        }
        this.transactionTimeoutInSeconds = seconds == 0 ? 30 : seconds;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Xid xid, int flag) throws XAException {
        if (flag != 0 && flag != 0x200000) {
            throw new EhcacheXAException("Start flag not supported : " + EhcacheXAResource.xaResourceFlagsToString(flag), -5);
        }
        if (this.currentXid != null) {
            throw new EhcacheXAException("Already started on : " + xid, -6);
        }
        TransactionId transactionId = new TransactionId(xid);
        XATransactionContext<K, V> transactionContext = this.transactionContextFactory.get(transactionId);
        if (flag == 0) {
            if (transactionContext != null) throw new EhcacheXAException("Cannot start in parallel on two XIDs : starting " + xid, -3);
            transactionContext = this.transactionContextFactory.createTransactionContext(transactionId, this.underlyingStore, this.journal, this.transactionTimeoutInSeconds);
        } else if (transactionContext == null) {
            throw new EhcacheXAException("Cannot join unknown XID : " + xid, -4);
        }
        if (transactionContext.hasTimedOut()) {
            this.transactionContextFactory.destroy(transactionId);
            throw new EhcacheXAException("Transaction timeout for XID : " + xid, 106);
        }
        this.currentXid = xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        if (flag != 0x4000000 && flag != 0x20000000) {
            throw new EhcacheXAException("End flag not supported : " + EhcacheXAResource.xaResourceFlagsToString(flag), -5);
        }
        if (this.currentXid == null) {
            throw new EhcacheXAException("Not started on : " + xid, -6);
        }
        TransactionId transactionId = new TransactionId(this.currentXid);
        XATransactionContext<K, V> transactionContext = this.transactionContextFactory.get(transactionId);
        if (transactionContext == null) {
            throw new EhcacheXAException("Cannot end unknown XID : " + xid, -4);
        }
        boolean destroyContext = false;
        if (flag == 0x20000000) {
            destroyContext = true;
        }
        this.currentXid = null;
        try {
            if (transactionContext.hasTimedOut()) {
                destroyContext = true;
                throw new EhcacheXAException("Transaction timeout for XID : " + xid, 106);
            }
        }
        finally {
            if (destroyContext) {
                this.transactionContextFactory.destroy(transactionId);
            }
        }
    }

    public XATransactionContext<K, V> getCurrentContext() {
        if (this.currentXid == null) {
            return null;
        }
        return this.transactionContextFactory.get(new TransactionId(this.currentXid));
    }

    private static String xaResourceFlagsToString(int flags) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Integer, String>> entries = XARESOURCE_FLAGS_TO_NAMES.entrySet();
        for (Map.Entry<Integer, String> entry : entries) {
            int constant = entry.getKey();
            String name = entry.getValue();
            if (constant == 0 || (flags & constant) != constant) continue;
            sb.append(name).append("|");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append(XARESOURCE_FLAGS_TO_NAMES.get(0));
        }
        return sb.toString();
    }

    static {
        try {
            for (Field field : XAResource.class.getFields()) {
                String name = field.getName();
                if (!field.getType().equals(Integer.TYPE) || !name.startsWith("TM")) continue;
                Integer contant = (Integer)field.get(XAResource.class);
                XARESOURCE_FLAGS_TO_NAMES.put(contant, name);
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Cannot initialize XAResource flags map", iae);
        }
    }
}

