/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.core.spi.store.events.StoreEvent;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.event.EventType;
import org.ehcache.impl.internal.events.StoreEventImpl;
import org.ehcache.impl.internal.events.StoreEvents;
import org.ehcache.transactions.xa.internal.SoftLock;

class StoreEventSourceWrapper<K, V>
implements StoreEventSource<K, V> {
    private final StoreEventSource<K, SoftLock<V>> underlying;
    private final Map<StoreEventListener<K, V>, StoreEventListener<K, SoftLock<V>>> listenersMap = new ConcurrentHashMap<StoreEventListener<K, V>, StoreEventListener<K, SoftLock<V>>>(10);

    StoreEventSourceWrapper(StoreEventSource<K, SoftLock<V>> underlying) {
        this.underlying = underlying;
        underlying.addEventFilter(new StoreEventFilter<K, SoftLock<V>>(){

            public boolean acceptEvent(EventType type, K key, SoftLock<V> oldValue, SoftLock<V> newValue) {
                if (newValue != null) {
                    return newValue.getOldValue() != null;
                }
                if (oldValue != null) {
                    return oldValue.getOldValue() != null;
                }
                return false;
            }
        });
    }

    public void addEventListener(StoreEventListener<K, V> eventListener) {
        StoreEventListenerWrapper listenerWrapper = new StoreEventListenerWrapper(eventListener);
        this.listenersMap.put(eventListener, listenerWrapper);
        this.underlying.addEventListener(listenerWrapper);
    }

    public void removeEventListener(StoreEventListener<K, V> eventListener) {
        StoreEventListener<K, SoftLock<V>> listenerWrapper = this.listenersMap.get(eventListener);
        if (listenerWrapper != null) {
            this.underlying.removeEventListener(listenerWrapper);
        }
    }

    public void addEventFilter(final StoreEventFilter<K, V> eventFilter) {
        this.underlying.addEventFilter(new StoreEventFilter<K, SoftLock<V>>(){

            public boolean acceptEvent(EventType type, K key, SoftLock<V> oldValue, SoftLock<V> newValue) {
                Object unwrappedOldValue = null;
                Object unwrappedNewValue = null;
                if (oldValue != null) {
                    unwrappedOldValue = oldValue.getOldValue();
                }
                if (newValue != null) {
                    unwrappedNewValue = newValue.getOldValue();
                }
                if (unwrappedNewValue == null && unwrappedOldValue == null) {
                    return false;
                }
                return eventFilter.acceptEvent(type, key, unwrappedOldValue, unwrappedNewValue);
            }
        });
    }

    public void setEventOrdering(boolean ordering) {
        this.underlying.setEventOrdering(ordering);
    }

    public boolean isEventOrdering() {
        return this.underlying.isEventOrdering();
    }

    private static class StoreEventListenerWrapper<K, V>
    implements StoreEventListener<K, SoftLock<V>> {
        private final StoreEventListener<K, V> wrappedOne;

        private StoreEventListenerWrapper(StoreEventListener<K, V> wrappedOne) {
            if (wrappedOne == null) {
                throw new NullPointerException("Wrapped StoreEventListener cannot be null");
            }
            this.wrappedOne = wrappedOne;
        }

        public void onEvent(StoreEvent<K, SoftLock<V>> event) {
            StoreEvent eventToPropagate = null;
            switch (event.getType()) {
                case CREATED: {
                    eventToPropagate = StoreEvents.createEvent((Object)event.getKey(), ((SoftLock)event.getNewValue()).getOldValue());
                    break;
                }
                case UPDATED: {
                    eventToPropagate = StoreEvents.updateEvent((Object)event.getKey(), ((SoftLock)event.getOldValue()).getOldValue(), ((SoftLock)event.getNewValue()).getOldValue());
                    break;
                }
                case REMOVED: 
                case EXPIRED: 
                case EVICTED: {
                    eventToPropagate = new StoreEventImpl(event.getType(), event.getKey(), ((SoftLock)event.getOldValue()).getOldValue(), null);
                }
            }
            this.wrappedOne.onEvent(eventToPropagate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoreEventListenerWrapper that = (StoreEventListenerWrapper)o;
            return this.wrappedOne.equals(that.wrappedOne);
        }

        public int hashCode() {
            return this.wrappedOne.hashCode();
        }
    }
}

