/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.journal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.TypeUtil;
import org.ehcache.transactions.xa.internal.journal.TransientJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentJournal<K>
extends TransientJournal<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentJournal.class);
    private static final String JOURNAL_FILENAME = "journal.data";
    private final File directory;
    private final Serializer<K> keySerializer;

    public PersistentJournal(File directory, Serializer<K> keySerializer) {
        if (directory == null) {
            throw new NullPointerException("directory must not be null");
        }
        if (keySerializer == null) {
            throw new NullPointerException("keySerializer must not be null");
        }
        this.directory = directory;
        this.keySerializer = keySerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        File file = new File(this.directory, JOURNAL_FILENAME);
        if (file.isFile()) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                boolean valid = ois.readBoolean();
                this.states.clear();
                if (valid) {
                    Map readStates = (Map)TypeUtil.uncheckedCast(ois.readObject());
                    for (Map.Entry entry : readStates.entrySet()) {
                        SerializableEntry value = (SerializableEntry)entry.getValue();
                        this.states.put((TransactionId)entry.getKey(), new TransientJournal.Entry<K>(value.state, value.heuristic, value.deserializeKeys(this.keySerializer)));
                    }
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("Cannot read XA journal, truncating it", (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Cannot deserialize XA journal contents, truncating it", (Throwable)cnfe);
            }
            finally {
                try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
                    oos.writeObject(false);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(this.directory, JOURNAL_FILENAME)));){
            oos.writeBoolean(true);
            HashMap<TransactionId, SerializableEntry<K>> toSerialize = new HashMap<TransactionId, SerializableEntry<K>>();
            for (Map.Entry entry : this.states.entrySet()) {
                TransactionId key = (TransactionId)entry.getKey();
                TransientJournal.Entry value = (TransientJournal.Entry)entry.getValue();
                toSerialize.put(key, new SerializableEntry<K>(value, this.keySerializer));
            }
            oos.writeObject(toSerialize);
            this.states.clear();
        }
    }

    protected static class SerializableEntry<K>
    implements Serializable {
        private static final long serialVersionUID = -6586025792671381923L;
        final TransientJournal.XAState state;
        final boolean heuristic;
        final Collection<byte[]> serializedKeys;

        protected SerializableEntry(TransientJournal.Entry<K> entry, Serializer<K> keySerializer) {
            this.state = entry.state;
            this.heuristic = entry.heuristic;
            this.serializedKeys = new ArrayList<byte[]>();
            for (Object key : entry.keys) {
                ByteBuffer byteBuffer = keySerializer.serialize(key);
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                this.serializedKeys.add(bytes);
            }
        }

        protected Collection<K> deserializeKeys(Serializer<K> keySerializer) throws ClassNotFoundException {
            ArrayList<Object> result = new ArrayList<Object>();
            for (byte[] serializedKey : this.serializedKeys) {
                Object key = keySerializer.read(ByteBuffer.wrap(serializedKey));
                result.add(key);
            }
            return result;
        }
    }
}

