/*
 * Copyright Terracotta, Inc.
 * Copyright Super iPaaS Integration LLC, an IBM Company 2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ehcache.transactions.xa.internal;

import javax.transaction.xa.Xid;
import java.io.Serializable;

/**
 * A globally unique transaction ID.
 *
 * @author Ludovic Orban
 */
public class TransactionId implements Serializable {

  private static final long serialVersionUID = 3283565495631790142L;
  private final SerializableXid serializableXid;

  public TransactionId(Xid xid) {
    this.serializableXid = new SerializableXid(xid);
  }

  public SerializableXid getSerializableXid() {
    return serializableXid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    TransactionId that = (TransactionId) o;

    return serializableXid.equals(that.serializableXid);

  }

  @Override
  public int hashCode() {
    return serializableXid.hashCode();
  }

  @Override
  public String toString() {
    return "TransactionId of " + serializableXid;
  }
}
