/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.Source;
import com.tc.async.impl.AbstractStageQueueImpl;
import com.tc.async.impl.Event;
import com.tc.async.impl.EventCreator;
import com.tc.exception.TCRuntimeException;
import com.tc.logging.TCLoggerProvider;
import com.tc.util.Assert;
import com.tc.util.concurrent.QueueFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SingletonStageQueueImpl<EC>
extends AbstractStageQueueImpl<EC> {
    private final SourceQueueImpl sourceQueue;

    SingletonStageQueueImpl(QueueFactory queueFactory, Class<EC> type, EventCreator<EC> creator, TCLoggerProvider loggerProvider, String stageName, int queueSize) {
        super(loggerProvider, stageName, creator);
        this.sourceQueue = this.createWorkerQueue(queueFactory, type, queueSize);
    }

    private SourceQueueImpl createWorkerQueue(QueueFactory queueFactory, Class<EC> type, int queueSize) {
        Assert.eval(queueSize >= 0);
        return new SourceQueueImpl(queueFactory.createInstance(type, queueSize));
    }

    @Override
    public Source getSource(int index) {
        return index != 0 ? null : this.sourceQueue;
    }

    @Override
    AbstractStageQueueImpl.SourceQueue[] getSources() {
        return new AbstractStageQueueImpl.SourceQueue[]{this.sourceQueue};
    }

    @Override
    public void addToSink(EC context) {
        Event wrapper;
        Assert.assertNotNull(context);
        if (this.isClosed()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added:" + context + " to:" + this.stageName);
        }
        if ((wrapper = this.createEvent(context)) != null) {
            this.deliverToQueue(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverToQueue(Event wrapper) {
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    this.updateDepth(this.sourceQueue.put(wrapper));
                }
                catch (InterruptedException e) {
                    this.logger.debug("StageQueue Add: " + e);
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toString() {
        return "StageQueue(" + this.stageName + ")";
    }

    @Override
    public int clear() {
        int clearCount = this.sourceQueue.clear();
        this.logger.info("Cleared " + clearCount);
        return clearCount;
    }

    private final class SourceQueueImpl
    implements AbstractStageQueueImpl.SourceQueue {
        private final BlockingQueue<Event> queue;

        public SourceQueueImpl(BlockingQueue<Event> queue) {
            this.queue = queue;
        }

        public String toString() {
            return "SourceQueueImpl{Singleton size=" + this.queue.size() + '}';
        }

        @Override
        public int clear() {
            int cleared = 0;
            try {
                while (this.poll(0L) != null) {
                    ++cleared;
                }
                return cleared;
            }
            catch (InterruptedException e) {
                throw new TCRuntimeException(e);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public Event poll(long timeout) throws InterruptedException {
            Event rv = timeout == 0L ? (Event)this.queue.poll() : this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            return rv;
        }

        @Override
        public int put(Event context) throws InterruptedException {
            this.queue.put(context);
            return this.queue.size();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public String getSourceName() {
            return "Singleton";
        }
    }
}

