/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.ClientEntityReferenceContext;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import com.tc.util.UUID;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class ClientHandshakeMessageImpl
extends DSOMessageBase
implements ClientHandshakeMessage {
    private static final byte UNUSED_1 = 1;
    private static final byte CLIENT_VERSION = 2;
    private static final byte UNUSED_2 = 3;
    private static final byte LOCAL_TIME_MILLS = 4;
    private static final byte RECONNECT_REFERENCES = 5;
    private static final byte RESEND_MESSAGES = 6;
    private static final byte CLIENT_PID = 7;
    private static final byte CLIENT_UUID = 8;
    private static final byte CLIENT_NAME = 9;
    private static final byte CLIENT_ADDRESS = 10;
    private static final byte CLIENT_REVISION = 11;
    private long currentLocalTimeMills = System.currentTimeMillis();
    private String uuid = UUID.NULL_ID.toString();
    private String name = "";
    private String clientVersion = "";
    private String clientRevision = "";
    private String clientAddress = "";
    private int pid = -1;
    private final Set<ClientEntityReferenceContext> reconnectReferences = new HashSet<ClientEntityReferenceContext>();
    private final Set<ResendVoltronEntityMessage> resendMessages = new TreeSet<ResendVoltronEntityMessage>(new Comparator<ResendVoltronEntityMessage>(){

        @Override
        public int compare(ResendVoltronEntityMessage first, ResendVoltronEntityMessage second) {
            return first.getTransactionID().compareTo(second.getTransactionID());
        }
    });

    public ClientHandshakeMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType messageType) {
        super(sessionID, monitor, out, channel, messageType);
        this.clientAddress = channel.getLocalAddress().getCanonicalStringForm();
    }

    public ClientHandshakeMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
        this.clientAddress = channel.getLocalAddress().getCanonicalStringForm();
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public String getClientRevision() {
        return this.clientRevision;
    }

    @Override
    public void setClientPID(int pid) {
        this.pid = pid;
    }

    @Override
    public int getClientPID() {
        return this.pid;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setClientVersion(String version) {
        this.clientVersion = version;
    }

    @Override
    public void setClientRevision(String revision) {
        this.clientRevision = revision;
    }

    @Override
    public long getLocalTimeMills() {
        return this.currentLocalTimeMills;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, false);
        this.putNVPair((byte)3, false);
        this.putNVPair((byte)8, this.uuid);
        this.putNVPair((byte)9, this.name);
        this.putNVPair((byte)2, this.clientVersion);
        this.putNVPair((byte)7, this.pid);
        this.putNVPair((byte)4, this.currentLocalTimeMills);
        for (ClientEntityReferenceContext referenceContext : this.reconnectReferences) {
            this.putNVPair((byte)5, referenceContext);
        }
        for (ResendVoltronEntityMessage resendMessage : this.resendMessages) {
            this.putNVPair((byte)6, resendMessage);
        }
        this.putNVPair((byte)10, this.clientAddress);
        this.putNVPair((byte)11, this.clientRevision);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.getBooleanValue();
                return true;
            }
            case 3: {
                this.getBooleanValue();
                return true;
            }
            case 2: {
                this.clientVersion = this.getStringValue();
                return true;
            }
            case 4: {
                this.currentLocalTimeMills = this.getLongValue();
                return true;
            }
            case 5: {
                this.reconnectReferences.add(this.getObject(new ClientEntityReferenceContext()));
                return true;
            }
            case 6: {
                this.resendMessages.add(this.getObject(new ResendVoltronEntityMessage()));
                return true;
            }
            case 7: {
                this.pid = this.getIntValue();
                return true;
            }
            case 8: {
                this.uuid = this.getStringValue();
                return true;
            }
            case 9: {
                this.name = this.getStringValue();
                return true;
            }
            case 10: {
                this.clientAddress = this.getStringValue();
                return true;
            }
            case 11: {
                this.clientRevision = this.getStringValue();
                return true;
            }
        }
        return false;
    }

    @Override
    public void addReconnectReference(ClientEntityReferenceContext context) {
        boolean newAddition = this.reconnectReferences.add(context);
        Assert.assertTrue(newAddition);
    }

    @Override
    public Collection<ClientEntityReferenceContext> getReconnectReferences() {
        return this.reconnectReferences;
    }

    @Override
    public void addResendMessage(ResendVoltronEntityMessage message) {
        boolean newAddition = this.resendMessages.add(message);
        Assert.assertTrue(newAddition);
    }

    @Override
    public Collection<ResendVoltronEntityMessage> getResendMessages() {
        return this.resendMessages;
    }
}

