/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.productinfo.PatchInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BasePatchInfo
implements PatchInfo {
    private final Properties props = new Properties();
    private static final String UNKNOWN = "[unknown]";
    private final boolean patched;

    public BasePatchInfo(InputStream is) throws IOException {
        if (is != null) {
            this.props.load(is);
            is.close();
            this.patched = true;
        } else {
            this.patched = false;
        }
    }

    @Override
    public String getTimestamp() {
        return this.props.getProperty("terracotta.patch.timestamp", UNKNOWN);
    }

    @Override
    public String getBranch() {
        return this.props.getProperty("terracotta.patch.branch", UNKNOWN);
    }

    @Override
    public String getRevision() {
        return this.props.getProperty("terracotta.patch.revision", UNKNOWN);
    }

    @Override
    public String getLevel() {
        return this.props.getProperty("terracotta.patch.level", UNKNOWN);
    }

    @Override
    public int count() {
        return 0;
    }

    public boolean isPatched() {
        return this.patched;
    }

    @Override
    public String getValue(String name) {
        return this.props.getProperty(name, UNKNOWN);
    }
}

