/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;

@Deprecated
public class DynamicConfigModelJsonModuleV1
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public DynamicConfigModelJsonModuleV1() {
        super(DynamicConfigModelJsonModuleV1.class.getSimpleName(), new Version(1, 0, 0, null, null, null));
        this.setMixInAnnotation(Node.class, NodeMixinV1.class);
        this.setMixInAnnotation(License.class, LicenseMixin.class);
        this.setMixInAnnotation(NodeContext.class, NodeContextMixin.class);
    }

    public static class LicenseMixin
    extends License {
        @JsonCreator
        public LicenseMixin(@JsonProperty(value="capabilities", required=true) Map<String, Long> capabilityLimitMap, @JsonProperty(value="expiryDate", required=true) LocalDate expiryDate) {
            super(capabilityLimitMap, Collections.emptyMap(), expiryDate);
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    public static class NodeMixinV1
    extends Node {
        @JsonProperty(value="nodeName")
        String name;
        @JsonProperty(value="nodeHostname")
        String hostname;
        @JsonProperty(value="nodePublicHostname")
        String publicHostname;
        @JsonProperty(value="nodePort")
        Integer port;
        @JsonProperty(value="nodePublicPort")
        Integer publicPort;
        @JsonProperty(value="nodeGroupPort")
        Integer groupPort;
        @JsonProperty(value="nodeBindAddress")
        String bindAddress;
        @JsonProperty(value="nodeGroupBindAddress")
        String groupBindAddress;
        @JsonProperty(value="nodeMetadataDir")
        Path metadataDir;
        @JsonProperty(value="nodeLogDir")
        Path logDir;
        @JsonProperty(value="nodeBackupDir")
        Path backupDir;
        @JsonProperty(value="nodeLoggerOverrides")
        Map<String, String> loggerOverrides;

        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public InetSocketAddress getInternalAddress() {
            return super.getInternalAddress();
        }

        @Override
        @JsonIgnore
        public Optional<InetSocketAddress> getPublicAddress() {
            return super.getPublicAddress();
        }

        @Override
        @JsonIgnore
        public Node.Endpoint getInternalEndpoint() {
            return super.getInternalEndpoint();
        }

        @Override
        @JsonIgnore
        public Optional<Node.Endpoint> getPublicEndpoint() {
            return super.getPublicEndpoint();
        }
    }

    public static class NodeContextMixin
    extends NodeContext {
        @JsonCreator
        public NodeContextMixin(@JsonProperty(value="cluster", required=true) Cluster cluster, @JsonProperty(value="stripeId", required=false) int stripeId, @JsonProperty(value="nodeName", required=true) String nodeName) {
            super(cluster, cluster.getNodeByName(nodeName).get().getUID());
        }

        @Override
        @JsonIgnore
        public Node getNode() {
            return super.getNode();
        }

        @Override
        @JsonIgnore
        public Stripe getStripe() {
            return super.getStripe();
        }

        @Override
        @JsonIgnore
        public UID getStripeUID() {
            return super.getStripeUID();
        }
    }
}

