/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    public static void reallySleep(long millis) {
        ThreadUtil.reallySleep(millis, 0);
    }

    public static void reallySleep(TimeUnit unit, long sleepTime) {
        ThreadUtil.reallySleep(unit.toMillis(sleepTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reallySleep(long millis, int nanos) {
        boolean interrupted = false;
        try {
            long start;
            for (long millisLeft = millis; millisLeft > 0L || nanos > 0; millisLeft -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                try {
                    Thread.sleep(millisLeft, nanos);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                nanos = 0;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static Thread executeInThread(Runnable run, String name, boolean asDaemon) {
        Thread t = new Thread(run, "Single Task Executor: " + name);
        t.setDaemon(asDaemon);
        t.start();
        return t;
    }

    public static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static <R extends Throwable> R getRootCause(Throwable t, Class<? extends R> type) {
        while (t != null) {
            if (type.isInstance(t)) {
                return (R)((Throwable)type.cast(t));
            }
            t = t.getCause();
        }
        return (R)((Throwable)type.cast(t));
    }
}

