/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.basic;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.net.core.BufferManager;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.tcm.TCActionNetworkMessage;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import com.tc.text.PrettyPrintable;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConnection
implements TCConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicConnection.class);
    private long connect = 0L;
    private volatile long last = System.currentTimeMillis();
    private volatile long received = System.currentTimeMillis();
    private final Consumer<TCConnection> closeRunnable;
    private final Consumer<WireProtocolMessage> write;
    private final TCProtocolAdaptor adaptor;
    private volatile BufferManager buffer;
    private final BufferManagerFactory bufferManagerFactory;
    private Socket src;
    private boolean established = false;
    private boolean connected = false;
    private final List<TCConnectionEventListener> listeners = new ArrayList<TCConnectionEventListener>();
    private volatile Thread serviceThread;
    private volatile ExecutorService readerExec;
    private final String id;

    public BasicConnection(String id, TCProtocolAdaptor adapter, BufferManagerFactory buffers, Consumer<TCConnection> close) {
        this.id = id;
        this.bufferManagerFactory = buffers;
        Object writeMutex = new Object();
        this.write = message -> {
            if (!message.prepareToSend()) {
                return;
            }
            Object object = writeMutex;
            synchronized (object) {
                block27: {
                    try {
                        if (this.src == null) break block27;
                        boolean interrupted = Thread.interrupted();
                        int totalLen = message.getTotalLength();
                        int moved = 0;
                        int sent = 0;
                        try (TCReference data = message.getEntireMessageData().duplicate();){
                            while (moved < totalLen) {
                                for (TCByteBuffer b : data) {
                                    if (!b.hasRemaining()) continue;
                                    ByteBuffer bb = b.getNioBuffer();
                                    moved += this.buffer.forwardToWriteBuffer(bb);
                                    b.returnNioBuffer(bb);
                                    if (!b.hasRemaining()) continue;
                                    break;
                                }
                                sent += this.buffer.sendFromBuffer();
                            }
                            while (sent < totalLen) {
                                sent += this.buffer.sendFromBuffer();
                            }
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        this.fireError(ioe, (TCNetworkMessage)message);
                        this.close();
                    }
                    catch (Exception t) {
                        this.fireError(t, (TCNetworkMessage)message);
                        this.close();
                    }
                    finally {
                        message.complete();
                    }
                }
            }
        };
        this.closeRunnable = close;
        this.adaptor = adapter;
    }

    @Override
    public long getConnectTime() {
        return this.connect;
    }

    @Override
    public long getIdleTime() {
        return System.currentTimeMillis() - this.last;
    }

    @Override
    public long getIdleReceiveTime() {
        return System.currentTimeMillis() - this.received;
    }

    void markReceived() {
        this.received = System.currentTimeMillis();
    }

    @Override
    public synchronized void addListener(TCConnectionEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeListener(TCConnectionEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void close() {
        try {
            this.asynchClose().get();
        }
        catch (ExecutionException e) {
            LOGGER.warn("close failed", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("close failed", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Future<Void> asynchClose() {
        try {
            this.closeRunnable.accept(this);
            this.shutdownBuffer();
            if (this.src != null) {
                SocketChannel channel = this.src.getChannel();
                this.tryOp(channel::shutdownInput);
                this.tryOp(channel::shutdownOutput);
                this.close(channel);
                this.close(this.src);
                LOGGER.debug("CLOSING {} channel {} isConnected: {} isConnectionPending: {}", new Object[]{System.identityHashCode(this), channel, channel.isConnected(), channel.isConnectionPending()});
            }
            Future<Void> future = this.shutdownAndAwaitTermination();
            return future;
        }
        finally {
            this.established = false;
            this.connected = false;
            this.fireClosed();
        }
    }

    private void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException t) {
            LOGGER.debug("failed", (Throwable)t);
        }
    }

    private void tryOp(Callable op) {
        try {
            op.call();
        }
        catch (Exception t) {
            LOGGER.debug("failed", (Throwable)t);
        }
    }

    private boolean shutdownBuffer() {
        BufferManager buff = this.buffer;
        if (buff != null) {
            try {
                buff.close();
                return true;
            }
            catch (IOException ie) {
                LOGGER.debug("failed to close buffer", (Throwable)ie);
            }
        }
        return false;
    }

    private Future<Void> shutdownAndAwaitTermination() {
        final ExecutorService reader = this.readerExec;
        if (reader != null) {
            reader.shutdownNow();
        }
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return reader == null || reader.isTerminated();
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                if (reader != null) {
                    reader.awaitTermination(0L, TimeUnit.DAYS);
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (reader != null) {
                    reader.awaitTermination(timeout, unit);
                }
                return null;
            }
        };
    }

    private synchronized List<TCConnectionEventListener> getListeners() {
        return new ArrayList<TCConnectionEventListener>(this.listeners);
    }

    private void fireClosed() {
        TCConnectionEvent event = new TCConnectionEvent(this);
        this.getListeners().forEach(l -> l.closeEvent(event));
    }

    private void fireConnect() {
        TCConnectionEvent event = new TCConnectionEvent(this);
        this.getListeners().forEach(l -> l.connectEvent(event));
    }

    private void fireEOF() {
        TCConnectionEvent event = new TCConnectionEvent(this);
        this.getListeners().forEach(l -> l.endOfFileEvent(event));
    }

    private void fireError(Exception err, TCNetworkMessage cxt) {
        TCConnectionErrorEvent event = new TCConnectionErrorEvent(this, err, cxt);
        this.getListeners().forEach(l -> l.errorEvent(event));
    }

    @Override
    public synchronized Socket connect(InetSocketAddress addr, int timeout) throws IOException, TCTimeoutException {
        boolean interrupted = Thread.interrupted();
        Assert.assertNull(this.readerExec);
        Assert.assertNull(this.src);
        SocketChannel channel = SocketChannel.open(new InetSocketAddress(InetAddress.getByName(addr.getHostString()), addr.getPort()));
        this.src = channel.socket();
        this.buffer = this.bufferManagerFactory.createBufferManager(channel, true);
        if (this.buffer == null) {
            throw new IOException("buffer manager not provided");
        }
        this.connected = this.src.isConnected();
        if (this.connected) {
            this.readMessages();
            this.fireConnect();
            this.connect = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("connected", (Throwable)new Exception());
        }
        return this.src;
    }

    @Override
    public boolean asynchConnect(InetSocketAddress addr) throws IOException {
        try {
            this.connect(addr, 0);
        }
        catch (TCTimeoutException timeout) {
            throw new IOException(timeout);
        }
        return true;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized boolean isClosed() {
        return !this.connected;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.src != null ? new InetSocketAddress(this.src.getLocalAddress(), this.src.getLocalPort()) : null;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.src != null ? new InetSocketAddress(this.src.getInetAddress(), this.src.getPort()) : null;
    }

    @Override
    public synchronized void setTransportEstablished() {
        this.established = true;
        LOGGER.debug("setting transport established");
    }

    @Override
    public synchronized boolean isTransportEstablished() {
        return this.established;
    }

    @Override
    public void putMessage(TCNetworkMessage message) {
        this.last = System.currentTimeMillis();
        WireProtocolMessage msg = this.buildWireProtocolMessage(message);
        if (msg != null) {
            this.write.accept(msg);
        }
    }

    private void readMessages() {
        Assert.assertNull(this.readerExec);
        this.readerExec = Executors.newFixedThreadPool(1, r -> {
            this.serviceThread = new Thread(r, this.id + " - BasicConnectionReader-" + this.src.getLocalSocketAddress() + "<-" + this.src.getRemoteSocketAddress() + " for (" + System.identityHashCode(this) + ")");
            this.serviceThread.setDaemon(true);
            return this.serviceThread;
        });
        LOGGER.debug("CREATED {} reader connected:{} established:{} reader:{}", new Object[]{System.identityHashCode(this), this.connected, this.established, this.readerExec});
        this.readerExec.submit(() -> {
            LOGGER.debug("STARTING {} reader connected:{} established:{}", new Object[]{System.identityHashCode(this), this.connected, this.established});
            boolean exiting = false;
            while (!this.isClosed()) {
                LOGGER.debug("STATUS {} exiting:{} connected:{} established:{}", new Object[]{System.identityHashCode(this), exiting, this.connected, this.established});
                if (exiting) {
                    return;
                }
                try {
                    long amount = this.buffer.recvToBuffer();
                    if (amount > 0L) {
                        if (amount > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)"overflow long");
                        }
                        int transfer = 0;
                        while ((long)transfer < amount) {
                            int read = 0;
                            TCByteBuffer[] buffers = this.adaptor.getReadBuffers();
                            for (int i = 0; i < buffers.length; ++i) {
                                read += this.buffer.forwardFromReadBuffer(buffers[i].getNioBuffer());
                                if (buffers[i].hasRemaining()) break;
                            }
                            this.adaptor.addReadData(this, buffers, read);
                            transfer += read;
                        }
                        this.markReceived();
                    } else if (amount < 0L) {
                        throw new EOFException();
                    }
                }
                catch (EOFException eof) {
                    if (!this.isClosed()) {
                        this.fireEOF();
                        this.close();
                    }
                    exiting = true;
                }
                catch (TCProtocolException | IOException ioe) {
                    if (!this.isClosed()) {
                        this.fireError(ioe, null);
                        LOGGER.debug("error reading from connection", (Throwable)ioe);
                        this.close();
                    }
                    exiting = true;
                }
                if (!exiting) continue;
                LOGGER.debug("anticipate exiting connected:{} established:{}", (Object)this.connected, (Object)this.established);
            }
            LOGGER.debug("EXITED {} connected:{} established:{}", new Object[]{System.identityHashCode(this), this.connected, this.established});
        });
    }

    private WireProtocolMessage buildWireProtocolMessage(TCNetworkMessage message) {
        TCActionNetworkMessage action;
        Objects.requireNonNull(message);
        if (message instanceof WireProtocolMessage) {
            return this.finalizeWireProtocolMessage((WireProtocolMessage)message);
        }
        if (message instanceof TCActionNetworkMessage && (action = (TCActionNetworkMessage)message).load() && action.commit()) {
            WireProtocolMessage wireMessage = WireProtocolMessageImpl.wrapMessage(action, this);
            return this.finalizeWireProtocolMessage(wireMessage);
        }
        return null;
    }

    private WireProtocolMessage finalizeWireProtocolMessage(WireProtocolMessage message) {
        WireProtocolHeader hdr = (WireProtocolHeader)message.getHeader();
        hdr.setSourceAddress(this.getLocalAddress().getAddress().getAddress());
        hdr.setSourcePort(this.getLocalAddress().getPort());
        hdr.setDestinationAddress(this.getRemoteAddress().getAddress().getAddress());
        hdr.setDestinationPort(this.getRemoteAddress().getPort());
        hdr.setMessageCount(1);
        hdr.computeChecksum();
        return message;
    }

    @Override
    public Map<String, ?> getState() {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        state.put("localAddress", this.getLocalAddress());
        state.put("remoteAddress", this.getRemoteAddress());
        state.put("connectTime", new Date(this.getConnectTime()));
        state.put("receiveIdleTime", this.getIdleReceiveTime());
        state.put("idleTime", this.getIdleTime());
        state.put("closed", this.isClosed());
        state.put("connected", this.isConnected());
        state.put("transportConnected", this.isTransportEstablished());
        if (this.buffer instanceof PrettyPrintable) {
            state.put("buffer", ((PrettyPrintable)((Object)this.buffer)).getStateMap());
        } else {
            state.put("buffer", this.buffer.toString());
        }
        return state;
    }
}

