/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding.fields;

import java.io.PrintStream;
import org.terracotta.runnel.EnumMapping;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.fields.AbstractValueField;
import org.terracotta.runnel.utils.ReadBuffer;

public class EnumField<E>
extends AbstractValueField<Enm<E>> {
    private final EnumMapping<E> enumMapping;

    public EnumField(String name, int index, EnumMapping<E> enumMapping) {
        super(name, index);
        this.enumMapping = enumMapping;
    }

    public EnumMapping<E> getEnumMapping() {
        return this.enumMapping;
    }

    @Override
    public Enm<E> decode(ReadBuffer readBuffer) {
        readBuffer.getVlqInt();
        int intValue = readBuffer.getVlqInt();
        E e = this.enumMapping.toEnum(intValue);
        return new Enm<E>(this.name(), intValue, e);
    }

    @Override
    public void dump(ReadBuffer readBuffer, PrintStream out, int depth) {
        out.append(" type: ").append(this.getClass().getSimpleName());
        out.append(" name: ").append(this.name());
        out.append(" decoded: [");
        readBuffer.getVlqInt();
        int intValue = readBuffer.getVlqInt();
        Object decoded = this.enumMapping.toEnum(intValue);
        if (decoded == null) {
            decoded = intValue;
        }
        out.append(decoded.toString()).append("]");
    }
}

