/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.dynamic_config.api.service.IParameterSubstitutor;

class ConfigurationParser {
    private final List<Configuration> configurations;
    private final Version version;
    private final Consumer<Configuration> defaultAddedListener;

    private ConfigurationParser(List<Configuration> configurations, Version version, Consumer<Configuration> defaultAddedListener) {
        this.configurations = new ArrayList<Configuration>((Collection)Objects.requireNonNull(configurations));
        this.version = version;
        this.defaultAddedListener = Objects.requireNonNull(defaultAddedListener);
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("No configuration provided");
        }
    }

    public synchronized Cluster parse() {
        TreeMap ids = this.configurations.stream().filter(configuration -> configuration.getLevel() == Scope.NODE).collect(Collectors.groupingBy(Configuration::getStripeId, TreeMap::new, Collectors.mapping(Configuration::getNodeId, Collectors.toCollection(TreeSet::new))));
        if (ids.isEmpty()) {
            ids.put(1, new TreeSet());
        }
        if (((TreeSet)ids.firstEntry().getValue()).isEmpty()) {
            ((TreeSet)ids.firstEntry().getValue()).add(1);
        }
        if ((Integer)ids.firstKey() != 1) {
            throw new IllegalArgumentException("Stripe ID must start at 1");
        }
        if (((Integer)ids.lastKey()).intValue() != ids.size()) {
            throw new IllegalArgumentException("Stripe ID must end at " + ids.size());
        }
        ids.forEach((stripeId, nodesIds) -> {
            if ((Integer)nodesIds.first() != 1) {
                throw new IllegalArgumentException("Node ID must start at 1 in stripe " + stripeId);
            }
            if (((Integer)nodesIds.last()).intValue() != nodesIds.size()) {
                throw new IllegalArgumentException("Node ID must end at " + nodesIds.size() + " in stripe " + stripeId);
            }
        });
        this.validateConfigurations();
        Cluster cluster = new Cluster(new Stripe[0]);
        this.eagerlyApplySetting(cluster, cfg -> true, setting -> this.defaultAddedListener.accept(Configuration.valueOf((Object)setting + "=" + setting.getDefaultProperty().get())), setting -> {
            throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing");
        });
        ids.forEach((stripeId, nodeIds) -> {
            Stripe stripe = new Stripe();
            cluster.addStripe(stripe);
            if (cluster.getStripeCount() != stripeId.intValue()) {
                throw new AssertionError((Object)("Expected stripe count to be: " + stripeId + " but was: " + cluster.getStripeCount()));
            }
            this.eagerlyApplySetting(stripe, cfg -> cfg.getStripeId() == stripeId.intValue(), setting -> this.defaultAddedListener.accept(Configuration.valueOf("stripe." + stripeId + "." + (Object)setting + "=" + setting.getDefaultProperty().get())), setting -> {
                throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing for stripe ID: " + stripeId);
            });
            nodeIds.forEach(nodeId -> {
                Node node = new Node();
                stripe.addNode(node);
                if (stripe.getNodeCount() != nodeId.intValue()) {
                    throw new AssertionError((Object)("Expected node count to be: " + nodeId + " but was: " + stripe.getNodeCount()));
                }
                this.eagerlyApplySetting(node, cfg -> cfg.getStripeId() == stripeId.intValue() && cfg.getNodeId() == nodeId.intValue(), setting -> this.defaultAddedListener.accept(Configuration.valueOf("stripe." + stripeId + ".node." + nodeId + "." + (Object)setting + "=" + setting.getDefaultProperty().get())), setting -> {
                    throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing for node ID: " + nodeId + " in stripe ID: " + stripeId);
                });
            });
        });
        this.configurations.stream().filter(configuration -> this.version.amongst(configuration.getSetting().getVersions())).forEach(configuration -> {
            Setting setting = configuration.getSetting();
            if (setting.isMap()) {
                configuration.findTargets(cluster).forEach(o -> {
                    if (!setting.getProperty((PropertyHolder)o).isPresent()) {
                        setting.setProperty((PropertyHolder)o, "");
                    }
                });
            }
            configuration.apply(cluster);
        });
        return cluster;
    }

    private void validateConfigurations() {
        this.configurations.forEach(configuration -> {
            if (!configuration.getSetting().allows(Operation.IMPORT)) {
                throw new IllegalArgumentException("Invalid input: '" + configuration + "'. Reason: now allowed");
            }
            configuration.validate(ClusterState.CONFIGURING, Operation.IMPORT);
        });
    }

    private void eagerlyApplySetting(PropertyHolder o, Predicate<Configuration> filter, Consumer<Setting> onDefaultAdded, Consumer<Setting> onError) {
        Map<Setting, List<Configuration>> configs = this.configurations.stream().filter(cfg -> cfg.getSetting().isScope(o.getScope())).filter(cfg -> cfg.getLevel() == o.getScope()).filter(filter).collect(Collectors.groupingBy(Configuration::getSetting));
        Stream.of(Setting.values()).filter(setting -> this.version.amongst(setting.getVersions())).filter(setting -> setting.requires(Requirement.RESOLVE_EAGERLY)).filter(setting -> setting.isScope(o.getScope())).forEach(setting -> {
            List<Configuration> defined = configs.getOrDefault(setting, Collections.emptyList());
            if (!defined.isEmpty()) {
                defined.forEach(c -> c.apply(o));
                this.configurations.removeAll(defined);
            } else if (!setting.getProperty(o).isPresent()) {
                Optional<String> def = setting.getDefaultProperty();
                if (def.isPresent()) {
                    if (Substitutor.containsSubstitutionParams(def.get())) {
                        onError.accept((Setting)((Object)setting));
                    } else {
                        setting.setProperty(o, def.get());
                        onDefaultAdded.accept((Setting)((Object)setting));
                    }
                } else {
                    onError.accept((Setting)((Object)setting));
                }
            }
        });
    }

    static Cluster parsePropertyConfiguration(Properties properties, Version version, Consumer<Configuration> defaultAddedListener) {
        return new ConfigurationParser(ConfigurationParser.propertiesToConfigurations(properties), version, defaultAddedListener).parse();
    }

    static Cluster parseCommandLineParameters(Map<Setting, String> userConsoleParameters, IParameterSubstitutor substitutor, Consumer<Configuration> defaultAddedListener) {
        Properties properties = ConfigurationParser.cliToProperties(userConsoleParameters, substitutor, defaultAddedListener);
        return ConfigurationParser.parsePropertyConfiguration(properties, Version.CURRENT, defaultAddedListener);
    }

    private static List<Configuration> propertiesToConfigurations(Properties properties) {
        Objects.requireNonNull(properties);
        return properties.entrySet().stream().map(p -> Configuration.valueOf(p.getKey() + "=" + p.getValue())).collect(Collectors.toList());
    }

    private static Properties cliToProperties(Map<Setting, String> cliParameters, IParameterSubstitutor parameterSubstitutor, Consumer<Configuration> defaultAddedListener) {
        Objects.requireNonNull(cliParameters);
        Properties properties = new Properties();
        cliParameters.forEach((k, v) -> properties.setProperty(ConfigurationParser.prefixed(k), (String)v));
        Stream.of(Setting.values()).filter(setting -> setting.requires(Requirement.RESOLVE_EAGERLY)).forEach(s -> ConfigurationParser.eagerlyResolve(parameterSubstitutor, defaultAddedListener, properties, s));
        return properties;
    }

    private static void eagerlyResolve(IParameterSubstitutor parameterSubstitutor, Consumer<Configuration> defaultAddedListener, Properties properties, Setting setting) {
        String key = ConfigurationParser.prefixed(setting);
        String set = properties.getProperty(key);
        if (set == null) {
            set = parameterSubstitutor.substitute(setting.getDefaultProperty().orElse(""));
            defaultAddedListener.accept(Configuration.valueOf(key + "=" + set));
        } else {
            set = parameterSubstitutor.substitute(set);
        }
        if (set == null) {
            throw new AssertionError((Object)(key + " is null: bad mocking ? Default value was: " + setting.getDefaultProperty().orElse("")));
        }
        properties.setProperty(key, set);
    }

    private static String prefixed(Setting setting) {
        return setting.isScope(Scope.CLUSTER) ? setting.toString() : (setting.isScope(Scope.STRIPE) ? "stripe.1." + (Object)((Object)setting) : "stripe.1.node.1." + (Object)((Object)setting));
    }
}

