/*
 * Decompiled with CFR 0.152.
 */
package com.tc.properties;

import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesConsts;
import com.tc.properties.TCSubProperties;
import com.tc.util.io.IOUtils;
import com.tc.util.properties.TCPropertyStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPropertiesImpl
implements TCProperties {
    private static final Logger logger = LoggerFactory.getLogger(TCPropertiesImpl.class);
    private static final Set<String> TC_PROPERTIES_WITH_NO_DEFAULTS = new HashSet<String>(Arrays.asList(TCPropertiesConsts.TC_PROPERTIES_WITH_NO_DEFAULTS));
    public static final String SYSTEM_PROP_PREFIX = "com.tc.";
    private static final String DEFAULT_TC_PROPERTIES_FILE = "tc.properties";
    private static final String TC_PROPERTIES_FILE = "tc.properties";
    private static final String TC_PROPERTIES_SYSTEM_PROP = "com.tc.properties";
    private static final TCPropertiesImpl INSTANCE = new TCPropertiesImpl();
    private final TCPropertyStore props = new TCPropertyStore();
    private final TCPropertyStore localTcProperties = new TCPropertyStore();
    private volatile boolean initialized = false;

    private TCPropertiesImpl() {
        String tcPropFile;
        this.loadDefaults("tc.properties");
        String tcJarDir = this.getTCJarRootDirectory();
        if (tcJarDir != null) {
            this.loadOverrides(tcJarDir, "tc.properties");
        }
        if ((tcPropFile = System.getProperty(TC_PROPERTIES_SYSTEM_PROP)) != null) {
            this.loadOverrides(tcPropFile);
        }
        this.processSystemProperties();
        this.warnForOldProperties();
    }

    public static String tcSysProp(String prop) {
        return SYSTEM_PROP_PREFIX + prop;
    }

    private void warnForOldProperties() {
        String[] oldProperties = TCPropertiesConsts.OLD_PROPERTIES;
        int len = oldProperties.length;
        for (int i = 0; i < len; ++i) {
            if (!this.props.containsKey(oldProperties[i])) continue;
            logger.warn("The property \"" + oldProperties[i] + "\" has been removed/renamed in the latest release. Please update the tc.properties file or some of your settings might not work");
        }
    }

    private void processSystemProperties() {
        for (String key : System.getProperties().stringPropertyNames()) {
            String value;
            if (!key.startsWith(SYSTEM_PROP_PREFIX) || (value = System.getProperty(key)) == null) continue;
            this.localTcProperties.setProperty(key.substring(SYSTEM_PROP_PREFIX.length()), value);
            this.props.setProperty(key.substring(SYSTEM_PROP_PREFIX.length()), value);
        }
    }

    @Override
    public Properties addAllPropertiesTo(Properties properties) {
        return this.addAllPropertiesTo(properties, null);
    }

    @Override
    public synchronized void overwriteTcPropertiesFromConfig(Map<String, String> overwriteProps) {
        this.applyConfigOverrides(overwriteProps);
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        logger.debug("Loaded TCProperties : " + this.toString());
    }

    private void applyConfigOverrides(Map<String, String> overwriteProps) {
        if (overwriteProps.isEmpty()) {
            logger.debug("tc-config doesn't have any tc-property. No tc-property will be overridden");
            return;
        }
        for (Map.Entry<String, String> prop : overwriteProps.entrySet()) {
            String propertyName = prop.getKey();
            String propertyValue = prop.getValue();
            if (!this.props.containsKey(propertyName) && !TC_PROPERTIES_WITH_NO_DEFAULTS.contains(propertyName)) {
                logger.warn("The property \"" + propertyName + "\" is not present in set of defined tc properties. Probably this is misspelled");
            }
            if (!this.localTcProperties.containsKey(propertyName)) {
                if (TC_PROPERTIES_WITH_NO_DEFAULTS.contains(propertyName)) {
                    logger.info("The property \"" + propertyName + "\" was set to " + propertyValue + " by the tc-config file");
                } else {
                    logger.info("The property \"" + propertyName + "\" was overridden to " + propertyValue + " from " + this.props.getProperty(propertyName) + " by the tc-config file");
                }
                this.setProperty(propertyName, propertyValue);
                continue;
            }
            logger.warn("The property \"" + propertyName + "\" was set by local settings to " + this.props.getProperty(propertyName) + ". This will not be overridden to " + propertyValue + " from the tc-config file");
        }
    }

    Properties addAllPropertiesTo(Properties properties, String filter) {
        for (String key : this.props.keysArray()) {
            if (filter == null) {
                properties.put(key, this.props.getProperty(key));
                continue;
            }
            if (!key.startsWith(filter)) continue;
            properties.put(key.substring(filter.length()), this.props.getProperty(key));
        }
        return properties;
    }

    private void loadOverrides(String propDir, String propFile) {
        File file = new File(propDir, propFile);
        this.loadOverrides(file);
    }

    private void loadOverrides(String propFile) {
        File file = new File(propFile);
        this.loadOverrides(file);
    }

    private void loadOverrides(File file) {
        if (file.canRead()) {
            try {
                FileInputStream fin = new FileInputStream(file);
                logger.info("Loading override properties from : " + file);
                this.localTcProperties.load(fin);
                fin.close();
                this.props.putAll(this.localTcProperties);
            }
            catch (FileNotFoundException e) {
                logger.info("Couldnt find " + file + ". Ignoring it", (Throwable)e);
            }
            catch (IOException e) {
                logger.info("Couldnt read " + file + ". Ignoring it", (Throwable)e);
            }
        }
    }

    private String getTCJarRootDirectory() {
        URL url = TCPropertiesImpl.class.getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (!path.toLowerCase().endsWith(".jar")) {
            return null;
        }
        File jarFile = new File(path);
        String dir = jarFile.getParent();
        return dir;
    }

    private void loadDefaults(String propFile) {
        URL url = TCPropertiesImpl.class.getResource(propFile);
        if (url == null) {
            throw new AssertionError((Object)("TC Property file " + propFile + " not Found"));
        }
        InputStream in = null;
        try {
            in = url.openStream();
            logger.debug("Loading default properties from " + propFile);
            this.props.load(in);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static TCProperties getProperties() {
        return INSTANCE;
    }

    @Override
    public TCProperties getPropertiesFor(String category) {
        if (category == null) {
            throw new AssertionError((Object)"Category cant be null");
        }
        return new TCSubProperties(INSTANCE, category);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, false);
    }

    @Override
    public String getProperty(String key, boolean missingOkay) {
        String val = this.props.getProperty(key);
        if (val == null && !missingOkay) {
            throw new AssertionError((Object)("TCProperties : Property not found for " + key));
        }
        if (!this.initialized) {
            logger.info("The property \"" + key + "\" was read before initialization completed. \"" + key + "\" = " + val);
        }
        return val;
    }

    @Override
    public void setProperty(String key, String value) {
        TCPropertiesImpl.INSTANCE.props.setProperty(key, value);
    }

    public String toString() {
        return "TCProperties = { " + this.sortedPropertiesToString() + " }";
    }

    private String sortedPropertiesToString() {
        Object[] properties = this.props.keysArray();
        Arrays.sort(properties);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < properties.length; ++i) {
            sb.append((String)properties[i]).append(" = ").append(this.props.getProperty((String)properties[i]));
            if (i == properties.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public boolean getBoolean(String key) {
        String val = this.getProperty(key);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String val = this.getProperty(key, true);
        if (val == null) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public int getInt(String key) {
        String val = this.getProperty(key);
        return Integer.valueOf(val);
    }

    @Override
    public int getInt(String key, int defValue) {
        String val = this.getProperty(key, true);
        if (val == null) {
            return defValue;
        }
        return Integer.parseInt(val);
    }

    @Override
    public long getLong(String key) {
        String val = this.getProperty(key);
        return Long.valueOf(val);
    }

    @Override
    public long getLong(String key, long defValue) {
        String val = this.getProperty(key, true);
        if (val == null) {
            return defValue;
        }
        return Long.parseLong(val);
    }

    @Override
    public float getFloat(String key) {
        String val = this.getProperty(key);
        return Float.valueOf(val).floatValue();
    }
}

