/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.common.struct.LockContext;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.OptionalConfig;
import org.terracotta.dynamic_config.api.model.Permission;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.SettingValidator;
import org.terracotta.dynamic_config.api.model.Uuid;

public enum Setting {
    NODE_NAME("name", false, () -> "node-" + Uuid.generateShortUuid(), Scope.NODE, Setting.fromNode(Node::getName), Setting.intoNode(Node::setName), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET, Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.NODE_NAME_VALIDATOR.accept("name", Tuple2.tuple2(key, value))),
    NODE_HOSTNAME("hostname", false, Setting.always("%h"), Scope.NODE, Setting.fromNode(Node::getHostname), Setting.intoNode(Node::setHostname), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.RESOLVE_EAGERLY, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.HOST_VALIDATOR.accept("hostname", Tuple2.tuple2(key, value))),
    NODE_PORT("port", false, Setting.always(9410), Scope.NODE, Setting.fromNode(Node::getPort), Setting.intoNode((node, value) -> node.setPort(Integer.parseInt(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("port", Tuple2.tuple2(key, value))),
    NODE_PUBLIC_HOSTNAME("public-hostname", false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getPublicHostname), Setting.intoNode(Node::setPublicHostname), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.HOST_VALIDATOR.accept("public-hostname", Tuple2.tuple2(key, value))),
    NODE_PUBLIC_PORT("public-port", false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getPublicPort), Setting.intoNode((node, value) -> node.setPublicPort(value == null ? null : Integer.valueOf(Integer.parseInt(value)))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("public-port", Tuple2.tuple2(key, value))),
    NODE_GROUP_PORT("group-port", false, Setting.always(9430), Scope.NODE, Setting.fromNode(Node::getGroupPort), Setting.intoNode((node, value) -> node.setGroupPort(Integer.parseInt(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("group-port", Tuple2.tuple2(key, value))),
    NODE_BIND_ADDRESS("bind-address", false, Setting.always("0.0.0.0"), Scope.NODE, Setting.fromNode(Node::getBindAddress), Setting.intoNode(Node::setBindAddress), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.ADDRESS_VALIDATOR.accept("bind-address", Tuple2.tuple2(key, value))),
    NODE_GROUP_BIND_ADDRESS("group-bind-address", false, Setting.always("0.0.0.0"), Scope.NODE, Setting.fromNode(Node::getGroupBindAddress), Setting.intoNode(Node::setGroupBindAddress), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.SET).atAnyLevels(), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE)), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.ADDRESS_VALIDATOR.accept("group-bind-address", Tuple2.tuple2(key, value))),
    CLUSTER_NAME("cluster-name", false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getName), Setting.intoCluster(Cluster::setName), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allowAnyOperations().atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ALL_NODES_ONLINE)),
    LOCK_CONTEXT("lock-context", false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getConfigurationLockContext), Setting.intoCluster((cluster, context) -> cluster.setConfigurationLockContext(context != null ? LockContext.from(context) : null)), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.HIDDEN)),
    NODE_CONFIG_DIR("config-dir", false, Setting.always(Paths.get("%H", "terracotta", "config")), Scope.NODE, o -> Optional.empty(), Setting.noop(), Collections.emptyList(), EnumSet.of(Requirement.PRESENCE, Requirement.CONFIG), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("config-dir", Tuple2.tuple2(key, value))),
    NODE_METADATA_DIR("metadata-dir", false, Setting.always(Paths.get("%H", "terracotta", "metadata")), Scope.NODE, Setting.fromNode(Node::getMetadataDir), Setting.intoNode((node, value) -> node.setMetadataDir(Paths.get(value, new String[0]))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET).atAnyLevels(), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET).atAnyLevels()), EnumSet.of(Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("metadata-dir", Tuple2.tuple2(key, value))),
    NODE_LOG_DIR("log-dir", false, Setting.always(Paths.get("%H", "terracotta", "logs")), Scope.NODE, Setting.fromNode(Node::getLogDir), Setting.intoNode((node, value) -> node.setLogDir(Paths.get(value, new String[0]))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET).atAnyLevels(), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.NODE_RESTART, Requirement.PRESENCE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("log-dir", Tuple2.tuple2(key, value))),
    NODE_BACKUP_DIR("backup-dir", false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getBackupDir), Setting.intoNode((node, value) -> node.setBackupDir(value == null ? null : Paths.get(value, new String[0]))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("backup-dir", Tuple2.tuple2(key, value))),
    TC_PROPERTIES("tc-properties", true, Setting.always(Collections.emptyMap()), Scope.NODE, Setting.fromNode(Node::getTcProperties), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                node.unsetTcProperties();
            } else {
                node.setTcProperties(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            node.removeTcProperty((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.setTcProperties(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> node.putTcProperty(kv[0], kv[1]));
        } else {
            node.putTcProperty((String)tuple.t1, (String)tuple.t2);
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.CLUSTER_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PROPS_VALIDATOR.accept("tc-properties", Tuple2.tuple2(key, value))),
    NODE_LOGGER_OVERRIDES("logger-overrides", true, Setting.always(Collections.emptyMap()), Scope.NODE, Setting.fromNode(Node::getLoggerOverrides), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                node.unsetLoggerOverrides();
            } else {
                node.setLoggerOverrides(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            node.removeLoggerOverride((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.setLoggerOverrides(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> node.putLoggerOverride(kv[0], kv[1].toUpperCase(Locale.ROOT)));
        } else {
            node.putLoggerOverride((String)tuple.t1, ((String)tuple.t2).toUpperCase(Locale.ROOT));
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.LOGGER_LEVEL_VALIDATOR.accept("logger-overrides", Tuple2.tuple2(key, value))),
    CLIENT_RECONNECT_WINDOW("client-reconnect-window", false, Setting.always(Measure.of(120L, TimeUnit.SECONDS)), Scope.CLUSTER, Setting.fromCluster(Cluster::getClientReconnectWindow), Setting.intoCluster((cluster, value) -> cluster.setClientReconnectWindow(Measure.parse(value, TimeUnit.class))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.PRESENCE), Collections.emptyList(), Arrays.asList(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS), (key, value) -> SettingValidator.TIME_VALIDATOR.accept("client-reconnect-window", Tuple2.tuple2(key, value))),
    FAILOVER_PRIORITY("failover-priority", false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getFailoverPriority), Setting.intoCluster((cluster, value) -> cluster.setFailoverPriority(FailoverPriority.valueOf(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.CLUSTER_RESTART, Requirement.PRESENCE, Requirement.CONFIG, Requirement.RESOLVE_EAGERLY), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.DEFAULT_VALIDATOR.andThen((k, v) -> FailoverPriority.valueOf((String)v.t2)).accept("failover-priority", Tuple2.tuple2(key, value))),
    CLIENT_LEASE_DURATION("client-lease-duration", false, Setting.always(Measure.of(150L, TimeUnit.SECONDS)), Scope.CLUSTER, Setting.fromCluster(Cluster::getClientLeaseDuration), Setting.intoCluster((cluster, value) -> cluster.setClientLeaseDuration(Measure.parse(value, TimeUnit.class))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.PRESENCE), Collections.emptyList(), Arrays.asList(TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS), (key, value) -> SettingValidator.TIME_VALIDATOR.accept("client-lease-duration", Tuple2.tuple2(key, value))),
    LICENSE_FILE("license-file", false, Setting.always(null), Scope.CLUSTER, o -> Optional.empty(), Setting.noop(), Collections.singletonList(Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("license-file", Tuple2.tuple2(key, value))),
    SECURITY_DIR("security-dir", false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getSecurityDir), Setting.intoNode((node, value) -> node.setSecurityDir(value == null ? null : Paths.get(value, new String[0]))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.CLUSTER_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("security-dir", Tuple2.tuple2(key, value))),
    SECURITY_AUDIT_LOG_DIR("audit-log-dir", false, Setting.always(null), Scope.NODE, Setting.fromNode(Node::getSecurityAuditLogDir), Setting.intoNode((node, value) -> node.setSecurityAuditLogDir(value == null ? null : Paths.get(value, new String[0]))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels()), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.CLUSTER_RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("audit-log-dir", Tuple2.tuple2(key, value))),
    SECURITY_AUTHC("authc", false, Setting.always(null), Scope.CLUSTER, Setting.fromCluster(Cluster::getSecurityAuthc), Setting.intoCluster(Cluster::setSecurityAuthc), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET, Operation.UNSET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.CLUSTER_RESTART), Arrays.asList("file", "ldap", "certificate")),
    SECURITY_SSL_TLS("ssl-tls", false, Setting.always(false), Scope.CLUSTER, Setting.fromCluster(Cluster::getSecuritySslTls), Setting.intoCluster((cluster, value) -> cluster.setSecuritySslTls(Boolean.parseBoolean(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.CLUSTER_RESTART, Requirement.PRESENCE), Arrays.asList("true", "false")),
    SECURITY_WHITELIST("whitelist", false, Setting.always(false), Scope.CLUSTER, Setting.fromCluster(Cluster::getSecurityWhitelist), Setting.intoCluster((cluster, value) -> cluster.setSecurityWhitelist(Boolean.parseBoolean(value))), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.CONFIGURING, ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.CLUSTER_RESTART, Requirement.PRESENCE), Arrays.asList("true", "false")),
    OFFHEAP_RESOURCES("offheap-resources", true, Setting.always(Collections.singletonMap("main", Measure.of(512L, MemoryUnit.MB))), Scope.CLUSTER, Setting.fromCluster(Cluster::getOffheapResources), Setting.intoClusterMap((cluster, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                cluster.unsetOffheapResources();
            } else {
                cluster.setOffheapResources(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            cluster.removeOffheapResource((String)tuple.t1);
        } else if (tuple.t1 == null) {
            cluster.setOffheapResources(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> cluster.putOffheapResource(kv[0], Measure.parse(kv[1], MemoryUnit.class)));
        } else {
            cluster.putOffheapResource((String)tuple.t1, Measure.parse((String)tuple.t2, MemoryUnit.class));
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allowAnyOperations().atLevel(Scope.CLUSTER), Permission.Builder.when(ClusterState.ACTIVATED).allow(Operation.GET, Operation.SET).atLevel(Scope.CLUSTER)), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Arrays.asList(MemoryUnit.values()), (key, value) -> SettingValidator.OFFHEAP_VALIDATOR.accept("offheap-resources", Tuple2.tuple2(key, value))),
    DATA_DIRS("data-dirs", true, Setting.always(Collections.singletonMap("main", Paths.get("%H", "terracotta", "user-data", "main"))), Scope.NODE, Setting.fromNode(Node::getDataDirs), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.t1 == null && Setting.empty((String)tuple.t2)) {
            if (tuple.t2 == null) {
                node.unsetDataDirs();
            } else {
                node.setDataDirs(Collections.emptyMap());
            }
        } else if (tuple.t1 != null && Setting.empty((String)tuple.t2)) {
            node.removeDataDir((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.setDataDirs(Collections.emptyMap());
            Stream.of(((String)tuple.t2).split(",")).forEach(kv -> {
                int firstColon = kv.indexOf(":");
                node.putDataDir(kv.substring(0, firstColon), Paths.get(kv.substring(firstColon + 1), new String[0]));
            });
        } else {
            node.putDataDir((String)tuple.t1, Paths.get((String)tuple.t2, new String[0]));
        }
    }), Arrays.asList(Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.IMPORT).atLevel(Scope.NODE), Permission.Builder.when(ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET, Operation.UNSET).atAnyLevels(), Permission.Builder.when(ClusterState.ACTIVATED, ClusterState.CONFIGURING).allow(Operation.GET, Operation.SET).atAnyLevels()), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.DATA_DIRS_VALIDATOR.accept("data-dirs", Tuple2.tuple2(key, value)));

    private final String name;
    private final boolean map;
    private final Supplier<Object> defaultValue;
    private final Scope scope;
    private final Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor;
    private final Collection<Permission> permissions;
    private final Collection<Requirement> requirements;
    private final Collection<String> allowedValues;
    private final Collection<? extends Enum<?>> allowedUnits;
    private final BiConsumer<String, String> validator;
    private final BiConsumer<PropertyHolder, Tuple2<String, String>> setter;

    private Setting(String name, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements) {
        this(name, map, defaultValue, scope, extractor, setter, permissions, requirements, Collections.emptyList(), Collections.emptyList());
    }

    private Setting(String name, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements, Collection<String> allowedValues) {
        this(name, map, defaultValue, scope, extractor, setter, permissions, requirements, allowedValues, Collections.emptyList());
    }

    private Setting(String name, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements, Collection<String> allowedValues, Collection<? extends Enum<?>> allowedUnits) {
        this(name, map, defaultValue, scope, extractor, setter, permissions, requirements, allowedValues, allowedUnits, (key, value) -> SettingValidator.DEFAULT_VALIDATOR.accept(name, Tuple2.tuple2(key, value)));
    }

    private Setting(String name, boolean map, Supplier<Object> defaultValue, Scope scope, Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, Collection<Permission> permissions, EnumSet<Requirement> requirements, Collection<String> allowedValues, Collection<? extends Enum<?>> allowedUnits, BiConsumer<String, String> validator) {
        this.name = Objects.requireNonNull(name);
        this.map = map;
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.scope = Objects.requireNonNull(scope);
        this.extractor = Objects.requireNonNull(extractor);
        this.setter = Objects.requireNonNull(setter);
        this.permissions = new LinkedHashSet<Permission>(Objects.requireNonNull(permissions));
        this.requirements = Objects.requireNonNull(requirements);
        this.allowedValues = Collections.unmodifiableSet(new LinkedHashSet<String>(Objects.requireNonNull(allowedValues)));
        this.allowedUnits = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(allowedUnits)));
        this.validator = Objects.requireNonNull(validator);
        if (scope == Scope.CLUSTER && permissions.stream().anyMatch(permission -> permission.allows(Scope.NODE) || permission.allows(Scope.STRIPE))) {
            throw new AssertionError((Object)("Scope error for setting " + name + ": " + permissions));
        }
        if (scope == Scope.STRIPE && permissions.stream().anyMatch(permission -> permission.allows(Scope.NODE))) {
            throw new AssertionError((Object)("Scope error for setting " + name + ": " + permissions));
        }
    }

    public String toString() {
        return this.name;
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isMap() {
        return this.map;
    }

    public <T> T getDefaultValue() {
        return (T)this.defaultValue.get();
    }

    public Optional<String> getDefaultProperty() {
        return Setting.toProperty(this.defaultValue.get());
    }

    public Collection<String> getAllowedValues() {
        return this.allowedValues;
    }

    public <U extends Enum<U>> Collection<U> getAllowedUnits() {
        return this.allowedUnits;
    }

    public boolean requires(Requirement requirement) {
        return this.requirements.contains((Object)requirement);
    }

    public boolean allows(Scope scope) {
        return this.permissions.stream().anyMatch(permission -> permission.allows(scope));
    }

    public boolean allows(Operation operation) {
        return this.permissions.stream().anyMatch(permission -> permission.allows(operation));
    }

    public boolean allows(ClusterState clusterState) {
        return this.permissions.stream().anyMatch(permission -> permission.allows(clusterState));
    }

    public boolean allows(Operation operation, Scope scope) {
        return this.permissions.stream().anyMatch(permissions -> permissions.allows(operation) && permissions.allows(scope));
    }

    public boolean allows(ClusterState clusterState, Operation operation) {
        return this.permissions.stream().anyMatch(permissions -> permissions.allows(operation) && permissions.allows(clusterState));
    }

    public boolean allows(ClusterState clusterState, Operation operation, Scope scope) {
        return this.permissions.stream().anyMatch(permissions -> permissions.allows(clusterState) && permissions.allows(operation) && permissions.allows(scope));
    }

    private boolean isUserExportable() {
        return !this.requires(Requirement.HIDDEN) && this.permissions.stream().anyMatch(Permission::isUserExportable);
    }

    public boolean mustBePresent() {
        return this.requires(Requirement.PRESENCE);
    }

    public boolean mustBeProvided() {
        return this.requires(Requirement.CONFIG);
    }

    public boolean canBeCleared(Scope scope) {
        return this.allows(ClusterState.ACTIVATED, Operation.UNSET, scope) || this.allows(ClusterState.CONFIGURING, Operation.UNSET, scope) || this.getDefaultValue() != null;
    }

    public boolean isWritable() {
        return this.isWritableWhen(ClusterState.CONFIGURING) || this.isWritableWhen(ClusterState.ACTIVATED);
    }

    public boolean isWritableWhen(ClusterState clusterState) {
        return this.permissions.stream().anyMatch(permission -> permission.isWritableWhen(clusterState));
    }

    public boolean isScope(Scope scope) {
        return this.scope == scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void validate(String key, String value) {
        if (key == null && value == null && !this.mustBePresent()) {
            return;
        }
        this.validator.accept(key, value);
    }

    public void validate(String value) {
        this.validate(null, value);
    }

    public Optional<String> getProperty(PropertyHolder o) {
        return this.extractor.apply(o).map(Setting::reduceToPropertyString);
    }

    public void setProperty(PropertyHolder o, String value) {
        this.setProperty(o, null, value);
    }

    public void setProperty(NodeContext nodeContext, String key, String value) {
        this.setProperty((PropertyHolder)((Object)(this.scope == Scope.CLUSTER ? nodeContext.getCluster() : nodeContext.getNode())), key, value);
    }

    public void setProperty(PropertyHolder node, String key, String value) {
        if (!this.isWritable()) {
            throw new IllegalArgumentException("Setting: " + (Object)((Object)this) + " is not writable");
        }
        if (!this.isMap() && Setting.empty(value)) {
            value = null;
        }
        this.validate(key, value);
        this.setter.accept(node, Tuple2.tuple2(key, value));
    }

    public Properties toProperties(PropertyHolder o, boolean expanded, boolean includeDefaultValues) {
        Properties properties = new Properties();
        Optional<String> currentValue = this.getProperty(o);
        Optional<String> defaultValue = this.getDefaultProperty();
        Runnable normalWrite = () -> {
            if (currentValue.isPresent()) {
                properties.setProperty(this.name, (String)currentValue.get());
            } else if (defaultValue.isPresent() && !((String)defaultValue.get()).isEmpty()) {
                properties.setProperty(this.name, (String)defaultValue.get());
            }
        };
        if (currentValue.isPresent() || defaultValue.isPresent() && includeDefaultValues) {
            if (expanded && this.isMap()) {
                List<Tuple2> pairs = this.extractor.apply(o).orElseGet(() -> Setting.stream(this.getDefaultValue()).get()).collect(Collectors.toList());
                if (pairs.isEmpty()) {
                    normalWrite.run();
                } else {
                    pairs.forEach(tuple -> properties.setProperty(this.name + "." + (String)tuple.t1, (String)tuple.t2));
                }
            } else {
                normalWrite.run();
            }
        }
        return properties;
    }

    public boolean allowsValue(String value) {
        return this.allowedValues.isEmpty() || this.allowedValues.contains(value);
    }

    public static Setting fromName(String name) {
        return Setting.findSetting(name).orElseThrow(() -> new IllegalArgumentException("Illegal setting name: " + name));
    }

    public static Optional<Setting> findSetting(String name) {
        return Stream.of(Setting.values()).filter(setting -> setting.name.equals(name)).findAny();
    }

    public static Properties modelToProperties(PropertyHolder o, boolean expanded, boolean includeDefaultValues, boolean includeHiddenSettings) {
        Properties properties = new Properties();
        Stream.of(Setting.values()).filter(setting -> setting.isUserExportable() || includeHiddenSettings && setting.requires(Requirement.HIDDEN)).filter(setting -> setting.isScope(o.getScope())).forEach(setting -> properties.putAll((Map<?, ?>)setting.toProperties(o, expanded, includeDefaultValues)));
        return properties;
    }

    private static Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> fromNode(Function<Node, Object> extractor) {
        return node -> {
            Object o = extractor.apply((Node)node);
            if (o instanceof OptionalConfig) {
                o = ((OptionalConfig)o).orElse(null);
            }
            if (o == null) {
                return Optional.empty();
            }
            if (o instanceof Map) {
                return Optional.of(((Map)o).entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(e -> Tuple2.tuple2(e.getKey(), e.getValue().toString())));
            }
            return Optional.of(Stream.of(Tuple2.tuple2(null, String.valueOf(o))));
        };
    }

    private static Function<PropertyHolder, Optional<Stream<Tuple2<String, String>>>> fromCluster(Function<Cluster, Object> extractor) {
        return cluster -> Setting.stream(extractor.apply((Cluster)cluster));
    }

    private static Optional<Stream<Tuple2<String, String>>> stream(Object o) {
        if (o instanceof OptionalConfig) {
            o = ((OptionalConfig)o).orElse(null);
        }
        if (o == null) {
            return Optional.empty();
        }
        if (o instanceof Map) {
            return Optional.of(((Map)o).entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(e -> Tuple2.tuple2(e.getKey(), e.getValue().toString())));
        }
        return Optional.of(Stream.of(Tuple2.tuple2(null, String.valueOf(o))));
    }

    public static Optional<String> toProperty(Object o) {
        return o == null ? Optional.empty() : Setting.stream(o).map(Setting::reduceToPropertyString);
    }

    private static String reduceToPropertyString(Stream<Tuple2<String, String>> s) {
        return s.filter(tuple -> !tuple.allNulls()).map(tuple -> tuple.t1 == null ? (String)tuple.t2 : (String)tuple.t1 + ":" + (String)tuple.t2).reduce((result, element) -> result + "," + element).orElse("");
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoNode(BiConsumer<Node, String> setter) {
        return (node, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Node)node, Setting.empty((String)tuple.t2) ? null : ((String)tuple.t2).trim());
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoCluster(BiConsumer<Cluster, String> setter) {
        return (cluster, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Cluster)cluster, Setting.empty((String)tuple.t2) ? null : ((String)tuple.t2).trim());
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoNodeMap(BiConsumer<Node, Tuple2<String, String>> setter) {
        return (node, tuple) -> setter.accept((Node)node, Tuple2.tuple2(tuple.t1, tuple.t2));
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoClusterMap(BiConsumer<Cluster, Tuple2<String, String>> setter) {
        return (cluster, tuple) -> setter.accept((Cluster)cluster, Tuple2.tuple2(tuple.t1, tuple.t2));
    }

    private static <U, V> BiConsumer<U, V> noop() {
        return (u, v) -> {};
    }

    private static <V> Supplier<V> always(V value) {
        return () -> value;
    }

    private static boolean empty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

