/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;

public class NodeContext
implements Cloneable {
    private final Cluster cluster;
    private final int stripeId;
    private final int nodeId;
    private final String nodeName;
    private final Node node;

    public NodeContext(Cluster cluster, int stripeId, String nodeName) {
        this.cluster = Objects.requireNonNull(cluster);
        this.stripeId = stripeId;
        this.nodeName = Objects.requireNonNull(nodeName);
        if (stripeId < 1 || stripeId > cluster.getStripeCount()) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId);
        }
        this.node = cluster.getNode(stripeId, nodeName).orElseThrow(() -> new IllegalArgumentException("Node " + nodeName + " in stripe ID " + stripeId + " not found"));
        this.nodeId = cluster.getNodeId(stripeId, nodeName).orElseThrow(() -> new IllegalArgumentException("Node " + nodeName + " in stripe ID " + stripeId + " not found"));
    }

    public NodeContext(Cluster cluster, InetSocketAddress nodeAddress) {
        Objects.requireNonNull(nodeAddress);
        this.cluster = Objects.requireNonNull(cluster);
        this.node = cluster.getNode(nodeAddress).orElseThrow(() -> new IllegalArgumentException("Node " + nodeAddress + " not found"));
        this.nodeName = Objects.requireNonNull(this.node.getName());
        this.stripeId = cluster.getStripeId(nodeAddress).getAsInt();
        this.nodeId = cluster.getNodeId(nodeAddress).getAsInt();
    }

    public NodeContext(Cluster cluster, int stripeId, int nodeId) {
        this.cluster = Objects.requireNonNull(cluster);
        this.stripeId = stripeId;
        this.nodeId = nodeId;
        this.node = cluster.getNode(stripeId, nodeId).orElseThrow(() -> new IllegalArgumentException("Node ID " + nodeId + " in stripe ID " + stripeId + " not found"));
        this.nodeName = Objects.requireNonNull(this.node.getName());
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public int getStripeId() {
        return this.stripeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Node getNode() {
        return this.node;
    }

    public Stripe getStripe() {
        return this.cluster.getStripe(this.stripeId).get();
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public NodeContext clone() {
        return new NodeContext(this.cluster.clone(), this.stripeId, this.nodeName);
    }

    public String toString() {
        return "NodeContext{cluster=" + this.cluster.toShapeString() + ", stripeId=" + this.stripeId + ", nodeId=" + this.nodeId + ", nodeName='" + this.nodeName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeContext)) {
            return false;
        }
        NodeContext that = (NodeContext)o;
        return this.getStripeId() == that.getStripeId() && this.getNodeId() == that.getNodeId() && this.getCluster().equals(that.getCluster()) && this.getNodeName().equals(that.getNodeName());
    }

    public int hashCode() {
        return Objects.hash(this.getCluster(), this.getStripeId(), this.getNodeId(), this.getNodeName());
    }

    public Optional<NodeContext> withCluster(Cluster updated) {
        Objects.requireNonNull(updated);
        return updated.containsNode(this.stripeId, this.nodeName) ? Optional.of(new NodeContext(updated, this.stripeId, this.nodeName)) : Optional.empty();
    }

    public NodeContext alone() {
        return this.withOnlyNode(this.getNode());
    }

    public NodeContext withOnlyNode(Node node) {
        Cluster cluster = this.getCluster().clone().removeStripes();
        cluster.addStripe(new Stripe(node).clone());
        return new NodeContext(cluster, node.getAddress());
    }
}

