/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.inet.InetSocketAddressUtils;

public class Node
implements Cloneable,
PropertyHolder {
    private String name;
    private String hostname;
    private String publicHostname;
    private Integer port;
    private Integer publicPort;
    private Integer groupPort;
    private String bindAddress;
    private String groupBindAddress;
    private Path metadataDir;
    private Path logDir;
    private Path backupDir;
    private Path securityDir;
    private Path securityAuditLogDir;
    private final Map<String, String> tcProperties = new ConcurrentHashMap<String, String>();
    private final Map<String, String> loggerOverrides = new ConcurrentHashMap<String, String>();
    private final Map<String, Path> dataDirs = new ConcurrentHashMap<String, Path>();

    @Override
    public Scope getScope() {
        return Scope.NODE;
    }

    public String getName() {
        return this.name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPublicHostname() {
        return this.publicHostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getPublicPort() {
        return this.publicPort;
    }

    public Integer getGroupPort() {
        return this.groupPort;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getGroupBindAddress() {
        return this.groupBindAddress;
    }

    public Path getMetadataDir() {
        return this.metadataDir;
    }

    public Path getLogDir() {
        return this.logDir;
    }

    public Path getBackupDir() {
        return this.backupDir;
    }

    public Path getSecurityDir() {
        return this.securityDir;
    }

    public Path getSecurityAuditLogDir() {
        return this.securityAuditLogDir;
    }

    public Map<String, Path> getDataDirs() {
        return Collections.unmodifiableMap(this.dataDirs);
    }

    public Map<String, String> getLoggerOverrides() {
        return Collections.unmodifiableMap(this.loggerOverrides);
    }

    public Node setLoggerOverrides(Map<String, String> loggerOverrides) {
        this.loggerOverrides.putAll(loggerOverrides);
        return this;
    }

    public Node setLoggerOverride(String logger, String level) {
        this.loggerOverrides.put(logger, level);
        return this;
    }

    public Node removeLoggerOverride(String logger) {
        this.loggerOverrides.remove(logger);
        return this;
    }

    public Node clearLoggerOverrides() {
        this.loggerOverrides.clear();
        return this;
    }

    public Map<String, String> getTcProperties() {
        return this.tcProperties;
    }

    public Node setTcProperties(Map<String, String> tcProperties) {
        this.tcProperties.putAll(tcProperties);
        return this;
    }

    public Node setTcProperty(String key, String value) {
        this.tcProperties.put(key, value);
        return this;
    }

    public Node removeTcProperty(String key) {
        this.tcProperties.remove(key);
        return this;
    }

    public Node setName(String name) {
        this.name = name;
        return this;
    }

    public Node setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Node setPublicHostname(String publicHostname) {
        this.publicHostname = publicHostname;
        return this;
    }

    public Node setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Node setPublicPort(Integer publicPort) {
        this.publicPort = publicPort;
        return this;
    }

    public Node setGroupPort(Integer groupPort) {
        this.groupPort = groupPort;
        return this;
    }

    public Node setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public Node setGroupBindAddress(String groupBindAddress) {
        this.groupBindAddress = groupBindAddress;
        return this;
    }

    public Node setMetadataDir(Path metadataDir) {
        this.metadataDir = metadataDir;
        return this;
    }

    public Node setLogDir(Path logDir) {
        this.logDir = logDir;
        return this;
    }

    public Node setBackupDir(Path backupDir) {
        this.backupDir = backupDir;
        return this;
    }

    public Node setSecurityDir(Path securityDir) {
        this.securityDir = securityDir;
        return this;
    }

    public Node setSecurityAuditLogDir(Path securityAuditLogDir) {
        this.securityAuditLogDir = securityAuditLogDir;
        return this;
    }

    public Node clearTcProperties() {
        this.tcProperties.clear();
        return this;
    }

    public Node clearDataDirs() {
        this.dataDirs.clear();
        return this;
    }

    public Node setDataDir(String name, Path path) {
        this.dataDirs.put(name, path);
        return this;
    }

    public Node setDataDirs(Map<String, Path> dataDirs) {
        this.dataDirs.putAll(dataDirs);
        return this;
    }

    public Node removeDataDir(String key) {
        this.dataDirs.remove(key);
        return this;
    }

    public boolean hasAddress(InetSocketAddress address) {
        return InetSocketAddressUtils.areEqual(address, this.getInternalAddress()) || this.getPublicAddress().map(addr -> InetSocketAddressUtils.areEqual(address, addr)).orElse(false) != false;
    }

    public InetSocketAddress getAddress() {
        return this.getPublicAddress().orElseGet(this::getInternalAddress);
    }

    public InetSocketAddress getInternalAddress() {
        if (this.hostname == null || Substitutor.containsSubstitutionParams(this.hostname)) {
            throw new AssertionError((Object)("Node " + this.name + " is not correctly defined with internal address: " + this.hostname + ":" + this.port));
        }
        return InetSocketAddress.createUnresolved(this.hostname, this.port);
    }

    public Optional<InetSocketAddress> getPublicAddress() {
        if (this.publicHostname == null || this.publicPort == null) {
            return Optional.empty();
        }
        if (Substitutor.containsSubstitutionParams(this.publicHostname)) {
            throw new AssertionError((Object)("Node " + this.name + " is not correctly defined with public address: " + this.publicHostname + ":" + this.publicPort));
        }
        return Optional.of(InetSocketAddress.createUnresolved(this.publicHostname, this.publicPort));
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Node clone() {
        return new Node().setDataDirs(this.dataDirs).setBackupDir(this.backupDir).setBindAddress(this.bindAddress).setGroupBindAddress(this.groupBindAddress).setGroupPort(this.groupPort).setHostname(this.hostname).setPublicHostname(this.publicHostname).setLogDir(this.logDir).setMetadataDir(this.metadataDir).setName(this.name).setPort(this.port).setPublicPort(this.publicPort).setTcProperties(this.tcProperties).setLoggerOverrides(this.loggerOverrides).setSecurityAuditLogDir(this.securityAuditLogDir).setSecurityDir(this.securityDir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.port, node.port) && Objects.equals(this.groupPort, node.groupPort) && Objects.equals(this.name, node.name) && Objects.equals(this.hostname, node.hostname) && Objects.equals(this.publicHostname, node.publicHostname) && Objects.equals(this.publicPort, node.publicPort) && Objects.equals(this.bindAddress, node.bindAddress) && Objects.equals(this.groupBindAddress, node.groupBindAddress) && Objects.equals(this.metadataDir, node.metadataDir) && Objects.equals(this.logDir, node.logDir) && Objects.equals(this.backupDir, node.backupDir) && Objects.equals(this.loggerOverrides, node.loggerOverrides) && Objects.equals(this.tcProperties, node.tcProperties) && Objects.equals(this.securityDir, node.securityDir) && Objects.equals(this.securityAuditLogDir, node.securityAuditLogDir) && Objects.equals(this.dataDirs, node.dataDirs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hostname, this.publicHostname, this.port, this.publicPort, this.groupPort, this.bindAddress, this.groupBindAddress, this.tcProperties, this.loggerOverrides, this.metadataDir, this.logDir, this.backupDir, this.securityDir, this.securityAuditLogDir, this.dataDirs);
    }

    public String toString() {
        return "Node{name='" + this.name + '\'' + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + ", publicHostname='" + this.publicHostname + '\'' + ", publicPort=" + this.publicPort + ", groupPort=" + this.groupPort + ", bindAddress='" + this.bindAddress + '\'' + ", groupBindAddress='" + this.groupBindAddress + '\'' + ", metadataDir='" + this.metadataDir + '\'' + ", logDir='" + this.logDir + '\'' + ", backupDir='" + this.backupDir + '\'' + ", loggers='" + this.loggerOverrides + '\'' + ", tcProperties='" + this.tcProperties + '\'' + ", securityDir='" + this.securityDir + '\'' + ", securityAuditLogDir='" + this.securityAuditLogDir + '\'' + ", dataDirs=" + this.dataDirs + '}';
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues) {
        return Setting.modelToProperties(this, expanded, includeDefaultValues);
    }

    public Node fillRequiredSettings() {
        return Setting.fillRequiredSettings(this);
    }
}

