/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.service.IParameterSubstitutor;

class ConfigurationParser {
    private final List<Configuration> configurations;
    private final Consumer<Configuration> defaultAddedListener;

    private ConfigurationParser(List<Configuration> configurations, Consumer<Configuration> defaultAddedListener) {
        this.configurations = new ArrayList<Configuration>((Collection)Objects.requireNonNull(configurations));
        this.defaultAddedListener = Objects.requireNonNull(defaultAddedListener);
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("No configuration provided");
        }
    }

    public Cluster parse() {
        Collection defined = this.configurations.stream().map(Configuration::getSetting).collect(Collectors.toSet());
        Stream.of(Setting.values()).filter(setting -> setting.isScope(Scope.CLUSTER)).filter(setting -> setting.allows(Operation.IMPORT)).filter(setting -> !defined.contains(setting)).map(Configuration::valueOf).forEach(configuration -> {
            this.configurations.add((Configuration)configuration);
            this.defaultAddedListener.accept((Configuration)configuration);
        });
        Set actual = this.configurations.stream().filter(configuration -> configuration.getScope() == Scope.CLUSTER).map(Configuration::getSetting).collect(Collectors.toSet());
        Set expected = Stream.of(Setting.values()).filter(setting -> setting.allows(Operation.IMPORT)).filter(setting -> setting.isScope(Scope.CLUSTER)).collect(Collectors.toSet());
        if (actual.size() > expected.size()) {
            actual.removeAll(expected);
            throw new IllegalArgumentException("Invalid settings found at cluster level: " + actual.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
        if (actual.size() < expected.size()) {
            expected.removeAll(actual);
            throw new IllegalArgumentException("Missing settings at cluster level: " + expected.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
        TreeMap configurationMap = this.configurations.stream().filter(configuration -> configuration.getScope() == Scope.NODE).collect(Collectors.groupingBy(Configuration::getStripeId, TreeMap::new, Collectors.groupingBy(Configuration::getNodeId, TreeMap::new, Collectors.toList())));
        if (configurationMap.isEmpty()) {
            configurationMap.put(1, new TreeMap());
        }
        if (((TreeMap)configurationMap.firstEntry().getValue()).isEmpty()) {
            ((TreeMap)configurationMap.firstEntry().getValue()).put(1, new ArrayList());
        }
        if ((Integer)configurationMap.firstKey() != 1) {
            throw new IllegalArgumentException("Stripe ID must start at 1");
        }
        if (((Integer)configurationMap.lastKey()).intValue() != configurationMap.size()) {
            throw new IllegalArgumentException("Stripe ID must end at " + configurationMap.size());
        }
        configurationMap.forEach((stripeId, nodeCounts) -> {
            if ((Integer)nodeCounts.firstKey() != 1) {
                throw new IllegalArgumentException("Node ID must start at 1 in stripe " + stripeId);
            }
            if (((Integer)nodeCounts.lastKey()).intValue() != nodeCounts.size()) {
                throw new IllegalArgumentException("Node ID must end at " + nodeCounts.size() + " in stripe " + stripeId);
            }
        });
        for (Map.Entry entry : configurationMap.entrySet()) {
            for (Map.Entry nodeEntry : ((TreeMap)entry.getValue()).entrySet()) {
                int stripeId2 = (Integer)entry.getKey();
                int nodeId = (Integer)nodeEntry.getKey();
                List nodeConfigurations2 = (List)nodeEntry.getValue();
                Collection defined2 = nodeConfigurations2.stream().map(Configuration::getSetting).collect(Collectors.toSet());
                Stream.of(Setting.values()).filter(setting -> setting.isScope(Scope.NODE)).filter(setting -> setting.allows(Operation.IMPORT)).filter(setting -> !defined2.contains(setting)).map(setting -> Configuration.valueOf(setting, stripeId2, nodeId)).forEach(configuration -> {
                    nodeConfigurations2.add(configuration);
                    this.configurations.add((Configuration)configuration);
                    this.defaultAddedListener.accept((Configuration)configuration);
                });
                Set actual2 = nodeConfigurations2.stream().filter(configuration -> configuration.getScope() == Scope.NODE).map(Configuration::getSetting).collect(Collectors.toSet());
                Set expected2 = Stream.of(Setting.values()).filter(setting -> setting.allows(Operation.IMPORT)).filter(setting -> setting.isScope(Scope.NODE)).collect(Collectors.toSet());
                if (actual2.size() > expected2.size()) {
                    actual2.removeAll(expected2);
                    throw new IllegalArgumentException("Invalid settings in config file for stripe ID: " + stripeId2 + " and node ID: " + nodeId + ": " + actual2);
                }
                if (actual2.size() >= expected2.size()) continue;
                expected2.removeAll(actual2);
                throw new IllegalArgumentException("Missing settings in config file for stripe ID: " + stripeId2 + " and node ID: " + nodeId + ": " + expected2);
            }
        }
        this.configurations.forEach(configuration -> {
            if (!configuration.getSetting().allows(Operation.IMPORT)) {
                throw new IllegalArgumentException("Invalid input: '" + configuration + "'. Reason: now allowed");
            }
            if (configuration.getScope() == Scope.STRIPE) {
                throw new IllegalArgumentException("Invalid input: '" + configuration + "'. Reason: stripe level configuration not allowed");
            }
            configuration.validate(ClusterState.CONFIGURING, Operation.IMPORT);
        });
        Cluster cluster = Cluster.newCluster(new Stripe[0]);
        configurationMap.forEach((stripeId, nodeConfigurations) -> {
            Stripe stripe = new Stripe();
            nodeConfigurations.forEach((nodeId, configurations) -> {
                Node node = Node.empty();
                stripe.addNode(node);
                if (stripe.getNodeCount() != nodeId.intValue()) {
                    throw new AssertionError((Object)("Expected node count to be: " + nodeId + " but was: " + stripe.getNodeCount()));
                }
                Stream.of(Setting.NODE_NAME, Setting.NODE_HOSTNAME, Setting.NODE_PORT).map(setting -> configurations.stream().filter(configuration -> configuration.getSetting() == setting).findAny().orElseThrow(() -> new IllegalArgumentException("Required setting missing: '" + (Object)setting + "' for node ID: " + nodeId + " in stripe ID: " + stripeId))).forEach(o -> o.apply(node));
            });
            cluster.addStripe(stripe);
            if (cluster.getStripeCount() != stripeId.intValue()) {
                throw new AssertionError((Object)("Expected stripe count to be: " + stripeId + " but was: " + cluster.getStripeCount()));
            }
        });
        this.configurations.forEach(configuration -> configuration.apply(cluster));
        return cluster;
    }

    static Cluster parsePropertyConfiguration(Properties properties, Consumer<Configuration> defaultAddedListener) {
        return new ConfigurationParser(ConfigurationParser.propertiesToConfigurations(properties), defaultAddedListener).parse();
    }

    static Cluster parseCommandLineParameters(Map<Setting, String> userConsoleParameters, IParameterSubstitutor substitutor, Consumer<Configuration> defaultAddedListener) {
        Properties properties = ConfigurationParser.cliToProperties(userConsoleParameters, substitutor, defaultAddedListener);
        return ConfigurationParser.parsePropertyConfiguration(properties, defaultAddedListener);
    }

    private static List<Configuration> propertiesToConfigurations(Properties properties) {
        Objects.requireNonNull(properties);
        return properties.entrySet().stream().map(p -> Configuration.valueOf(p.getKey() + "=" + p.getValue())).collect(Collectors.toList());
    }

    private static Properties cliToProperties(Map<Setting, String> cliParameters, IParameterSubstitutor parameterSubstitutor, Consumer<Configuration> defaultAddedListener) {
        Objects.requireNonNull(cliParameters);
        Properties properties = new Properties();
        cliParameters.forEach((k, v) -> properties.setProperty(ConfigurationParser.prefixed(k), (String)v));
        Stream.of(Setting.values()).filter(setting -> setting.requires(Requirement.RESOLVE_EAGERLY)).forEach(s -> ConfigurationParser.eagerlyResolve(parameterSubstitutor, defaultAddedListener, properties, s));
        return properties;
    }

    private static void eagerlyResolve(IParameterSubstitutor parameterSubstitutor, Consumer<Configuration> defaultAddedListener, Properties properties, Setting setting) {
        String key = ConfigurationParser.prefixed(setting);
        String set = properties.getProperty(key);
        if (set == null) {
            set = parameterSubstitutor.substitute(setting.getDefaultValue());
            defaultAddedListener.accept(Configuration.valueOf(key + "=" + set));
        } else {
            set = parameterSubstitutor.substitute(set);
        }
        properties.setProperty(key, set);
    }

    private static String prefixed(Setting setting) {
        return setting.isScope(Scope.CLUSTER) ? setting.toString() : "stripe.1.node.1." + (Object)((Object)setting);
    }
}

