/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.inet.InetSocketAddressUtils;

public class Node
implements Cloneable,
PropertyHolder {
    private String nodeName;
    private String nodeHostname;
    private String nodePublicHostname;
    private int nodePort = Integer.parseInt(Setting.NODE_PORT.getDefaultValue());
    private Integer nodePublicPort;
    private int nodeGroupPort = Integer.parseInt(Setting.NODE_GROUP_PORT.getDefaultValue());
    private String nodeBindAddress;
    private String nodeGroupBindAddress;
    private Path nodeMetadataDir;
    private Path nodeLogDir;
    private Path nodeBackupDir;
    private Path securityDir;
    private Path securityAuditLogDir;
    private final Map<String, String> tcProperties = new ConcurrentHashMap<String, String>();
    private final Map<String, String> nodeLoggerOverrides = new ConcurrentHashMap<String, String>();
    private final Map<String, Path> dataDirs = new ConcurrentHashMap<String, Path>();

    protected Node() {
    }

    @Override
    public Scope getScope() {
        return Scope.NODE;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeHostname() {
        return this.nodeHostname;
    }

    public String getNodePublicHostname() {
        return this.nodePublicHostname;
    }

    public int getNodePort() {
        return this.nodePort;
    }

    public Integer getNodePublicPort() {
        return this.nodePublicPort;
    }

    public int getNodeGroupPort() {
        return this.nodeGroupPort;
    }

    public String getNodeBindAddress() {
        return this.nodeBindAddress;
    }

    public String getNodeGroupBindAddress() {
        return this.nodeGroupBindAddress;
    }

    public Path getNodeMetadataDir() {
        return this.nodeMetadataDir;
    }

    public Path getNodeLogDir() {
        return this.nodeLogDir;
    }

    public Path getNodeBackupDir() {
        return this.nodeBackupDir;
    }

    public Path getSecurityDir() {
        return this.securityDir;
    }

    public Path getSecurityAuditLogDir() {
        return this.securityAuditLogDir;
    }

    public Map<String, Path> getDataDirs() {
        return Collections.unmodifiableMap(this.dataDirs);
    }

    public Map<String, String> getNodeLoggerOverrides() {
        return Collections.unmodifiableMap(this.nodeLoggerOverrides);
    }

    public Node setNodeLoggerOverrides(Map<String, String> nodeLoggerOverrides) {
        this.nodeLoggerOverrides.putAll(nodeLoggerOverrides);
        return this;
    }

    public Node setNodeLoggerOverride(String logger, String level) {
        this.nodeLoggerOverrides.put(logger, level);
        return this;
    }

    public Node removeNodeLoggerOverride(String logger) {
        this.nodeLoggerOverrides.remove(logger);
        return this;
    }

    public Node clearNodeLoggerOverrides() {
        this.nodeLoggerOverrides.clear();
        return this;
    }

    public Map<String, String> getTcProperties() {
        return this.tcProperties;
    }

    public Node setTcProperties(Map<String, String> tcProperties) {
        this.tcProperties.putAll(tcProperties);
        return this;
    }

    public Node setTcProperty(String key, String value) {
        this.tcProperties.put(key, value);
        return this;
    }

    public Node removeTcProperty(String key) {
        this.tcProperties.remove(key);
        return this;
    }

    public Node setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public Node setNodeHostname(String nodeHostname) {
        this.nodeHostname = nodeHostname;
        return this;
    }

    public Node setNodePublicHostname(String nodePublicHostname) {
        this.nodePublicHostname = nodePublicHostname;
        return this;
    }

    public Node setNodePort(int nodePort) {
        this.nodePort = nodePort;
        return this;
    }

    public Node setNodePublicPort(Integer nodePublicPort) {
        this.nodePublicPort = nodePublicPort;
        return this;
    }

    public Node setNodeGroupPort(int nodeGroupPort) {
        this.nodeGroupPort = nodeGroupPort;
        return this;
    }

    public Node setNodeBindAddress(String nodeBindAddress) {
        this.nodeBindAddress = nodeBindAddress;
        return this;
    }

    public Node setNodeGroupBindAddress(String nodeGroupBindAddress) {
        this.nodeGroupBindAddress = nodeGroupBindAddress;
        return this;
    }

    public Node setNodeMetadataDir(Path nodeMetadataDir) {
        this.nodeMetadataDir = nodeMetadataDir;
        return this;
    }

    public Node setNodeLogDir(Path nodeLogDir) {
        this.nodeLogDir = nodeLogDir;
        return this;
    }

    public Node setNodeBackupDir(Path nodeBackupDir) {
        this.nodeBackupDir = nodeBackupDir;
        return this;
    }

    public Node setSecurityDir(Path securityDir) {
        this.securityDir = securityDir;
        return this;
    }

    public Node setSecurityAuditLogDir(Path securityAuditLogDir) {
        this.securityAuditLogDir = securityAuditLogDir;
        return this;
    }

    public Node clearTcProperties() {
        this.tcProperties.clear();
        return this;
    }

    public Node clearDataDirs() {
        this.dataDirs.clear();
        return this;
    }

    public Node setDataDir(String name, Path path) {
        this.dataDirs.put(name, path);
        return this;
    }

    public Node setDataDirs(Map<String, Path> dataDirs) {
        this.dataDirs.putAll(dataDirs);
        return this;
    }

    public Node removeDataDir(String key) {
        this.dataDirs.remove(key);
        return this;
    }

    public boolean hasAddress(InetSocketAddress address) {
        return InetSocketAddressUtils.areEqual(address, this.getNodeInternalAddress()) || this.getNodePublicAddress().map(addr -> InetSocketAddressUtils.areEqual(address, addr)).orElse(false) != false;
    }

    public InetSocketAddress getNodeAddress() {
        return this.getNodePublicAddress().orElseGet(this::getNodeInternalAddress);
    }

    public InetSocketAddress getNodeInternalAddress() {
        if (this.nodeHostname == null || Substitutor.containsSubstitutionParams(this.nodeHostname)) {
            throw new AssertionError((Object)("Node " + this.nodeName + " is not correctly defined with internal address: " + this.nodeHostname + ":" + this.nodePort));
        }
        return InetSocketAddress.createUnresolved(this.nodeHostname, this.nodePort);
    }

    public Optional<InetSocketAddress> getNodePublicAddress() {
        if (this.nodePublicHostname == null || this.nodePublicPort == null) {
            return Optional.empty();
        }
        if (Substitutor.containsSubstitutionParams(this.nodePublicHostname)) {
            throw new AssertionError((Object)("Node " + this.nodeName + " is not correctly defined with public address: " + this.nodePublicHostname + ":" + this.nodePublicPort));
        }
        return Optional.of(InetSocketAddress.createUnresolved(this.nodePublicHostname, this.nodePublicPort));
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Node clone() {
        return new Node().setDataDirs(this.dataDirs).setNodeBackupDir(this.nodeBackupDir).setNodeBindAddress(this.nodeBindAddress).setNodeGroupBindAddress(this.nodeGroupBindAddress).setNodeGroupPort(this.nodeGroupPort).setNodeHostname(this.nodeHostname).setNodePublicHostname(this.nodePublicHostname).setNodeLogDir(this.nodeLogDir).setNodeMetadataDir(this.nodeMetadataDir).setNodeName(this.nodeName).setNodePort(this.nodePort).setNodePublicPort(this.nodePublicPort).setTcProperties(this.tcProperties).setNodeLoggerOverrides(this.nodeLoggerOverrides).setSecurityAuditLogDir(this.securityAuditLogDir).setSecurityDir(this.securityDir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.nodePort == node.nodePort && this.nodeGroupPort == node.nodeGroupPort && Objects.equals(this.nodeName, node.nodeName) && Objects.equals(this.nodeHostname, node.nodeHostname) && Objects.equals(this.nodePublicHostname, node.nodePublicHostname) && Objects.equals(this.nodePublicPort, node.nodePublicPort) && Objects.equals(this.nodeBindAddress, node.nodeBindAddress) && Objects.equals(this.nodeGroupBindAddress, node.nodeGroupBindAddress) && Objects.equals(this.nodeMetadataDir, node.nodeMetadataDir) && Objects.equals(this.nodeLogDir, node.nodeLogDir) && Objects.equals(this.nodeBackupDir, node.nodeBackupDir) && Objects.equals(this.nodeLoggerOverrides, node.nodeLoggerOverrides) && Objects.equals(this.tcProperties, node.tcProperties) && Objects.equals(this.securityDir, node.securityDir) && Objects.equals(this.securityAuditLogDir, node.securityAuditLogDir) && Objects.equals(this.dataDirs, node.dataDirs);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.nodeHostname, this.nodePublicHostname, this.nodePort, this.nodePublicPort, this.nodeGroupPort, this.nodeBindAddress, this.nodeGroupBindAddress, this.tcProperties, this.nodeLoggerOverrides, this.nodeMetadataDir, this.nodeLogDir, this.nodeBackupDir, this.securityDir, this.securityAuditLogDir, this.dataDirs);
    }

    public String toString() {
        return "Node{nodeName='" + this.nodeName + '\'' + ", nodeHostname='" + this.nodeHostname + '\'' + ", nodePort=" + this.nodePort + ", nodePublicHostname='" + this.nodePublicHostname + '\'' + ", nodePublicPort=" + this.nodePublicPort + ", nodeGroupPort=" + this.nodeGroupPort + ", nodeBindAddress='" + this.nodeBindAddress + '\'' + ", nodeGroupBindAddress='" + this.nodeGroupBindAddress + '\'' + ", nodeMetadataDir='" + this.nodeMetadataDir + '\'' + ", nodeLogDir='" + this.nodeLogDir + '\'' + ", nodeBackupDir='" + this.nodeBackupDir + '\'' + ", nodeLoggers='" + this.nodeLoggerOverrides + '\'' + ", tcProperties='" + this.tcProperties + '\'' + ", securityDir='" + this.securityDir + '\'' + ", securityAuditLogDir='" + this.securityAuditLogDir + '\'' + ", dataDirs=" + this.dataDirs + '}';
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues) {
        return Setting.modelToProperties(this, expanded, includeDefaultValues);
    }

    public Node fillRequiredSettings() {
        return Setting.fillRequiredSettings(this);
    }

    private Node fillSettings() {
        return Setting.fillSettings(this);
    }

    public static Node newDefaultNode(String hostname) {
        return new Node().fillSettings().setNodeHostname(hostname);
    }

    public static Node newDefaultNode(String name, String hostname) {
        return new Node().fillSettings().setNodeName(name).setNodeHostname(hostname);
    }

    public static Node newDefaultNode(String hostname, int port) {
        return new Node().fillSettings().setNodePort(port).setNodeHostname(hostname);
    }

    public static Node newDefaultNode(String name, String hostname, int port) {
        return new Node().fillSettings().setNodeName(name).setNodePort(port).setNodeHostname(hostname);
    }

    public static Node empty() {
        return new Node();
    }
}

