/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;

public class Stripe
implements Cloneable,
PropertyHolder {
    private final List<Node> nodes;

    public Stripe(List<Node> nodes) {
        this.nodes = new CopyOnWriteArrayList<Node>((Collection)Objects.requireNonNull(nodes));
    }

    public Stripe(Node ... nodes) {
        this(Arrays.asList(nodes));
    }

    public Stripe() {
        this.nodes = new ArrayList<Node>();
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stripe stripe = (Stripe)o;
        return this.nodes.equals(stripe.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    public String toString() {
        return "Stripe{nodes=" + this.nodes + '}';
    }

    public String toShapeString() {
        return "( " + this.nodes.stream().map(node -> node.getNodeName() + "@" + node.getNodeAddress()).collect(Collectors.joining(", ")) + " )";
    }

    public Collection<InetSocketAddress> getNodeAddresses() {
        return this.getNodes().stream().map(Node::getNodeAddress).collect(Collectors.toList());
    }

    public Optional<Node> getSingleNode() throws IllegalStateException {
        if (this.nodes.size() > 1) {
            throw new IllegalStateException();
        }
        if (this.nodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.nodes.iterator().next());
    }

    public Optional<Node> getNode(InetSocketAddress address) {
        return this.nodes.stream().filter(node -> node.hasAddress(address)).findAny();
    }

    public boolean containsNode(InetSocketAddress address) {
        return this.nodes.stream().anyMatch(node -> node.hasAddress(address));
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Stripe clone() {
        return new Stripe(this.nodes.stream().map(Node::clone).collect(Collectors.toList()));
    }

    boolean detachNode(InetSocketAddress address) {
        return this.nodes.removeIf(node -> node.hasAddress(address));
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Stripe attachNode(Node source) {
        if (this.containsNode(source.getNodeAddress())) {
            throw new IllegalArgumentException("Node " + source.getNodeAddress() + " is already in the stripe.");
        }
        if (this.isEmpty()) {
            throw new IllegalStateException("Empty stripe.");
        }
        Node aNode = this.nodes.iterator().next();
        Node newNode = source.cloneForAttachment(aNode);
        this.addNode(newNode);
        return this;
    }

    public Stripe addNode(Node source) {
        this.nodes.add(source);
        return this;
    }

    public Stripe cloneForAttachment(Node aNodeFromTargetCluster) {
        return this.nodes.stream().map(node -> node.cloneForAttachment(aNodeFromTargetCluster)).reduce(new Stripe(), Stripe::addNode, (s1, s2) -> {
            throw new UnsupportedOperationException();
        });
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public Optional<Node> getNode(String nodeName) {
        return this.nodes.stream().filter(node -> node.getNodeName().equals(nodeName)).findAny();
    }

    public Optional<Node> getNode(int nodeId) {
        if (nodeId < 1) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId);
        }
        if (nodeId > this.nodes.size()) {
            return Optional.empty();
        }
        return Optional.of(this.nodes.get(nodeId - 1));
    }

    public OptionalInt getNodeId(String nodeName) {
        return IntStream.range(0, this.nodes.size()).filter(idx -> nodeName.equals(this.nodes.get(idx).getNodeName())).map(idx -> idx + 1).findAny();
    }

    public OptionalInt getNodeId(InetSocketAddress nodeAddress) {
        return IntStream.range(0, this.nodes.size()).filter(idx -> this.nodes.get(idx).hasAddress(nodeAddress)).map(idx -> idx + 1).findAny();
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues) {
        Properties properties = new Properties();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String prefix = "node." + (i + 1) + ".";
            Properties props = this.nodes.get(i).toProperties(expanded, includeDefaultValues);
            props.stringPropertyNames().forEach(key -> properties.setProperty(prefix + key, props.getProperty((String)key)));
        }
        return properties;
    }

    @Override
    public Scope getScope() {
        return Scope.STRIPE;
    }
}

