/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.SettingValidator;
import org.terracotta.dynamic_config.api.model.Uuid;

public enum Setting {
    NODE_NAME("name", false, null, Scope.NODE, Setting.fromNode(Node::getNodeName), Setting.intoNode(Node::setNodeName), EnumSet.of(Operation.GET, Operation.CONFIG), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.NODE_NAME_VALIDATOR.accept("name", Tuple2.tuple2(key, value))),
    NODE_HOSTNAME("hostname", false, "%h", Scope.NODE, Setting.fromNode(Node::getNodeHostname), Setting.intoNode(Node::setNodeHostname), EnumSet.of(Operation.GET, Operation.CONFIG), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.HOST_VALIDATOR.accept("hostname", Tuple2.tuple2(key, value))),
    NODE_PUBLIC_HOSTNAME("public-hostname", false, null, Scope.NODE, Setting.fromNode(Node::getNodePublicHostname), Setting.intoNode(Node::setNodePublicHostname), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.HOST_VALIDATOR.accept("public-hostname", Tuple2.tuple2(key, value))),
    NODE_PORT("port", false, "9410", Scope.NODE, Setting.fromNode(Node::getNodePort), Setting.intoNode((node, value) -> node.setNodePort(Integer.parseInt(value))), EnumSet.of(Operation.GET, Operation.CONFIG), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("port", Tuple2.tuple2(key, value))),
    NODE_PUBLIC_PORT("public-port", false, null, Scope.NODE, Setting.fromNode(Node::getNodePublicPort), Setting.intoNode((node, value) -> node.setNodePublicPort(value == null ? null : Integer.valueOf(Integer.parseInt(value)))), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("public-port", Tuple2.tuple2(key, value))),
    NODE_GROUP_PORT("group-port", false, "9430", Scope.NODE, Setting.fromNode(Node::getNodeGroupPort), Setting.intoNode((node, value) -> node.setNodeGroupPort(Integer.parseInt(value))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PORT_VALIDATOR.accept("group-port", Tuple2.tuple2(key, value))),
    NODE_BIND_ADDRESS("bind-address", false, "0.0.0.0", Scope.NODE, Setting.fromNode(Node::getNodeBindAddress), Setting.intoNode(Node::setNodeBindAddress), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.ADDRESS_VALIDATOR.accept("bind-address", Tuple2.tuple2(key, value))),
    NODE_GROUP_BIND_ADDRESS("group-bind-address", false, "0.0.0.0", Scope.NODE, Setting.fromNode(Node::getNodeGroupBindAddress), Setting.intoNode(Node::setNodeGroupBindAddress), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.ADDRESS_VALIDATOR.accept("group-bind-address", Tuple2.tuple2(key, value))),
    CLUSTER_NAME("cluster-name", false, null, Scope.CLUSTER, Setting.fromCluster(Cluster::getName), Setting.intoCluster(Cluster::setName), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART)),
    NODE_CONFIG_DIR("config-dir", false, "%H" + File.separator + "terracotta" + File.separator + "config", Scope.NODE, node -> {
        throw new UnsupportedOperationException("Unable to get the configuration directory of a node");
    }, Setting.unsupported(), EnumSet.noneOf(Operation.class), EnumSet.noneOf(Requirement.class), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("config-dir", Tuple2.tuple2(key, value))),
    NODE_METADATA_DIR("metadata-dir", false, "%H" + File.separator + "terracotta" + File.separator + "metadata", Scope.NODE, Setting.fromNode(Node::getNodeMetadataDir), Setting.intoNode((node, value) -> node.setNodeMetadataDir(Paths.get(value, new String[0]))), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("metadata-dir", Tuple2.tuple2(key, value))),
    NODE_LOG_DIR("log-dir", false, "%H" + File.separator + "terracotta" + File.separator + "logs", Scope.NODE, Setting.fromNode(Node::getNodeLogDir), Setting.intoNode((node, value) -> node.setNodeLogDir(Paths.get(value, new String[0]))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("log-dir", Tuple2.tuple2(key, value))),
    NODE_BACKUP_DIR("backup-dir", false, null, Scope.NODE, Setting.fromNode(Node::getNodeBackupDir), Setting.intoNode((node, value) -> node.setNodeBackupDir(value == null ? null : Paths.get(value, new String[0]))), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("backup-dir", Tuple2.tuple2(key, value))),
    TC_PROPERTIES("tc-properties", true, null, Scope.NODE, Setting.fromNode(Node::getTcProperties), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.allNulls()) {
            node.clearTcProperties();
        } else if (tuple.t1 != null && tuple.t2 == null) {
            node.removeTcProperty((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.clearTcProperties();
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> node.setTcProperty(kv[0], kv[1]));
        } else {
            node.setTcProperty((String)tuple.t1, (String)tuple.t2);
        }
    }), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PROPS_VALIDATOR.accept("tc-properties", Tuple2.tuple2(key, value))),
    NODE_LOGGER_OVERRIDES("logger-overrides", true, null, Scope.NODE, Setting.fromNode(Node::getNodeLoggerOverrides), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.allNulls()) {
            node.clearNodeLoggerOverrides();
        } else if (tuple.t1 != null && tuple.t2 == null) {
            node.removeNodeLoggerOverride((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.clearNodeLoggerOverrides();
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> node.setNodeLoggerOverride(kv[0], kv[1].toUpperCase(Locale.ROOT)));
        } else {
            node.setNodeLoggerOverride((String)tuple.t1, ((String)tuple.t2).toUpperCase(Locale.ROOT));
        }
    }), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.LOGGER_LEVEL_VALIDATOR.accept("logger-overrides", Tuple2.tuple2(key, value))),
    CLIENT_RECONNECT_WINDOW("client-reconnect-window", false, "120s", Scope.CLUSTER, Setting.fromCluster(Cluster::getClientReconnectWindow), Setting.intoCluster((cluster, value) -> cluster.setClientReconnectWindow(Measure.parse(value, TimeUnit.class))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Arrays.asList(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS), (key, value) -> SettingValidator.TIME_VALIDATOR.accept("client-reconnect-window", Tuple2.tuple2(key, value))),
    FAILOVER_PRIORITY("failover-priority", false, null, Scope.CLUSTER, Setting.fromCluster(Cluster::getFailoverPriority), Setting.intoCluster((cluster, value) -> cluster.setFailoverPriority(FailoverPriority.valueOf(value))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.DEFAULT_VALIDATOR.andThen((k, v) -> FailoverPriority.valueOf((String)v.t2)).accept("failover-priority", Tuple2.tuple2(key, value))),
    CLIENT_LEASE_DURATION("client-lease-duration", false, "150s", Scope.CLUSTER, Setting.fromCluster(Cluster::getClientLeaseDuration), Setting.intoCluster((cluster, value) -> cluster.setClientLeaseDuration(Measure.parse(value, TimeUnit.class))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Arrays.asList(TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS), (key, value) -> SettingValidator.TIME_VALIDATOR.accept("client-lease-duration", Tuple2.tuple2(key, value))),
    LICENSE_FILE("license-file", false, null, Scope.CLUSTER, o -> {
        throw new UnsupportedOperationException("Unable to get a license file");
    }, Setting.unsupported(), EnumSet.of(Operation.SET), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("license-file", Tuple2.tuple2(key, value))),
    SECURITY_DIR("security-dir", false, null, Scope.NODE, Setting.fromNode(Node::getSecurityDir), Setting.intoNode((node, value) -> node.setSecurityDir(value == null ? null : Paths.get(value, new String[0]))), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("security-dir", Tuple2.tuple2(key, value))),
    SECURITY_AUDIT_LOG_DIR("audit-log-dir", false, null, Scope.NODE, Setting.fromNode(Node::getSecurityAuditLogDir), Setting.intoNode((node, value) -> node.setSecurityAuditLogDir(value == null ? null : Paths.get(value, new String[0]))), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.PATH_VALIDATOR.accept("audit-log-dir", Tuple2.tuple2(key, value))),
    SECURITY_AUTHC("authc", false, null, Scope.CLUSTER, Setting.fromCluster(Cluster::getSecurityAuthc), Setting.intoCluster(Cluster::setSecurityAuthc), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Arrays.asList("file", "ldap", "certificate")),
    SECURITY_SSL_TLS("ssl-tls", false, "false", Scope.CLUSTER, Setting.fromCluster(Cluster::isSecuritySslTls), Setting.intoCluster((cluster, value) -> cluster.setSecuritySslTls(Boolean.parseBoolean(value))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Arrays.asList("true", "false")),
    SECURITY_WHITELIST("whitelist", false, "false", Scope.CLUSTER, Setting.fromCluster(Cluster::isSecurityWhitelist), Setting.intoCluster((cluster, value) -> cluster.setSecurityWhitelist(Boolean.parseBoolean(value))), EnumSet.of(Operation.GET, Operation.SET, Operation.CONFIG), EnumSet.of(Requirement.ALL_NODES_ONLINE, Requirement.RESTART), Arrays.asList("true", "false")),
    OFFHEAP_RESOURCES("offheap-resources", true, "main:512MB", Scope.CLUSTER, Setting.fromCluster(Cluster::getOffheapResources), Setting.intoClusterMap((cluster, tuple) -> {
        if (tuple.allNulls()) {
            cluster.clearOffheapResources();
        } else if (tuple.t1 != null && tuple.t2 == null) {
            cluster.removeOffheapResource((String)tuple.t1);
        } else if (tuple.t1 == null) {
            cluster.clearOffheapResources();
            Stream.of(((String)tuple.t2).split(",")).map(kv -> kv.split(":")).forEach(kv -> cluster.setOffheapResource(kv[0], Measure.parse(kv[1], MemoryUnit.class)));
        } else {
            cluster.setOffheapResource((String)tuple.t1, Measure.parse((String)tuple.t2, MemoryUnit.class));
        }
    }), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Arrays.asList(MemoryUnit.values()), (key, value) -> SettingValidator.OFFHEAP_VALIDATOR.accept("offheap-resources", Tuple2.tuple2(key, value))),
    DATA_DIRS("data-dirs", true, "main:%H" + File.separator + "terracotta" + File.separator + "user-data" + File.separator + "main", Scope.NODE, Setting.fromNode(Node::getDataDirs), Setting.intoNodeMap((node, tuple) -> {
        if (tuple.allNulls()) {
            node.clearDataDirs();
        } else if (tuple.t1 != null && tuple.t2 == null) {
            node.removeDataDir((String)tuple.t1);
        } else if (tuple.t1 == null) {
            node.clearDataDirs();
            Stream.of(((String)tuple.t2).split(",")).forEach(kv -> {
                int firstColon = kv.indexOf(":");
                node.setDataDir(kv.substring(0, firstColon), Paths.get(kv.substring(firstColon + 1), new String[0]));
            });
        } else {
            node.setDataDir((String)tuple.t1, Paths.get((String)tuple.t2, new String[0]));
        }
    }), EnumSet.of(Operation.GET, Operation.SET, Operation.UNSET, Operation.CONFIG), EnumSet.of(Requirement.ACTIVES_ONLINE), Collections.emptyList(), Collections.emptyList(), (key, value) -> SettingValidator.DATA_DIRS_VALIDATOR.accept("data-dirs", Tuple2.tuple2(key, value)));

    private final String name;
    private final boolean map;
    private final String defaultValue;
    private final Scope scope;
    private final Function<PropertyHolder, Stream<Tuple2<String, String>>> extractor;
    private final Collection<Operation> operations;
    private final Collection<Requirement> requirements;
    private final Collection<String> allowedValues;
    private final Collection<? extends Enum<?>> allowedUnits;
    private final BiConsumer<String, String> validator;
    private final BiConsumer<PropertyHolder, Tuple2<String, String>> setter;

    private Setting(String name, boolean map, String defaultValue, Scope scope, Function<PropertyHolder, Stream<Tuple2<String, String>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, EnumSet<Operation> operations) {
        this(name, map, defaultValue, scope, extractor, setter, operations, EnumSet.noneOf(Requirement.class));
    }

    private Setting(String name, boolean map, String defaultValue, Scope scope, Function<PropertyHolder, Stream<Tuple2<String, String>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, EnumSet<Operation> operations, EnumSet<Requirement> requirements) {
        this(name, map, defaultValue, scope, extractor, setter, operations, requirements, Collections.emptyList(), Collections.emptyList());
    }

    private Setting(String name, boolean map, String defaultValue, Scope scope, Function<PropertyHolder, Stream<Tuple2<String, String>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, EnumSet<Operation> operations, EnumSet<Requirement> requirements, Collection<String> allowedValues) {
        this(name, map, defaultValue, scope, extractor, setter, operations, requirements, allowedValues, Collections.emptyList());
    }

    private Setting(String name, boolean map, String defaultValue, Scope scope, Function<PropertyHolder, Stream<Tuple2<String, String>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, EnumSet<Operation> operations, EnumSet<Requirement> requirements, Collection<String> allowedValues, Collection<? extends Enum<?>> allowedUnits) {
        this(name, map, defaultValue, scope, extractor, setter, operations, requirements, allowedValues, allowedUnits, (key, value) -> SettingValidator.DEFAULT_VALIDATOR.accept(name, Tuple2.tuple2(key, value)));
    }

    private Setting(String name, boolean map, String defaultValue, Scope scope, Function<PropertyHolder, Stream<Tuple2<String, String>>> extractor, BiConsumer<PropertyHolder, Tuple2<String, String>> setter, EnumSet<Operation> operations, EnumSet<Requirement> requirements, Collection<String> allowedValues, Collection<? extends Enum<?>> allowedUnits, BiConsumer<String, String> validator) {
        this.name = name;
        this.map = map;
        this.defaultValue = defaultValue;
        this.extractor = extractor;
        this.setter = setter;
        this.operations = operations;
        this.scope = scope;
        this.requirements = requirements;
        this.allowedValues = Collections.unmodifiableSet(new LinkedHashSet<String>(allowedValues));
        this.allowedUnits = Collections.unmodifiableSet(new LinkedHashSet(allowedUnits));
        this.validator = validator;
        if ((operations.contains((Object)Operation.SET) || operations.contains((Object)Operation.UNSET)) && !requirements.contains((Object)Requirement.ACTIVES_ONLINE) && !requirements.contains((Object)Requirement.ALL_NODES_ONLINE)) {
            throw new AssertionError((Object)("Invalid definition of setting " + name + ": settings supporting mutative operations require either " + (Object)((Object)Requirement.ACTIVES_ONLINE) + " or " + (Object)((Object)Requirement.ALL_NODES_ONLINE)));
        }
        if (scope == Scope.STRIPE) {
            throw new AssertionError((Object)("Invalid scope for setting definition: " + name + ". Must be " + (Object)((Object)Scope.NODE) + " or " + (Object)((Object)Scope.CLUSTER)));
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMap() {
        return this.map;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void fillDefault(PropertyHolder o) {
        String v = this.getDefaultValue();
        if (v != null && !this.getProperty(o).isPresent()) {
            this.setProperty(o, v);
        }
    }

    public String getDefaultValue() {
        if (this == NODE_NAME) {
            return "node-" + Uuid.generateShortUuid();
        }
        return this.defaultValue;
    }

    public Collection<String> getAllowedValues() {
        return this.allowedValues;
    }

    public <U extends Enum<U>> Collection<U> getAllowedUnits() {
        return this.allowedUnits;
    }

    public boolean requires(Requirement requirement) {
        return this.requirements.contains((Object)requirement);
    }

    public boolean allowsAnyOperationInScope(Scope scope) {
        if (this.operations.isEmpty()) {
            return false;
        }
        if (this.allowsOperation(Operation.SET) || this.allowsOperation(Operation.UNSET) || this.allowsOperation(Operation.GET)) {
            if (this.scope == Scope.CLUSTER) {
                return scope == Scope.CLUSTER;
            }
            if (this.scope == Scope.NODE) {
                return true;
            }
        } else if (this.allowsOperation(Operation.CONFIG)) {
            return scope == this.scope;
        }
        throw new AssertionError((Object)("Invalid scope for setting definition: " + (Object)((Object)this) + ". Must be " + (Object)((Object)Scope.NODE) + " or " + (Object)((Object)Scope.CLUSTER)));
    }

    public boolean allowsOperation(Operation operation) {
        return this.operations.contains((Object)operation);
    }

    public boolean allowsOperationInScope(Operation operation, Scope scope) {
        if (!this.allowsOperation(operation) || !this.allowsAnyOperationInScope(scope)) {
            return false;
        }
        switch (operation) {
            case GET: {
                return true;
            }
            case CONFIG: {
                return scope == this.scope;
            }
            case SET: 
            case UNSET: {
                return this.scope == Scope.CLUSTER ? scope == Scope.CLUSTER : this.scope == Scope.NODE;
            }
        }
        throw new AssertionError((Object)operation);
    }

    public boolean isRequired() {
        return this == FAILOVER_PRIORITY || !this.allowsOperation(Operation.UNSET) && (!this.allowsOperation(Operation.CONFIG) || this.getDefaultValue() != null);
    }

    public boolean isReadOnly() {
        return !this.allowsOperation(Operation.SET) && !this.allowsOperation(Operation.CONFIG) && !this.allowsOperation(Operation.UNSET);
    }

    public boolean isScope(Scope scope) {
        return this.scope == scope;
    }

    public void validate(String key, String value) {
        if (key == null && value == null && !this.isRequired()) {
            return;
        }
        this.validator.accept(key, value);
    }

    public void validate(String value) {
        this.validate(null, value);
    }

    public Optional<String> getProperty(PropertyHolder o) {
        return this.extractor.apply(o).filter(tuple -> !tuple.allNulls()).map(tuple -> tuple.t1 == null ? (String)tuple.t2 : (String)tuple.t1 + ":" + (String)tuple.t2).reduce((result, element) -> result + "," + element);
    }

    public Optional<String> getProperty(NodeContext nodeContext) {
        return this.getProperty(this.getTarget(nodeContext));
    }

    public Stream<Tuple2<String, String>> getExpandedProperties(NodeContext nodeContext) {
        return this.getExpandedProperties(this.getTarget(nodeContext));
    }

    public Stream<Tuple2<String, String>> getExpandedProperties(PropertyHolder o) {
        if (!this.isMap()) {
            throw new UnsupportedOperationException();
        }
        return this.extractor.apply(o).filter(tuple -> tuple.t1 != null);
    }

    public void setProperty(PropertyHolder o, String value) {
        this.setProperty(o, null, value);
    }

    public void setProperty(NodeContext nodeContext, String key, String value) {
        this.setProperty((PropertyHolder)((Object)(this.scope == Scope.CLUSTER ? nodeContext.getCluster() : nodeContext.getNode())), key, value);
    }

    public void setProperty(PropertyHolder node, String key, String value) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Setting: " + (Object)((Object)this) + " is read-only");
        }
        this.validate(key, value);
        this.setter.accept(node, Tuple2.tuple2(key, value));
    }

    public Properties toProperties(PropertyHolder o, boolean expanded, boolean includeDefaultValues) {
        boolean exclude;
        Properties properties = new Properties();
        String currentValue = this.getProperty(o).orElse(null);
        String defaultValue = this.getDefaultValue();
        boolean bl = exclude = !includeDefaultValues && currentValue == null && defaultValue == null || !includeDefaultValues && defaultValue != null && Objects.equals(defaultValue, currentValue) || !includeDefaultValues && currentValue == null && this.isRequired();
        if (!exclude) {
            if (currentValue == null || !expanded || !this.isMap()) {
                properties.setProperty(this.name, currentValue != null ? currentValue : "");
            } else {
                this.getExpandedProperties(o).forEach(prop -> properties.setProperty(this.name + "." + (String)prop.t1, (String)prop.t2));
            }
        }
        return properties;
    }

    public boolean allowsValue(String value) {
        return this.allowedValues.isEmpty() || this.allowedValues.contains(value);
    }

    public boolean mustBeResolved() {
        return this == NODE_HOSTNAME || this == NODE_PORT || this == NODE_NAME;
    }

    private PropertyHolder getTarget(NodeContext nodeContext) {
        return this.scope == Scope.CLUSTER ? nodeContext.getCluster() : nodeContext.getNode();
    }

    public static Setting fromName(String name) {
        return Setting.findSetting(name).orElseThrow(() -> new IllegalArgumentException("Illegal setting name: " + name));
    }

    public static Optional<Setting> findSetting(String name) {
        return Stream.of(Setting.values()).filter(setting -> setting.name.equals(name)).findAny();
    }

    public static <T extends PropertyHolder> T fillRequiredSettings(T o) {
        Stream.of(Setting.values()).filter(Predicate.isEqual((Object)NODE_HOSTNAME).negate()).filter(Predicate.isEqual((Object)NODE_CONFIG_DIR).negate()).filter(Predicate.isEqual((Object)CLUSTER_NAME).negate()).filter(Predicate.isEqual((Object)LICENSE_FILE).negate()).filter(s -> s.isScope(o.getScope())).filter(Setting::isRequired).forEach(setting -> setting.fillDefault(o));
        return o;
    }

    public static <T extends PropertyHolder> T fillSettings(T o) {
        Stream.of(Setting.values()).filter(Predicate.isEqual((Object)NODE_HOSTNAME).negate()).filter(Predicate.isEqual((Object)NODE_CONFIG_DIR).negate()).filter(Predicate.isEqual((Object)CLUSTER_NAME).negate()).filter(Predicate.isEqual((Object)LICENSE_FILE).negate()).filter(s -> s.isScope(o.getScope())).forEach(setting -> setting.fillDefault(o));
        return o;
    }

    public static Properties modelToProperties(PropertyHolder o, boolean expanded, boolean includeDefaultValues) {
        Properties properties = new Properties();
        Stream.of(Setting.values()).filter(setting -> setting.allowsOperation(Operation.CONFIG)).filter(setting -> setting.isScope(o.getScope())).forEach(setting -> properties.putAll((Map<?, ?>)setting.toProperties(o, expanded, includeDefaultValues)));
        return properties;
    }

    private static Function<PropertyHolder, Stream<Tuple2<String, String>>> fromNode(Function<Node, Object> extractor) {
        return node -> {
            Object o = extractor.apply((Node)node);
            if (o == null) {
                return Stream.empty();
            }
            if (o instanceof Map) {
                return ((Map)o).entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(e -> Tuple2.tuple2(e.getKey(), e.getValue().toString()));
            }
            return Stream.of(Tuple2.tuple2(null, String.valueOf(o)));
        };
    }

    private static Function<PropertyHolder, Stream<Tuple2<String, String>>> fromCluster(Function<Cluster, Object> extractor) {
        return cluster -> {
            Object o = extractor.apply((Cluster)cluster);
            if (o == null) {
                return Stream.empty();
            }
            if (o instanceof Map) {
                return ((Map)o).entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(e -> Tuple2.tuple2(e.getKey(), e.getValue().toString()));
            }
            return Stream.of(Tuple2.tuple2(null, String.valueOf(o)));
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoNode(BiConsumer<Node, String> setter) {
        return (node, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Node)node, tuple.t2 == null || ((String)tuple.t2).trim().isEmpty() ? null : ((String)tuple.t2).trim());
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoCluster(BiConsumer<Cluster, String> setter) {
        return (cluster, tuple) -> {
            if (tuple.t1 != null) {
                throw new IllegalArgumentException("Key must be null: parameter is not a map");
            }
            setter.accept((Cluster)cluster, tuple.t2 == null || ((String)tuple.t2).trim().isEmpty() ? null : ((String)tuple.t2).trim());
        };
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoNodeMap(BiConsumer<Node, Tuple2<String, String>> setter) {
        return (node, tuple) -> setter.accept((Node)node, Tuple2.tuple2(tuple.t1, tuple.t2 == null || ((String)tuple.t2).trim().isEmpty() ? null : ((String)tuple.t2).trim()));
    }

    private static BiConsumer<PropertyHolder, Tuple2<String, String>> intoClusterMap(BiConsumer<Cluster, Tuple2<String, String>> setter) {
        return (cluster, tuple) -> setter.accept((Cluster)cluster, Tuple2.tuple2(tuple.t1, tuple.t2 == null || ((String)tuple.t2).trim().isEmpty() ? null : ((String)tuple.t2).trim()));
    }

    private static <U, V> BiConsumer<U, V> unsupported() {
        return (u, v) -> {
            throw new UnsupportedOperationException();
        };
    }
}

