/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;

public class Cluster
implements Cloneable,
PropertyHolder {
    private final List<Stripe> stripes;
    private String name;
    private Measure<org.terracotta.common.struct.TimeUnit> clientReconnectWindow;
    private Measure<org.terracotta.common.struct.TimeUnit> clientLeaseDuration;
    private String securityAuthc;
    private boolean securitySslTls = Boolean.parseBoolean(Setting.SECURITY_SSL_TLS.getDefaultValue());
    private boolean securityWhitelist = Boolean.parseBoolean(Setting.SECURITY_WHITELIST.getDefaultValue());
    private FailoverPriority failoverPriority = FailoverPriority.availability();
    private final Map<String, Measure<MemoryUnit>> offheapResources = new ConcurrentHashMap<String, Measure<MemoryUnit>>();

    protected Cluster(String name, List<Stripe> stripes) {
        this.stripes = new CopyOnWriteArrayList<Stripe>((Collection)Objects.requireNonNull(stripes));
        this.name = name;
    }

    @Override
    public Scope getScope() {
        return Scope.CLUSTER;
    }

    public String getSecurityAuthc() {
        return this.securityAuthc;
    }

    public boolean isSecuritySslTls() {
        return this.securitySslTls;
    }

    public boolean isSecurityWhitelist() {
        return this.securityWhitelist;
    }

    public FailoverPriority getFailoverPriority() {
        return this.failoverPriority;
    }

    public Measure<org.terracotta.common.struct.TimeUnit> getClientReconnectWindow() {
        return this.clientReconnectWindow;
    }

    public Measure<org.terracotta.common.struct.TimeUnit> getClientLeaseDuration() {
        return this.clientLeaseDuration;
    }

    public Map<String, Measure<MemoryUnit>> getOffheapResources() {
        return Collections.unmodifiableMap(this.offheapResources);
    }

    public Cluster setSecurityAuthc(String securityAuthc) {
        this.securityAuthc = securityAuthc;
        return this;
    }

    public Cluster setSecuritySslTls(boolean securitySslTls) {
        this.securitySslTls = securitySslTls;
        return this;
    }

    public Cluster setSecurityWhitelist(boolean securityWhitelist) {
        this.securityWhitelist = securityWhitelist;
        return this;
    }

    public Cluster setFailoverPriority(FailoverPriority failoverPriority) {
        this.failoverPriority = failoverPriority;
        return this;
    }

    public Cluster setClientReconnectWindow(long clientReconnectWindow, org.terracotta.common.struct.TimeUnit timeUnit) {
        return this.setClientReconnectWindow(Measure.of(clientReconnectWindow, timeUnit));
    }

    public Cluster setClientReconnectWindow(long clientReconnectWindow, TimeUnit jdkUnit) {
        return this.setClientReconnectWindow(Measure.of(clientReconnectWindow, (Enum)org.terracotta.common.struct.TimeUnit.from(jdkUnit).orElseThrow(() -> new IllegalArgumentException(jdkUnit.name()))));
    }

    public Cluster setClientReconnectWindow(Measure<org.terracotta.common.struct.TimeUnit> measure) {
        this.clientReconnectWindow = measure;
        return this;
    }

    public Cluster setClientLeaseDuration(long clientLeaseDuration, org.terracotta.common.struct.TimeUnit timeUnit) {
        return this.setClientLeaseDuration(Measure.of(clientLeaseDuration, timeUnit));
    }

    public Cluster setClientLeaseDuration(long clientLeaseDuration, TimeUnit jdkUnit) {
        return this.setClientLeaseDuration(Measure.of(clientLeaseDuration, (Enum)org.terracotta.common.struct.TimeUnit.from(jdkUnit).orElseThrow(() -> new IllegalArgumentException(jdkUnit.name()))));
    }

    public Cluster setClientLeaseDuration(Measure<org.terracotta.common.struct.TimeUnit> measure) {
        this.clientLeaseDuration = measure;
        return this;
    }

    public Cluster setOffheapResource(String name, long quantity, MemoryUnit memoryUnit) {
        return this.setOffheapResource(name, Measure.of(quantity, memoryUnit));
    }

    public Cluster setOffheapResource(String name, Measure<MemoryUnit> measure) {
        this.offheapResources.put(name, measure);
        return this;
    }

    public Cluster setOffheapResources(Map<String, Measure<MemoryUnit>> offheapResources) {
        this.offheapResources.putAll(offheapResources);
        return this;
    }

    public Cluster removeOffheapResource(String key) {
        this.offheapResources.remove(key);
        return this;
    }

    public Cluster clearOffheapResources() {
        this.offheapResources.clear();
        return this;
    }

    public List<Stripe> getStripes() {
        return Collections.unmodifiableList(this.stripes);
    }

    public Cluster addStripe(Stripe stripe) {
        this.stripes.add(stripe);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Cluster setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isEmpty() {
        return this.stripes.isEmpty() || this.getNodeAddresses().isEmpty();
    }

    public Optional<Node> getSingleNode() throws IllegalStateException {
        return this.getSingleStripe().flatMap(Stripe::getSingleNode);
    }

    public Optional<Stripe> getSingleStripe() {
        if (this.stripes.size() > 1) {
            throw new IllegalStateException();
        }
        if (this.stripes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.stripes.iterator().next());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster that = (Cluster)o;
        return Objects.equals(this.stripes, that.stripes) && Objects.equals(this.name, that.name) && this.securitySslTls == that.securitySslTls && this.securityWhitelist == that.securityWhitelist && Objects.equals(this.securityAuthc, that.securityAuthc) && Objects.equals(this.failoverPriority, that.failoverPriority) && Objects.equals(this.clientReconnectWindow, that.clientReconnectWindow) && Objects.equals(this.clientLeaseDuration, that.clientLeaseDuration) && Objects.equals(this.offheapResources, that.offheapResources);
    }

    public int hashCode() {
        return Objects.hash(this.stripes, this.name, this.securityAuthc, this.securitySslTls, this.securityWhitelist, this.failoverPriority, this.clientReconnectWindow, this.clientLeaseDuration, this.offheapResources);
    }

    public String toString() {
        return "Cluster{name='" + this.name + '\'' + ", securityAuthc='" + this.securityAuthc + '\'' + ", securitySslTls=" + this.securitySslTls + ", securityWhitelist=" + this.securityWhitelist + ", failoverPriority='" + this.failoverPriority + '\'' + ", clientReconnectWindow=" + this.clientReconnectWindow + ", clientLeaseDuration=" + this.clientLeaseDuration + ", offheapResources=" + this.offheapResources + ", stripes='" + this.stripes + '}';
    }

    public String toShapeString() {
        return "Cluster '" + this.name + "' ( " + this.stripes.stream().map(Stripe::toShapeString).collect(Collectors.joining(", ")) + " )";
    }

    public Optional<Stripe> getStripe(InetSocketAddress address) {
        return this.stripes.stream().filter(stripe -> stripe.containsNode(address)).findAny();
    }

    public Collection<InetSocketAddress> getNodeAddresses() {
        return this.stripes.stream().flatMap(stripe -> stripe.getNodes().stream()).map(Node::getNodeAddress).collect(Collectors.toList());
    }

    public boolean containsNode(InetSocketAddress address) {
        return this.getStripe(address).isPresent();
    }

    public boolean containsNode(int stripeId, String nodeName) {
        return this.getStripe(stripeId).flatMap(stripe -> stripe.getNode(nodeName)).isPresent();
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Cluster clone() {
        return new Cluster(this.name, this.stripes.stream().map(Stripe::clone).collect(Collectors.toList())).setClientLeaseDuration(this.clientLeaseDuration).setClientReconnectWindow(this.clientReconnectWindow).setFailoverPriority(this.failoverPriority).setOffheapResources(this.offheapResources).setSecurityAuthc(this.securityAuthc).setSecuritySslTls(this.securitySslTls).setSecurityWhitelist(this.securityWhitelist);
    }

    public Cluster attachStripe(Stripe stripe) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Empty cluster.");
        }
        List duplicates = stripe.getNodes().stream().map(Node::getNodeAddress).filter(this::containsNode).map(InetSocketAddress::toString).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Nodes are already in the cluster: " + String.join((CharSequence)", ", duplicates) + ".");
        }
        Node aNode = this.stripes.iterator().next().getNodes().iterator().next();
        Stripe newStripe = stripe.cloneForAttachment(aNode);
        this.stripes.add(newStripe);
        return this;
    }

    public boolean detachStripe(Stripe stripe) {
        return this.stripes.remove(stripe);
    }

    public boolean detachNode(InetSocketAddress address) {
        boolean detached = this.stripes.stream().anyMatch(stripe -> stripe.detachNode(address));
        if (detached) {
            this.stripes.removeIf(Stripe::isEmpty);
        }
        return detached;
    }

    public Optional<Node> getNode(InetSocketAddress nodeAddress) {
        return this.stripes.stream().flatMap(stripe -> stripe.getNodes().stream()).filter(node -> node.hasAddress(nodeAddress)).findAny();
    }

    public OptionalInt getStripeId(InetSocketAddress address) {
        return IntStream.range(0, this.stripes.size()).filter(idx -> this.stripes.get(idx).containsNode(address)).map(idx -> idx + 1).findAny();
    }

    public OptionalInt getNodeId(InetSocketAddress address) {
        return this.stripes.stream().map(stripe -> stripe.getNodeId(address)).filter(OptionalInt::isPresent).findAny().orElse(OptionalInt.empty());
    }

    public OptionalInt getNodeId(int stripeId, String nodeName) {
        return this.getStripe(stripeId).map(stripe -> IntStream.range(0, stripe.getNodeCount()).filter(idx -> nodeName.equals(stripe.getNodes().get(idx).getNodeName())).map(idx -> idx + 1).findAny()).orElse(OptionalInt.empty());
    }

    public Optional<Stripe> getStripe(int stripeId) {
        if (stripeId < 1) {
            throw new IllegalArgumentException("Invalid stripe ID: " + stripeId);
        }
        if (stripeId > this.stripes.size()) {
            return Optional.empty();
        }
        return Optional.of(this.stripes.get(stripeId - 1));
    }

    public int getNodeCount() {
        return this.stripes.stream().mapToInt(Stripe::getNodeCount).sum();
    }

    public int getStripeCount() {
        return this.stripes.size();
    }

    public Collection<Node> getNodes() {
        return this.stripes.stream().flatMap(s -> s.getNodes().stream()).collect(Collectors.toList());
    }

    public Optional<Node> getNode(int stripeId, String nodeName) {
        return this.getStripe(stripeId).flatMap(stripe -> stripe.getNode(nodeName));
    }

    public Optional<Node> getNode(int stripeId, int nodeId) {
        return this.getStripe(stripeId).flatMap(stripe -> stripe.getNode(nodeId));
    }

    public Stream<NodeContext> nodeContexts() {
        return IntStream.rangeClosed(1, this.stripes.size()).boxed().flatMap(stripeId -> this.stripes.get(stripeId - 1).getNodes().stream().map(Node::getNodeName).map(name -> new NodeContext(this, (int)stripeId, (String)name)));
    }

    public void forEach(BiConsumer<Integer, Node> consumer) {
        List<Stripe> stripes = this.getStripes();
        for (int i = 0; i < stripes.size(); ++i) {
            int stripeId = i + 1;
            stripes.get(stripeId - 1).getNodes().forEach((? super T node) -> consumer.accept(stripeId, (Node)node));
        }
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues) {
        Properties properties = Setting.modelToProperties(this, expanded, includeDefaultValues);
        for (int i = 0; i < this.stripes.size(); ++i) {
            String prefix = "stripe." + (i + 1) + ".";
            Properties props = this.stripes.get(i).toProperties(expanded, includeDefaultValues);
            props.stringPropertyNames().forEach((? super T key) -> properties.setProperty(prefix + key, props.getProperty((String)key)));
        }
        return properties;
    }

    public Collection<String> getDataDirNames() {
        return this.getNodes().stream().flatMap(node -> node.getDataDirs().keySet().stream()).collect(Collectors.toSet());
    }

    public Cluster fillRequiredSettings() {
        return Setting.fillRequiredSettings(this);
    }

    private Cluster fillSettings() {
        return Setting.fillSettings(this);
    }

    public Cluster removeStripes() {
        this.stripes.clear();
        return this;
    }

    public static Cluster newDefaultCluster() {
        return Cluster.newDefaultCluster((String)null);
    }

    public static Cluster newDefaultCluster(String name) {
        return new Cluster(name, Collections.emptyList()).fillSettings();
    }

    public static Cluster newDefaultCluster(Stripe ... stripes) {
        return Cluster.newCluster(stripes).fillSettings();
    }

    public static Cluster newDefaultCluster(String name, Stripe ... stripes) {
        return new Cluster(name, Arrays.asList(stripes)).fillSettings();
    }

    public static Cluster newCluster(Stripe ... stripes) {
        return new Cluster(null, Arrays.asList(stripes));
    }
}

