/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.loaderwriter.writebehind;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.loaderwriter.writebehind.ClusteredWriteBehindStore;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.common.internal.util.ChainBuilder;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;

class ClusteredWriteBehind<K, V> {
    private final ClusteredWriteBehindStore<K, V> clusteredWriteBehindStore;
    private final ExecutorService executorService;
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final OperationsCodec<K, V> codec;
    private final ChainResolver<K, V> resolver;

    ClusteredWriteBehind(ClusteredWriteBehindStore<K, V> clusteredWriteBehindStore, ExecutorService executorService, ChainResolver<K, V> resolver, CacheLoaderWriter<? super K, V> cacheLoaderWriter, OperationsCodec<K, V> codec) {
        this.clusteredWriteBehindStore = clusteredWriteBehindStore;
        this.executorService = executorService;
        this.resolver = resolver;
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.codec = codec;
    }

    void flushWriteBehindQueue(Chain ignored, long hash) {
        this.executorService.submit(() -> {
            try {
                ServerStoreProxy.ChainEntry chain = this.clusteredWriteBehindStore.lock(hash);
                try {
                    if (!chain.isEmpty()) {
                        HashMap<K, PutOperation<K, V>> currentState = new HashMap<K, PutOperation<K, V>>();
                        for (Element element : chain) {
                            ByteBuffer payload = element.getPayload();
                            Operation<K, V> operation = this.codec.decode(payload);
                            K key = operation.getKey();
                            PutOperation<K, V> result = this.resolver.applyOperation(key, (PutOperation)currentState.get(key), operation);
                            try {
                                if (result != null) {
                                    if (result != currentState.get(key) && !(operation instanceof PutOperation)) {
                                        this.cacheLoaderWriter.write(result.getKey(), result.getValue());
                                    }
                                    currentState.put(key, result.asOperationExpiringAt(result.expirationTime()));
                                    continue;
                                }
                                if (currentState.get(key) != null && (operation instanceof RemoveOperation || operation instanceof ConditionalRemoveOperation)) {
                                    this.cacheLoaderWriter.delete(key);
                                }
                                currentState.remove(key);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ChainBuilder builder = new ChainBuilder();
                        for (PutOperation operation : currentState.values()) {
                            builder = builder.add(this.codec.encode(operation));
                        }
                        this.clusteredWriteBehindStore.replaceAtHead(hash, chain, builder.build());
                    }
                }
                finally {
                    this.clusteredWriteBehindStore.unlock(hash, false);
                }
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

