/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodecException;

public class SimpleClusterTierManagerClientEntity
implements ClusterTierManagerClientEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleClusterTierManagerClientEntity.class);
    private final EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint;
    private final LifeCycleMessageFactory messageFactory;

    public SimpleClusterTierManagerClientEntity(EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint) {
        this.endpoint = endpoint;
        this.messageFactory = new LifeCycleMessageFactory();
        endpoint.setDelegate(new EndpointDelegate<EhcacheEntityResponse>(){

            @Override
            public void handleMessage(EhcacheEntityResponse messageFromServer) {
            }

            @Override
            public byte[] createExtendedReconnectData() {
                return new byte[0];
            }

            @Override
            public void didDisconnectUnexpectedly() {
                LOGGER.info("CacheManager got disconnected from server");
            }
        });
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    @Override
    public void validate(ServerSideConfiguration config) throws ClusterException {
        this.invokeInternal(this.messageFactory.validateStoreManager(config));
    }

    @Override
    public Set<String> prepareForDestroy() {
        try {
            EhcacheEntityResponse.PrepareForDestroy response = (EhcacheEntityResponse.PrepareForDestroy)this.invokeInternal(this.messageFactory.prepareForDestroy());
            return response.getStores();
        }
        catch (ClusterException clusterException) {
            return null;
        }
    }

    private EhcacheEntityResponse invokeInternal(EhcacheEntityMessage message) throws ClusterException {
        try {
            EhcacheEntityResponse response = SimpleClusterTierManagerClientEntity.waitFor(this.invokeAsync(message));
            if (EhcacheResponseType.FAILURE.equals((Object)response.getResponseType())) {
                throw ((EhcacheEntityResponse.Failure)response).getCause();
            }
            return response;
        }
        catch (ExecutionException | MessageCodecException e) {
            throw new RuntimeException(message + " error: " + e, e);
        }
    }

    private Future<EhcacheEntityResponse> invokeAsync(EhcacheEntityMessage message) throws MessageCodecException {
        return this.endpoint.message(message).invoke();
    }

    private static <T extends EntityResponse> T waitFor(Future<T> future) throws ExecutionException {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                EntityResponse entityResponse = (EntityResponse)future.get();
                return (T)entityResponse;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

