/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ClientInstanceID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class LinearVoltronEntityMultiResponse
extends DSOMessageBase
implements VoltronEntityMultiResponse {
    private final byte OP_ID = 1;
    private final byte DONE_ID = (byte)2;
    private List<Op> timeline = new LinkedList<Op>();
    private boolean stopAdding;
    private long stopAddingTime;
    private long startAddingTime;
    private boolean started = false;
    private boolean immediateSend = false;

    @Override
    public int replay(VoltronEntityMultiResponse.ReplayReceiver receiver) {
        int count = 0;
        for (Op op : this.timeline) {
            switch (op.type) {
                case INVOKE_MESSAGE: {
                    receiver.message(new TransactionID(op.id), op.data);
                    break;
                }
                case RECEIVED: {
                    receiver.received(new TransactionID(op.id));
                    break;
                }
                case RESULT: {
                    receiver.result(new TransactionID(op.id), op.data);
                    break;
                }
                case SERVER_MESSAGE: {
                    receiver.message(new ClientInstanceID(op.id), op.data);
                    break;
                }
                case RESULT_RETIRED: {
                    receiver.result(new TransactionID(op.id), op.data);
                }
                case RETIRED: {
                    receiver.retired(new TransactionID(op.id));
                    break;
                }
                case DONE: {
                    receiver.stats(TransactionID.NULL_ID, new long[]{op.id});
                    break;
                }
                case STATS: {
                    ByteBuffer data = ByteBuffer.wrap(op.data);
                    long[] vals = new long[data.remaining() / 8];
                    for (int x = 0; x < vals.length; ++x) {
                        vals[x] = data.getLong();
                    }
                    receiver.stats(new TransactionID(op.id), vals);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unknown op");
                }
            }
            ++count;
        }
        return count;
    }

    public LinearVoltronEntityMultiResponse(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public LinearVoltronEntityMultiResponse(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBufferInputStream data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public synchronized TCNetworkMessage send() {
        return super.send();
    }

    @Override
    public boolean addReceived(TransactionID tid) {
        return this.buildOp(Operation.RECEIVED, tid.toLong(), null);
    }

    private synchronized boolean buildOp(Operation type, long id, byte[] data) {
        if (!this.stopAdding) {
            Op op = new Op(type, id, data);
            this.timeline.add(op);
            switch (type) {
                case DONE: {
                    this.stopAdding = true;
                }
                case RECEIVED: 
                case RESULT: 
                case RESULT_RETIRED: {
                    this.immediateSend = true;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addRetired(TransactionID tid) {
        return this.buildOp(Operation.RETIRED, tid.toLong(), null);
    }

    @Override
    public boolean addResult(TransactionID tid, byte[] result) {
        return this.buildOp(Operation.RESULT, tid.toLong(), result);
    }

    @Override
    public boolean addResultAndRetire(TransactionID tid, byte[] result) {
        return this.buildOp(Operation.RESULT_RETIRED, tid.toLong(), result);
    }

    @Override
    public boolean addServerMessage(ClientInstanceID cid, byte[] message) {
        return this.buildOp(Operation.SERVER_MESSAGE, cid.getID(), message);
    }

    @Override
    public boolean addServerMessage(TransactionID cid, byte[] message) {
        return this.buildOp(Operation.INVOKE_MESSAGE, cid.toLong(), message);
    }

    @Override
    public boolean addStats(TransactionID cid, long[] timings) {
        ByteBuffer buffer = ByteBuffer.allocate(timings.length * 8);
        for (long t : timings) {
            buffer.putLong(t);
        }
        return this.buildOp(Operation.STATS, cid.toLong(), buffer.array());
    }

    @Override
    public void stopAdding() {
        this.stopAddingTime = System.nanoTime();
        this.buildOp(Operation.DONE, this.stopAddingTime - this.startAddingTime, null);
        this.timeline = Collections.unmodifiableList(this.timeline);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        if (name == 1) {
            Operation type = Operation.values()[this.getShortValue()];
            long id = this.getLongValue();
            byte[] data = null;
            if (type.hasData()) {
                int len = this.getIntValue();
                data = new byte[len];
                this.getInputStream().readFully(data);
            }
            this.timeline.add(new Op(type, id, data));
            return true;
        }
        if (name == 2) {
            Assert.assertEquals(this.getIntValue(), this.timeline.size());
            return true;
        }
        return false;
    }

    @Override
    protected void dehydrateValues() {
        int count = 0;
        for (Op op : this.timeline) {
            this.putNVPair((byte)1, (short)op.type.ordinal());
            this.getOutputStream().writeLong(op.id);
            if (op.type.hasData()) {
                this.getOutputStream().writeInt(op.data.length);
                this.getOutputStream().write(op.data);
            }
            ++count;
        }
        this.putNVPair((byte)2, count);
    }

    @Override
    public synchronized boolean startAdding() {
        if (!this.started) {
            this.startAddingTime = System.nanoTime();
            this.started = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldSend() {
        return this.immediateSend;
    }

    private static class Op {
        private final Operation type;
        private final long id;
        private final byte[] data;

        public Op(Operation type, long id, byte[] data) {
            this.type = type;
            this.id = id;
            this.data = data;
        }

        public Op(byte[] raw) {
            ByteBuffer reader = ByteBuffer.wrap(raw);
            this.type = Operation.values()[reader.getInt()];
            this.id = reader.getLong();
            this.data = new byte[reader.remaining()];
            reader.get(this.data);
        }

        public byte[] convert() {
            ByteBuffer buffer = ByteBuffer.allocate(12 + this.data.length);
            buffer.putInt(this.type.ordinal());
            buffer.putLong(this.id);
            if (this.data != null) {
                buffer.put(this.data);
            }
            return buffer.array();
        }
    }

    public static enum Operation {
        RECEIVED,
        RETIRED,
        RESULT{

            @Override
            boolean hasData() {
                return true;
            }
        }
        ,
        SERVER_MESSAGE{

            @Override
            boolean hasData() {
                return true;
            }
        }
        ,
        INVOKE_MESSAGE{

            @Override
            boolean hasData() {
                return true;
            }
        }
        ,
        RESULT_RETIRED{

            @Override
            boolean hasData() {
                return true;
            }
        }
        ,
        DONE,
        STATS{

            @Override
            boolean hasData() {
                return true;
            }
        };


        boolean hasData() {
            return false;
        }
    }
}

