/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.request;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.object.ClientInstanceID;
import com.tc.object.request.RequestResponseHandler;
import com.tc.object.tx.TransactionID;
import com.tc.text.PrettyPrintable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

public class MultiRequestReceiveHandler
extends AbstractEventHandler<VoltronEntityMultiResponse>
implements PrettyPrintable {
    private final RequestResponseHandler handler;
    private final LongAdder opCount = new LongAdder();
    private final LongAdder msgCount = new LongAdder();

    public MultiRequestReceiveHandler(RequestResponseHandler handler) {
        this.handler = handler;
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        map.put("opCount", this.opCount.longValue());
        map.put("msgCount", this.msgCount.longValue());
        return map;
    }

    @Override
    public void handleEvent(VoltronEntityMultiResponse response) throws EventHandlerException {
        this.msgCount.increment();
        response.replay(new VoltronEntityMultiResponse.ReplayReceiver(){

            @Override
            public void received(TransactionID tid) {
                MultiRequestReceiveHandler.this.opCount.increment();
                MultiRequestReceiveHandler.this.handler.received(tid);
            }

            @Override
            public void retired(TransactionID tid) {
                MultiRequestReceiveHandler.this.opCount.increment();
                MultiRequestReceiveHandler.this.handler.retired(tid);
            }

            @Override
            public void result(TransactionID tid, byte[] result) {
                MultiRequestReceiveHandler.this.opCount.increment();
                if (result != null) {
                    MultiRequestReceiveHandler.this.handler.complete(tid, result);
                } else {
                    MultiRequestReceiveHandler.this.handler.complete(tid);
                }
            }

            @Override
            public void message(ClientInstanceID cid, byte[] message) {
                MultiRequestReceiveHandler.this.opCount.increment();
                MultiRequestReceiveHandler.this.handler.handleMessage(cid, message);
            }

            @Override
            public void message(TransactionID tid, byte[] message) {
                MultiRequestReceiveHandler.this.opCount.increment();
                MultiRequestReceiveHandler.this.handler.handleMessage(tid, message);
            }

            @Override
            public void stats(TransactionID tid, long[] message) {
                MultiRequestReceiveHandler.this.opCount.increment();
                MultiRequestReceiveHandler.this.handler.handleStatistics(tid, message);
            }
        });
    }
}

