/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayer;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.RestoreConnectionCallback;
import com.tc.util.Assert;
import java.util.TimerTask;

public class OOOReconnectionTimeout
implements MessageTransportListener,
RestoreConnectionCallback {
    private static final boolean debug = false;
    private final OnceAndOnlyOnceProtocolNetworkLayer oooLayer;
    private final long timeoutMillis;
    private TimeoutTimerTask timeoutTimerTask = null;

    public OOOReconnectionTimeout(OnceAndOnlyOnceProtocolNetworkLayer oooLayer, long timeoutMillis) {
        this.oooLayer = oooLayer;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public synchronized void notifyTransportClosed(MessageTransport transport) {
        OOOReconnectionTimeout.log(transport, "Transport Closed");
        this.oooLayer.notifyTransportClosed(transport);
    }

    @Override
    public synchronized void notifyTransportConnectAttempt(MessageTransport transport) {
        this.oooLayer.notifyTransportConnectAttempt(transport);
    }

    @Override
    public synchronized void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        Assert.assertNull(this.timeoutTimerTask);
        if (this.oooLayer.isClosed()) {
            return;
        }
        if (forcedDisconnect) {
            OOOReconnectionTimeout.log(transport, "Transport FORCE Disconnected, skipping opening reconnect window");
            this.oooLayer.connectionRestoreFailed();
        } else {
            OOOReconnectionTimeout.log(transport, "Transport Disconnected, starting Timer for " + this.timeoutMillis);
            this.oooLayer.startRestoringConnection();
            this.oooLayer.notifyTransportDisconnected(transport, forcedDisconnect);
            this.timeoutTimerTask = new TimeoutTimerTask(transport, this);
            this.oooLayer.getRestoreConnectTimer().schedule((TimerTask)this.timeoutTimerTask, this.timeoutMillis);
        }
    }

    @Override
    public synchronized void notifyTransportConnected(MessageTransport transport) {
        if (this.timeoutTimerTask != null) {
            OOOReconnectionTimeout.log(transport, "Transport Connected, killing Timer for " + this.timeoutMillis);
            this.cancelTimerTask();
        }
        this.oooLayer.notifyTransportConnected(transport);
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.oooLayer.notifyTransportReconnectionRejected(transport);
    }

    private void cancelTimerTask() {
        this.timeoutTimerTask.cancel();
        this.timeoutTimerTask = null;
    }

    @Override
    public synchronized void restoreConnectionFailed(MessageTransport transport) {
        if (this.timeoutTimerTask != null) {
            OOOReconnectionTimeout.log(transport, "Restore Connection Failed, killing Timer for " + this.timeoutMillis);
            this.oooLayer.connectionRestoreFailed();
            this.cancelTimerTask();
        }
    }

    private static void log(MessageTransport transport, String msg) {
    }

    static class TimeoutTimerTask
    extends TimerTask {
        private final MessageTransport transport;
        private final RestoreConnectionCallback rcc;

        public TimeoutTimerTask(MessageTransport transport, RestoreConnectionCallback rcc) {
            this.transport = transport;
            this.rcc = rcc;
        }

        @Override
        public void run() {
            this.rcc.restoreConnectionFailed(this.transport);
        }
    }
}

